/*****************************************
 PROJEKT: Quix
 ZWECK: Leitet Absender, Subject und Teil
        einer ankommenden Mail an Quix weiter

 AUTOR: Marek Tomczyk (E-mail: Marek.Tomczyk@stud.uni-karlsruhe.de)
 DATUM: 11.08.1997
 
 AENDERUNGSHISTORIE

 AENDERUNG:
 AUTOR:
 DATUM:

 VERSION: 1.0

 Copyright (C) 1997 Marek Tomczyk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

******************************************/ 

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "list.h"
#include "quix.h"


int main()
{
  mailT *subj_ele  = NULL,
        *subj_ele_last = NULL;
  int   found = FALSE;
  char  *tempstring = NULL,
        *chptr      = NULL, 
        command[BUFLEN] = "",
        cmdbuf[BUFLEN] = "",
        *new_history_ele = NULL,
        *history_ele = NULL,
        *history_ele_last = NULL,
        *tempfile1 = "blubber........";
  int status = OK; 
  FILE *subject_file = NULL;
  FILE *history_file = NULL;
  LIST *subjects = NULL,
       *history = NULL;

  /* run system-command to check for mail */
  sprintf(command, "%s > %s", MAILCHECK, tempfile1);
  status = system(command);
  if (status != OK)
    {
      switch(status)
	{
	case 512: printf("No Mail\n");
	  break;
	default:
	  printf("Problem with \"%s\". Status: %d\n", MAILCHECK, status);
	  exit(status);
	  break;
	}
    }

  /* tempfile1 contains output of previous mail checking */
  subject_file = fopen(tempfile1, "r");

  /* read file into a list */
  if (subject_file != NULL)
    {
      subjects = lst_init();
      subj_ele_last = LST_HEAD(subjects);
      while ((fgets(cmdbuf, BUFLEN, subject_file)) != NULL)
	{
	  cmdbuf[strlen(cmdbuf) - 1] = '\0';  /* Newline entfernen            */
	  subj_ele = lst_newnode(sizeof(mailT));
	  subj_ele->subject = (char *)malloc((strlen(cmdbuf)+1)*sizeof(char));
	  /*	  subj_ele = lst_newnode((strlen(cmdbuf)+1)*sizeof(char)); */
	  tempstring = (char *)malloc((strlen(cmdbuf)+1)*sizeof(char));
	  tempstring[0] = '\0';

	  /* Suche ersten Doppelpunkt im Buffer - davor steht die Indexnummer der Mail */
	  chptr = strchr(cmdbuf, ':');
	  
	  /* Index vorhanden */
	  if (chptr != NULL)
	    {
	      /* nur den Index herauszeiehen und merken */
	      strncpy(tempstring, cmdbuf, chptr-cmdbuf);
	      tempstring[chptr-cmdbuf] = '\0';
	      subj_ele->index = atoi(tempstring);
	      
	      /* Anfang des Subjects suchen - den Rest verarbeiten */
	      while (isgraph(*(++chptr)) == FALSE) {}
	      strcpy(subj_ele->subject, chptr);
	    }
	  else
	    {
	      /* kein Index vorhanden */
	      subj_ele->index = 0;
	      strcpy(subj_ele->subject, cmdbuf);
	    }
	  subj_ele->mailcontent = NULL;
	  lst_insertafter(subjects, subj_ele, subj_ele_last);
	  subj_ele_last = subj_ele;

	  /* Speicher wieder freigeben */
	  free(tempstring);
	} /* while */
      fclose(subject_file);
  
      /* History-File lesen */
      history_file = fopen(QUIXHISTORY, "r");
      history = lst_init();

      if (history_file != NULL)
	{
	  history_ele_last = LST_HEAD(history);
	  while ((fgets(cmdbuf, BUFLEN, history_file)) != NULL)
	    {
	      cmdbuf[strlen(cmdbuf) - 1] = '\0';  /* Newline entfernen            */
	      history_ele = lst_newnode((strlen(cmdbuf)+1)*sizeof(char));
	      strcpy(history_ele, cmdbuf);
	      lst_insertafter(history, history_ele, history_ele_last);
	      history_ele_last = history_ele;
	    } /* while */
	  fclose(history_file);
	}
      
      subj_ele = LST_HEAD(subjects);
      while ((subj_ele = lst_next(subj_ele)) != NULL)
	{
	  found = lookup_history(history, subj_ele->subject);
	  if (found == TRUE)
	    {
	      /* printf("alt blobber_klux: {%s} - Index: %d\n", subj_ele->subject, subj_ele->index); */
	    }
	  else
	    {
	      /* holt bei einer neuen Mail auch den Mailinhalt */
	      get_mailtextF(subj_ele);

	      printf("new blobber_klux: {%s} - Index: %d\n", subj_ele->subject, subj_ele->index);
	      printf("Inhalt: {%s}\n", subj_ele->mailcontent);

	      /* alles wird zum Senden vorbereitet und dann abgeschickt */
	      send_quix(subj_ele, QUIXADDR);

	      /* In das History-File uebernehmen */
	      new_history_ele = lst_newnode((strlen(subj_ele->subject)+1)*sizeof(char));
	      strcpy(new_history_ele, subj_ele->subject);
	      lst_insertfirst(history, new_history_ele);
	    }
	}
      write_history(QUIXHISTORY, history);
    }
  
  status = unlink(tempfile1);
  if (status != OK)
    {
      printf("Could not delete {%s}\nStatus: %d\n", tempfile1, status);
      exit(status);
    }
    
} /* main */

/*************************************
BESCHREIBUNG: Holt Inhalt einer Mail
              mit Hilfe des Systemkommandos
              'readmsg' anhand der Indexnummer
AUTOR: Marek Tomczyk
DATUM: 24.07.1997
*************************************/

get_mailtextF(mailT *mail)
{
  int    length = 0,
         status = OK;
  FILE   *tmpfil = NULL;
  char   command[BUFLEN] = "",
         mailinhalt[BUFLEN] = "",
         *tmpfil_name = ".sdhjhgfffffff...";
  
  sprintf(command, "%s %d > %s", READMSG, mail->index, tmpfil_name);
  system(command);
  
  /* tmpfil enthaelt den Mailinhalt */
  tmpfil = fopen(tmpfil_name, "r");

  /* Anfang der Mail einlesen */
  if (tmpfil != NULL)
    {
      while (((fgets(command, BUFLEN, tmpfil)) != NULL) && (length < 90))
	{
	  command[strlen(command) - 1] = '\0'; /* newline entfernen */
	  if (strlen(command) > 0)
	    strcat(mailinhalt, " ");
	  strcat(mailinhalt, command);
	  length = strlen(mailinhalt);
	}
      fclose(tmpfil);
      mail->mailcontent = (char *)malloc((++length)*sizeof(char));
      strcpy(mail->mailcontent, mailinhalt);
    }
  else
    {
      /* Irgend ein Problem... egal */
      mail->mailcontent = NULL;
    }
  
  status = unlink(tmpfil_name);
  if (status != OK)
    {
      printf("Could not delete {%s}\nStatus: %d\n", tmpfil_name, status);
    }
}


/* send quix */
send_quix(mailT *mail, char *empfaenger)
{
  char command_buf[BUFLEN] = "",
       new_subject[BUFLEN] = "";
  char *char_ptr = NULL,
       *clean_subject = NULL,
       *clean_content = NULL;
  
  clean_subject = (char *)kill_blankF(mail->subject);
  sprintf(new_subject, "%s#%s", clean_subject, mail->mailcontent);
  new_subject[80] = '\0'; /* auf maximale Laenge abschneiden */
  printf("new_subject: {%s}\n", new_subject);

  if ((char_ptr = strchr(new_subject, '@')) != NULL)
        {
        (*char_ptr) = ' ';
        }
  sprintf(command_buf, "echo \".\" | %s -s \"%s\" %s", MAILCMD, new_subject, empfaenger);
  system(command_buf);

}/* send_quix */


/*******************************************/
/* Ueberfluessige Leerzeichen wegmachen    */
/*******************************************/

char *kill_blankF(char *instr)
{
  char *newstr = NULL,
       *chptr_in = NULL,
       *chptr_out = NULL;
  

  if (strlen(instr) > 0)
    {
      newstr = (char *)malloc((strlen(instr)+1)*sizeof(char));
      strcpy(newstr, instr);
      chptr_in = newstr;
      chptr_out = newstr;
      while (*(++chptr_in) != '\0')
	{
	  chptr_in--;
	  if ((*chptr_in != ' ') || (chptr_in[1] != ' '))
	    {
	      *chptr_out = *chptr_in;
	      chptr_out++;
	    }
	  chptr_in++;
	}
      *chptr_out = *(--chptr_in);
      *(++chptr_out) = '\0';
      return newstr;
    }
  else
    return instr;
}


/* lookup_history */
/* sucht Eintrag in der Liste */

int lookup_history(LIST *history, char *eintrag)
{
  char *history_ele = NULL;

  history_ele = LST_HEAD(history);
  while ((history_ele = lst_next(history_ele)) != NULL)
    {
      if (!strcmp(history_ele, eintrag))
	return(TRUE);
    } /* while */
  return (FALSE);

} /* lookup_history */


/*******************************/
/* write history file
 */

write_history(char *history_filename, LIST *history)
{
  char *history_ele = NULL;
  FILE *history_file = NULL;

  history_file = fopen(history_filename, "w");

  if (history_file != NULL)
    {
      history_ele = LST_HEAD(history);
      while ((history_ele = lst_next(history_ele)) != NULL)
	{
	  fprintf(history_file, "%s\n", history_ele);
	} /* while */
      fclose(history_file);
    }
} /* write_history */





