/* atarimap.h
 */

/* prefixes:
 *	B 	- byte storage
 *	W	- word storage 
 *	T	- table storage
 *	C	- executable code
 */

#define W_VDSLST	0x200
#define W_VPRCED	0x202
#define W_VINTER	0x204
#define W_VBREAK	0x206
#define W_VKEYBD	0x208
#define W_VSERIN	0x20a
#define W_VSEROR	0x20c
#define W_VTIMR1	0x210
#define W_VTIMR2	0x212
#define W_VTIMR4	0x214
#define W_VIMIRQ	0x216
#define W_CDTMV1	0x218
#define W_CDTMV2	0x21a
#define W_CDTMV3	0x21c
#define W_CDTMV4	0x21e
#define W_CDTMV5	0x220
#define W_VVBLKI	0x222
#define W_VVBLKD	0x224
#define W_CDTMA1	0x226
#define W_CDTMA2	0x228
#define B_CDTMF3	0x22a
#define B_SRTIMR	0x22b
#define B_CDTMF4	0x22c
#define B_INTEMP	0x22d
#define B_CDTMF5	0x22e
#define B_SDMCTL	0x22f
#define W_SDLSTL	0x230
#define B_SSKCTL	0x232

#define W_RUNAD 	0x2e0	
#define W_INITAD	0x2e2
#define B_RAMSIZ	0x2e4
#define	W_MEMTOP	0x2e5
#define W_MEMLO		0x2e7
#define T_DVSTAT	0x2ea
#define W_CBAUD		0x2ee
#define B_CRSINH	0x2f0
#define B_KEYDEL	0x2f1
#define B_CH1		0x2f2
#define B_CHACT		0x2f3
#define B_CHBAS		0x2f4
#define B_CHAR		0x2fa
#define B_ATACHR	0x2fb
#define B_CH		0x2fc
#define B_FILDAT	0x2fd
#define B_DSPFLG	0x2fe
#define B_SSFLAG	0x2ff

#define B_DDEVIC	0x300
#define B_DUNIT		0x301
#define B_DCOMND	0x302
#define B_DSTATS	0x303
#define W_DBUFLO	0x304
#define B_DTIMLO	0x306
#define W_DBYTLO	0x308
#define B_DAUX1		0x30a
#define B_DAUX2		0x30b
#define W_TIMER1	0x30c
#define B_CASFLG	0x30f
#define W_TIMER2	0x310
#define T_HATABS	0x31a

#define T_IOCB0		0x340

/* Floating Point */
#define C_AFP		0xd800
#define C_FASC		0xd8e6
#define C_IFP		0xd9aa
#define C_FPI		0xd9d2
#define C_ZFR0		0xda44
#define C_ZF1		0xda46
#define C_FSUB		0xda60
#define C_FADD		0xda66
#define C_FMUL		0xdadb
#define C_FDIV		0xdb28
#define C_PLYEVL	0xdd40
#define C_FLD0R		0xdd89
#define C_FLD0P		0xdd8d
#define C_FLD1R		0xdd98
#define C_FLD1P		0xdd9c
#define C_FST0R		0xdda7
#define C_FST0P		0xddab
#define C_FMOVE		0xddb6
#define C_EXP		0xddc0
#define C_EXP10		0xddcc
#define C_LOG		0xdecd
#define C_LOG10		0xded1

/* OS vectors */
#define C_DISKIV	0xe450
#define C_DSKINV	0xe453
#define C_CIOV		0xe456
#define C_SIOV		0xe459
#define C_SETVBV	0xe45c
#define C_SYSVBV	0xe45f
#define C_XITVBV	0xe462
#define C_SIOINV	0xe465
#define C_SENDEV	0xe468
#define C_INTINV	0xe46b
#define C_CIOINV	0xe46e
#define C_BLKBDV	0xe471
#define C_WARMSV	0xe474
#define C_COLDSV	0xe477
#define C_RBLOKV	0xe47a
#define C_CSOPIV	0xe47d
#define C_VCTABL	0xe480


