#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <graphics.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "vga.h"

//***************************setup_colors**********************************
//	This is how I set up the color palette
//	The colors do not exactly match the atari colors, but hey...
//*************************************************************************
void setup_colors(void)
{
      struct REGPACK regs;
      int i;


//open for mode graphics 0x13
      regs.r_ax = 0x0013;
      intr(0x10, &regs);
//setup palette
      char palette[256][3];
      float s;
      int hm = 16;
      int lm = 16;
      for (int y=0;y<lm;y++)
	 for (int h=0;h<hm;h++)
	 {
	    if (h==0) s=0;
	    else s=1;
	    float hue = ((hm-h-1+hm/2-3)%hm)*0.375;
	    i = floor(hue);
	    float v = (y+1)*(63./lm);
	    float f = hue-i;
	    float p = v*(1-s);
	    float q = v*(1-(s*f));
	    float t = v*(1-(s*(1-f)));
	    switch (i) {
	    case 0:
	       palette[h*lm+y][0] = v;
	       palette[h*lm+y][1] = t;
	       palette[h*lm+y][2] = p;
	       break;
	    case 1:
	       palette[h*lm+y][0] = q;
	       palette[h*lm+y][1] = v;
	       palette[h*lm+y][2] = p;
	       break;
	    case 2:
	       palette[h*lm+y][0] = p;
	       palette[h*lm+y][1] = v;
	       palette[h*lm+y][2] = t;
	       break;
	    case 3:
	       palette[h*lm+y][0] = p;
	       palette[h*lm+y][1] = q;
	       palette[h*lm+y][2] = v;
	       break;
	    case 4:
	       palette[h*lm+y][0] = t;
	       palette[h*lm+y][1] = p;
	       palette[h*lm+y][2] = v;
	       break;
	    case 5:
	       palette[h*lm+y][0] = v;
	       palette[h*lm+y][1] = p;
	       palette[h*lm+y][2] = q;
	       break;
	 }
     }
      regs.r_es = FP_SEG(palette);
      regs.r_dx = FP_OFF(palette);
      regs.r_ax = 0x1012;
      regs.r_bx = 0;
      regs.r_cx = 0x100;
      intr(0x10, &regs);

}

//**********************************open graphics screen********************
//	Checks for VGA card and sets up display
//	Uses Borland's BGI routines
//**************************************************************************
void gr_open(void)
{
   int gdriver, gmode, i;
   int errorcode;

//only open graphics screen once
   if (!video_flag)
   {
      detectgraph(&gdriver,&gmode);
      gmode = VGAHI;
      if (gdriver == VGA) initgraph(&gdriver,&gmode,"c:\\borlandc\\bgi");
      else {puts("No VGA hardware detected"); exit(1); }

      errorcode = graphresult();
      if (errorcode != grOk)  /* an error occurred */
      {
	 printf("Graphics error: %s\n", grapherrormsg(errorcode));
	 printf("Press any key to halt:");
	 getch();
	 exit(1); /* terminate with an error code */
      }
      ++video_flag;      //we have opened the graphics screen
   }
}

void gr_close(void) {gr_open(); closegraph(); video_flag =0;};

void wr_status(char *ch)
{
   struct REGPACK regs;
   regs.r_ax = 0x1301;
   regs.r_bx = 0x0f;
   regs.r_cx = strlen(ch);
   regs.r_dx =0x1800;
   regs.r_es = FP_SEG(ch);
   regs.r_bp = FP_OFF(ch);
   intr(0x10,&regs);
}

