#include "atari.h"

class ANTIC;
//define a new type
typedef void (ANTIC::*Patype)();
extern Patype amodes[];

#define MDLI 0x80
#define MVSCROL 0x20
#define MHSCROL 0x10
#define MMSCAN  0x40

class ANTIC
{
public:
   Word dlist;		//display list address
   Byte dinstr;		//current dlist instruction
   Word pc;		//current ANTIC program counter
   Word evcount;	//extended vertical counter
   Word memscan;	//memory scan counter
   Byte wait;           //jvb flag
   Byte vscrol;		//vscrol flag
   Byte sc;		//used to tell gtia how many lines to display
   Byte dliflag;	//do dli?
   Byte ram[0x20];	//write to hardware, no read back

//constructor routines
   ANTIC(void);
   void update(Word,Byte);
   void mode0(void);
   void mode1(void);
   void mode2(void);
   void mode3(void);
   void mode4(void);
   void mode5(void);
   void mode6(void);
   void mode7(void);
   void mode8(void);
   void mode9(void);
   void mode10(void);
   void mode11(void);
   void mode12(void);
   void mode13(void);
   void mode14(void);
   void mode15(void);

};