#ifndef b0

//Define some special types
typedef unsigned char Byte;
typedef unsigned Word;
typedef char Pin;		//external chip pins
typedef signed char Status;

//define numeric bit positions
#define b0 1
#define b1 2
#define b2 4
#define b3 8
#define b4 16
#define b5 32
#define b6 64
#define b7 128

//Atari hardware registers
#define ALLPOT 	0xd208
#define AUDC1	0xd201
#define AUDC2 	0xd203
#define AUDC3   0xd205
#define AUDC4	0xd207
#define AUDCTL	0xd208
#define AUDF1	0xd200
#define AUDF2	0xd202
#define AUDF3	0xd204
#define AUDF4	0xd206
#define CHACTL	0xd401
#define CHBASE	0xd409
#define COLBK	0xd01a
#define COLPF0	0xd016
#define COLPF1	0xd017
#define COLPF2	0xd018
#define COLPF3	0xd019
#define COLPM0	0xd012
#define COLPM1	0xd013
#define COLPM2	0xd014
#define COLPM3	0xd015
#define CONSOL	0xd01f
#define DLISTH	0xd403
#define DLISTL	0xd402
#define DMACTL	0xd400
#define GRACTL	0xd01d
#define GRAFM	0xd011
#define GRAFP0	0xd00d
#define GRAFP1	0xd00e
#define GRAFP2	0xd00f
#define GRAFP3	0xd010
#define HITCLR	0xd01e
#define HPOSM0	0xd004
#define HPOSM1	0xd005
#define HPOSM2	0xd006
#define HPOSM3	0xd007
#define HSCROL	0xd404
#define IRQEN	0xd20e
#define IRQST	0xd20e
#define KBCODE	0xd209
#define M0PF	0xd000
#define M0PL	0xd008
#define M1PF	0xd001
#define M1PL	0xd009
#define M2PF	0xd002
#define M2PL	0xd00a
#define M3PF	0xd003
#define M3PL	0xd00b
#define NMIEN	0xd40e
#define NMIRES	0xd40f
#define NMIST	0xd40f
#define P0PF	0xd004
#define P0PL	0xd00c
#define P1PF	0xd005
#define P1PL	0xd00d
#define P2PF	0xd006
#define P2PL	0xd00e
#define P3PF	0xd007
#define P3PL	0xd00f
#define PACTL	0xd302
#define PAL	0xd014
#define PBCTL	0xd303
#define PENH	0xd40c
#define PENV	0xd40d
#define PMBASE	0xd407
#define PORTA	0xd300
#define PORTB	0xd301
#define POT0	0xd200
#define POT1	0xd201
#define POT2	0xd202
#define POT3	0xd203
#define POTGO	0xd20b
#define PRIOR	0xd01b
#define RANDOM	0xd20a
#define SERIN	0xd20e
#define SEROUT	0xd20d
#define SIZEM	0xd00c
#define SIZEP0	0xd008
#define SIZEP1	0xd009
#define SIZEP2	0xd00a
#define SIZEP3	0xd00b
#define SKCTL	0xd20f
#define SKRES	0xd20a
#define SKSTAT	0xd20f
#define STIMER	0xd209
#define TRIG0	0xd010
#define TRIG1	0xd011
#define TRIG2	0xd012
#define TRIG3	0xd013
#define VCOUNT	0xd40b
#define VDELAY	0xd01c
#define VSCROL	0xd405
#define WSYNC	0xd40a

//Shadow registers
#define CHART	0x2f3
#define CHBAS	0x2f4
#define COLOR4	0x2c8
#define COLOR0	0x2c4
#define COLOR1	0x2c5
#define COLOR2	0x2c6
#define COLOR3	0x2c7
#define PCOLR0	0x2c0
#define PCOLR1	0x2c1
#define PCOLR2	0x2c2
#define PCOLR3	0x2c3
#define SDLSTH	0x231
#define SDLSTL	0x230
#define SDMCTL	0x22f
#define POKMSK	0x010
#define CH	0x2fc
#define LPENH	0x234
#define LPENV	0x235
#define STICK0	0x278
#define STICK1	0x279
#define STICK2	0x27a
#define STICK3	0x27b
#define PADDL0	0x270
#define PADDL1	0x271
#define PADDL2	0x272
#define PADDL3	0x273
#define PADDL4	0x274
#define PADDL5	0x275
#define PADDL6	0x276
#define PADDL7	0x277
#define GPRIOR	0x26f
#define SSKCTL	0x232
#define STRIG0	0x284
#define STRIG1	0x285
#define STRIG2	0x286
#define STRIG3	0x287

//OS defines
#define DDEVIC 0x0300
#define DUNIT  0x0301
#define DCOMND 0x0302
#define DSTATS 0x0303
#define DBUFLO 0x0304
#define DBUFHI 0x0305
#define DTIMLO 0x0306
#define DUNUSE 0x0307
#define DBYTLO 0x0308
#define DBYTHI 0x0309
#define DAUX1  0x030a
#define DAUX2  0x030b
#endif