#include "gita.h"
#include <conio.h>
#include <stdlib.h>
#include "a6502.h"
#include "dos.h"

extern m6502 cpu;
extern GITA pm;

#define LB 0x1f

GITA::GITA(void)
{
   nmiflag = 0;
   cpu.ram[CONSOL] = 0x7;
}

GITA::~GITA(void)
{
   nmiflag = 1;
}

void GITA::setup(void)
{
   cpu.ram[PAL] = 7;
   //joystick button not pressed
   for (int i=0;i<4;i++) cpu.ram[0xd010+i] = 0x0001;

}

void GITA::update(Word addr, Byte data)
{
   ram[addr&LB] = data;
   if ((addr&LB) == 0x1e) for (Word i=0;i<0x10;i++) cpu.ram[0xd000+i] = 0;
}

//void GITA::missle(void);
//void GITA::player(void);


