
/* table of triples for optimizer.  see optimize.c */

#define NULL 0

/* triples for generic optimizer.  given (a, b, c) if see jsr a followed
   by jsr b, replace with jsr c */

#ifdef smallc
extern int triples[];	/* defined in ccmisc.m65 */
#else

#ifdef COMMENTS
char * triples[] =
{
  "locysp", "ldaxi", "ldaxysp\t\t; Load AX from SP@(Y)",
  "locysp", "ldai", "ldaysp\t\t; Load A from SP@(Y)",
  "ldaxysp", "pushax", "pushwysp\t\t; Push word SP@(Y)",
  "ldaysp", "pushax", "pushbysp\t\t; Push byte SP@(Y)",
  "ldaxysp", "swapsreg", "ldsrysp\t\t; Load SREG from SP@(Y)",
  "indexax", "ldaxi", "ldaxidx\t\t; Load AX from AX@(Y)",
  "indexax", "ldai", "ldaidx\t\t; Load A from AX@(Y)",
  "ldaxidx", "pushax", "pushwidx\t\t; Push word at AX@(Y)",
  "ldaidx", "pushax", "pushbidx\t\t; Push byte at AX@(Y)",
  "indexax", "pushax", "plocidx\t\t; Push location AX@(Y)",
  "ldaxi", "pushax", "pushwaxi\t\t; Push word at AX@",
  "ldai", "pushax", "pushbaxi\t\t; Push byte at AX@",
  "popsreg", "staxsreg", "staxspp\t\t; Store AX thru (SP)@+",
  "popsreg", "stasreg", "staspp\t\t; Store A thru (SP)@+",
  "locysp", "pushax", "plocysp\t\t; Push location SP@(Y)",
  "ldaxi", "incax1", "incaxi1\t\t; Ldax indirect and inc",
  "ldaxi", "incax2", "incaxi2\t\t; Ldax indirect and inc",
  "ldaxi", "decax1", "decaxi1\t\t; Ldax indirect and dec",
  "ldaxi", "decax2", "decaxi2\t\t; Ldax indirect and dec",
  0};
#else
/* save a little space by avoiding duplicates of string konsts */

static char locysp[] = "locysp";
static char ldaxi[] = "ldaxi";
static char ldaxysp[] = "ldaxysp";
static char ldai[] = "ldai";
static char ldaysp[] = "ldaysp";
static char pushax[] = "pushax";
static char pushwysp[] = "pushwysp";
static char pushbysp[] = "pushbysp";
static char indexax[] = "indexax";
static char ldaxidx[] = "ldaxidx";
static char ldaidx[] = "ldaidx";
static char pushwidx[] = "pushwidx";
static char pushbidx[] = "pushbidx";
static char plocidx[] = "plocidx";
static char pushwaxi[] = "pushwaxi";
static char pushbaxi[] = "pushbaxi";
static char plocysp[] = "plocysp";

char * triples[] =
{
  locysp, ldaxi, ldaxysp,
  locysp, ldai, ldaysp,
  ldaxysp, pushax, pushwysp,
  ldaysp, pushax, pushbysp,
/*     	"ldaxysp",	"swapsreg",	"ldsrysp",	*/
  indexax, ldaxi, ldaxidx,
  indexax, ldai, ldaidx,
  ldaxidx, pushax, pushwidx,
  ldaidx, pushax, pushbidx,
  indexax, pushax, plocidx,
  ldaxi, pushax, pushwaxi,
  ldai, pushax, pushbaxi,
/*	"popsreg",	"staxsreg",	"staxspp",	*/
/*	"popsreg",	"stasreg",	"staspp",	*/
  locysp, pushax, plocysp,
/*
	ldaxi,		"incax1",	"incaxi1",
	ldaxi,		"incax2",	"incaxi2",
	ldaxi,		"decax1",	"decaxi1",
	ldaxi,		"decax2",	"decaxi2",
*/
  0};
#endif /* comments */
#endif /* smallc */
