
/* CCCMD.C - look up reserved words */

#include <stdio.h>
#include "cc65.h"
#include "cclex.h"

#ifdef old_cruft
struct kw keywords[] = {
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"if", IF, 0},
			 {"long", LONG, 0},
			 {"register", REGISTER, 0},
			 {"static", STATIC, 0},
			 {"else", ELSE, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"char", CHAR, 0x0f},
			 {"goto", GOTO, 0},
			 {"typedef", TYPEDEF, 0},
			 {"case", CASE, 0},
			 {NULL, 0, 0},
			 {"enum", ENUM, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"sizeof", SIZEOF, 0},
			 {NULL, 0, 0},
			 {"return", RETURN, 0},
			 {NULL, 0, 0},
			 {"extern", EXTERN, 0},
			 {NULL, 0, 0},
			 {"asm", ASM, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"double", DOUBLE, 0},
			 {"float", FLOAT, 0x1e},
			 {"void", VOID, 0},
			 {NULL, 0, 0},
			 {"int", INT, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"short", SHORT, 0},
			 {"for", FOR, 0},
			 {"unsigned", UNSIGNED, 0},
			 {NULL, 0, 0},
#ifdef M6502
			 {"auto", STATIC, 0},	/* fold these together here... */
#else
			 {"auto", AUTO, 0},
#endif
			 {"break", BREAK, 0x2b},
			 {"switch", SWITCH, 0},
			 {NULL, 0, 0},
			 {"struct", STRUCT, 0},
			 {NULL, 0, 0},
			 {"continue", CONTINUE, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"while", WHILE, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"do", DO, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"default", DEFAULT, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {NULL, 0, 0},
			 {"union", UNION, 0},
			 {"entry", ENTRY, 0}
};
#else
struct tok_elt keywords[] =
{
  {"if", IF},
  {"long", LONG},
  {"register", REGISTER},
  {"static", STATIC},
  {"else", ELSE},
  {"char", CHAR},
  {"goto", GOTO},
/* never used?     { "typedef", TYPEDEF },	*/
  {"case", CASE},
#ifndef M6502
/* don't do enums in the native compiler */
  {"enum", ENUM},
#endif
  {"sizeof", SIZEOF},
  {"return", RETURN},
  {"extern", EXTERN},
/* old cruft
    { "asm", ASM },
*/
  {"double", DOUBLE},
  {"float", FLOAT},
  {"void", VOID},
  {"int", INT},
  {"short", SHORT},
  {"for", FOR},
  {"unsigned", UNSIGNED},
#ifdef M6502
  {"auto", STATIC}, /* fold these together here... */
#else
  {"auto", AUTO},
#endif
  {"break", BREAK},
  {"switch", SWITCH},
  {"struct", STRUCT},
  {"continue", CONTINUE},
  {"while", WHILE},
  {"do", DO},
  {"default", DEFAULT},
  {"union", UNION},
/* what the fuck's this?    { "entry", ENTRY }, */
  {0, 0}
};
#endif

/*
char a_strcmp[] = {
    0x68, 0x68, 0x85, 0xf7, 0x68, 0x85, 0xf6, 0x68,
    0x85, 0xf9, 0x68, 0x85, 0xf8, 0xa0, 0xff, 0xc8, 0xb1,
    0xf6, 0xd1, 0xf8, 0xd0, 0x06, 0xaa, 0xd0, 0xf6,
    0xa9, 0x00, 0x60, 0xa9, 0x01, 0xa2, 0x00, 0x60
    };
*/
/*
  strcmp( s1, s2 )
  Compare two strings.
*/

/*	bogus...
#ifdef M6502
strcmp(s1, s2)
char	*s1, *s2;
asm	a_strcmp;
#else
strcmp(s1, s2)
char *s1, *s2;
{
    while (1) {
	if (*s1 > *s2) return( 1 );
	if (*s1 < *s2) return( -1 );
	if (*s1 == 0) return( 0 );
	++s1;
	++s2;
	}
}
#endif
*/

/*
  Search( string )
  Search for string in command table.
*/
Search(string)
char * string;
{
#ifdef old_cruft
int h;
struct kw * p;
char * q;

  h = 0;
  q = string;
  while (*q)
    h ^= *q++ + 0x3b;
  if ((p = keywords + (h & 0x3f))->t_sym == NULL)
    {
      return (0);
    }
  if (strcmp(string, p->t_sym) == 0)
    {
      return (p->t_value);
    }
  else if (p->t_next)
    {
      p = keywords + p->t_next;
      if (strcmp(string, p->t_sym) == 0)
	{
	  return (p->t_value);
	}
    }
  return (0);
#else
  return (tok_assoc(string, keywords));
#endif
}
