C
C Approximate Pi for fun and profit...
C
C Written by Giles Greenway for ICTARI
C
C PIVAL is a constant...
C
      PARAMETER (PIVAL=3.141592654)
C
C Specify types for your variable or FORTRAN will do it for you.
C
      INTEGER*4 RSEED,HITS,ITS,LOOP
      REAL*4 X,Y,RSQ,RESULT
C
C RSEED will be shared with the random number routine...
C
      COMMON RSEED
C
C Prompt for some values.
C      
      WRITE(*,*) ' Enter a seed for the random number generator: '
      READ(*,*) RSEED
      WRITE(*,*) ' Enter the number of iterations: '
      READ(*,*) ITS
C
C Set up the variables.
C
      HITS = 0
      X = 0.0
      Y = 0.0
C
C A DO loop. Note the line number.
C
      DO 5 LOOP=1,ITS
C
C Call the random number generator...
C
            CALL RND(X)
            CALL RND(Y)
C
C Find the square of the displacement from the origin...
C
            RSQ=(0.5-X)**2+(0.5-Y)**2
C
C Count the hits with an IF statement.
C
            IF (RSQ .LT. 0.25) THEN
                  HITS = HITS + 1
            END IF
C
C The end of our loop.
C
    5 CONTINUE
C
C Find Pi.
C
      RESULT = HITS / (ITS * 0.25)
C
C Observe the formatted output.
C
      WRITE(*,'(A17,F7.4)') '  Value of Pi is: ',RESULT
C
C Note the continuation character. (+)
C
      WRITE(*,'(A2,F8.3,A31)') '  ',RESULT/PIVAL*100.0,
     +' percent of the prefered value.'
C
C THE END !
C
      WRITE(*,*) ' Press return:'
      READ(*,*)
      END
C
C Here's our random number generator. Kids, don't trust it
C as far as you can throw it !
C
      SUBROUTINE RND(RNUM)
C
C More variables...
C
      INTEGER*4 RSEED
      REAL*4 RNUM
C
C The other end of the COMMON block...
C
      COMMON RSEED
            RSEED=MOD(RSEED*106+1283,6075)
C
C Get a random(ish) number.
C
            RNUM=FLOAT(RSEED)/FLOAT(6075)
C
C Return to the main routine.
C
            RETURN
      END   
C
C That is all...
C      

      
