/*
	The formula for a bezier curve is as follows:-
	
	x = x1*(1-t)^3 + x2*3*t*(1-t)^2 + x3*3*t^2*(1-t) + x4*t^3
	y = y1*(1-t)^3 + y2*3*t*(1-t)^2 + y3*3*t^2*(1-t) + y4*t^3

	Where x & y are the values for the curve at section number i
	the control points are (cx0,cy0), (cx1,cy1), (cx2,cy2) & (cx3,cy3)
	and t = the number of the curve section (i), to be generated by the
	formula, divided by the total number of sections (n) in the final
	curve.
	
	ie x[i] = f(x[i/n])
	   y[i] = f(y[i/n])


	Draw a bezier line.
	In: Control point values in c[][] ie. c[0][0]=cx0 c[1][0]=cy0:
		number of points in n.
	Out: n Bezier points in b[][] ie. b[0][0]=bx0 b[1][0]=by0
		A polyline curve can be drawn thro' these points.		
*/
void bezier(short c[2][4], short b[2][256], short n)
{
	int		i;
	float	t, t2, t3, omt, omt2, omt3;
	float	omt2_3_t, omt_3_t2;

/* Set up a loop for the required number of bezier sections */
	for(i=0;i<=n;i++)
	{

/* Pre-calculate some values */
		t = (float)(i)/n;
		t2 = t*t;				/* (t)squared */
		t3 = t*t*t;				/* (t)cubed */
		omt = 1-t;				/* omt = (o)ne (m)inus (t) */
		omt2 = omt*omt;			/* omt2 = (o)ne (m)inus (t)squared */
		omt3 = omt*omt*omt;		/* etc. */
		omt2_3_t = omt2*3*t;	/* etc. */
		omt_3_t2 = omt*3*t2;	/* etc. */

/* Generate the X coordinates */
		b[0][i]	= c[0][0]*omt3+
				  c[0][1]*omt2_3_t+
				  c[0][2]*omt_3_t2+
				  c[0][3]*t3;

/* Generate the Y coordinates */
		b[1][i] = c[1][0]*omt3+
				  c[1][1]*omt2_3_t+
				  c[1][2]*omt_3_t2+
				  c[1][3]*t3;
	}
}

/*
	NOTE:
	1. In the function the arrays are for short values. These can, of
	course be changed to floats if necessary.
	2. The tab value for this text is 4.
*/
