// LENS EFFECTS: PLANET ANIMATION
// ******************************
// This animation shows how you can use the effect_always_on_top option
// to make the lens effect disappear behind all sorts of complex objects.
// It also illustrates the effect_falloff and rays_flicker options.

// BACKGROUND
   sky_sphere {pigment {granite color_map {[.8 rgb 0] [1 rgb 1]} scale 1e-3}}

// PLANET
   union {sphere {0, 1 pigment {wrinkles color_map {[0 rgb <.2, 0, 0>] [1 rgb <.7, .3, .1>]} scale .3}}
      difference {cylinder {-y, y, 1 scale <1.6, .03, 1.6>} cylinder {-y, y, 1 scale <1.2, .1, 1.2>}
         pigment {onion pigment_map {
            [.8 granite color_map {[.1 rgb <.5, .5, .6>] [.3 rgbt <.5, .5, .6, 1>]} scale .1] [.9 granite color_map {[.3 rgb <.4, .4, .4>] [.5 rgbt <.4, .4, .4, 1>]} scale .07]
            [.93 granite color_map {[0 rgb <.6, .5, .3>] [.2 rgbt <.6, .5, .3, 1>]} scale .2] [1 granite color_map {[.1 rgb <.5, .5, .6>] [.3 rgbt <.5, .5, .6, 1>]} scale .1]}
            scale 1.6}
         rotate <10, 0, 0> no_shadow}
      rotate y * clock * -50 scale 60 translate <-100, 0, 0>}

// CAMERA OPTIONS
   #declare camera_location = <0, -40, -300>
   #declare camera_look_at = <0, -40, 100>
   #declare camera_angle = 45

// LENS EFFECT OPTIONS
   #declare effect_type = "Sun"
   #declare effect_always_on_top = false
   #declare effect_falloff = 30
   #declare rays_flicker = true
   #declare effect_colour = <1.4, 1, 1>
   #declare source_colour = <1.3, 1.3, .7>
   #declare effect_brightness = 2

   #declare effect_location = vrotate(z, y * ((clock * 120) - 10)) * <300, 1, 200> + <-150, 30 - (clock * 150), 0>
   #include "LENS.INC"

// CREATE LIGHT SOURCE FOR SUN
   light_source {effect_location rgb 2}
   global_settings {max_trace_level 10}
