// LENS EFFECTS: RAYS COMPONENTS
// *****************************
// This scene illustrates the 8 different types of rays included
// with the Lens Effects Include File.  These are numbered from
// left to right, starting at the top-left corner, ie:
//
//     1   2   3   4
//     5   6   7   8
//
// Note that the rays have been scaled to 50% of normal size to
// fit them all in one image, and the intensity has been set
// to 10 times normal to make them more visible.

// CAMERA AND EFFECT OPTIONS
   #declare camera_location = <0, 0, -12>
   #declare camera_look_at = <0, 0, 0>
   #declare effect_scale = .5
   #declare effect_intensity = 10

   global_settings {max_trace_level 10}

// RAYS TYPE 1
   #declare rays_type = 1
   #declare effect_location = <-6, 2, 0> #include "LNSEFCTS.INC"

// RAYS TYPE 2
   #declare rays_type = 2
   #declare effect_location = <-2, 2, 0> #include "LNSEFCTS.INC"

// RAYS TYPE 3
   #declare rays_type = 3
   #declare effect_location = <2, 2, 0> #include "LNSEFCTS.INC"

// RAYS TYPE 4
   #declare rays_type = 4
   #declare effect_location = <6, 2, 0> #include "LNSEFCTS.INC"

// RAYS TYPE 5
   #declare rays_type = 5
   #declare effect_location = <-6, -2, 0> #include "LNSEFCTS.INC"

// RAYS TYPE 6
   #declare rays_type = 6
   #declare effect_location = <-2, -2, 0> #include "LNSEFCTS.INC"

// RAYS TYPE 7
   #declare rays_type = 7
   #declare effect_location = <2, -2, 0> #include "LNSEFCTS.INC"

// RAYS TYPE 8
   #declare rays_type = 8
   #declare effect_location = <6, -2, 0> #include "LNSEFCTS.INC"
