// LENS EFFECTS: SPOTS COMPONENTS
// ******************************
// This scene illustrates the 8 different types of spots included
// with the Lens Effects Include File.  These are numbered from
// left to right, ie:
//
//     1  2  3  4  5  6  7  8
//
// Note that the spots have been scaled to 60% of normal size to
// fit them all in one image.  Also, the intensity has been increased
// to 3 times normal to make the spots more visible.

// CAMERA AND EFFECT OPTIONS
   #declare camera_location = <0, 8, -13>
   #declare camera_look_at = <0, 8, 0>
   #declare effect_scale = .6
   #declare effect_intensity = 3
   #declare effect_rotate = -90
   #declare spots_seed = 100
   #declare spots_to_centre = false

   global_settings {max_trace_level 10}

// SPOTS TYPE 1
   #declare spots_type = 1
   #declare effect_location = -x * 7 #include "LNSEFCTS.INC"

// SPOTS TYPE 2
   #declare spots_type = 2
   #declare effect_location = -x * 5 #include "LNSEFCTS.INC"

// SPOTS TYPE 3
   #declare spots_type = 3
   #declare effect_location = -x * 3 #include "LNSEFCTS.INC"

// SPOTS TYPE 4
   #declare spots_type = 4
   #declare effect_location = -x #include "LNSEFCTS.INC"

// SPOTS TYPE 5
   #declare spots_type = 5
   #declare effect_location = x #include "LNSEFCTS.INC"

// SPOTS TYPE 6
   #declare spots_type = 6
   #declare effect_location = x * 3 #include "LNSEFCTS.INC"

// SPOTS TYPE 7
   #declare spots_type = 7
   #declare effect_location = x * 5 #include "LNSEFCTS.INC"

// SPOTS TYPE 8
   #declare spots_type = 8
   #declare effect_location = x * 7 #include "LNSEFCTS.INC"
