/*
 Made by Edward van der Jagt - bivdjagt@cs.few.eur.nl
				http://www.cs.few.eur.nl/~bivdjagt/
*/

#declare l3g0_b1x4_headlights =
union
 {
  #declare XW=4 #declare ZW=1 #include "MakeTall.inc"

  polygon {5, <0,0,0> <wide*4,0,0> <wide*4,tall,0> <0,tall,0> <0,0,0>
  texture
   {
    pigment
     {
      image_map { tga "ll_headl.tga" once}
      scale <3.25, 1, 1>
     }
   }

  translate <0, 0, -0.001>
 }
}


#declare l3g0_b1x4_police =
union {
  #declare XW=4 #declare ZW=1 #include "MakeTall.inc"
   polygon {5, <0,0,0> <wide*4,0,0> <wide*4,tall,0> <0,tall,0> <0,0,0>
   texture {
    pigment {
     image_map { tga "ll_polic.tga" once}
     scale <3.25,0.99,0.99>
    }
   }
  translate <0,0,-0.001>
 }
}



#declare l3g0_b2x3_police =
union {

  #declare XW=3 #declare ZW=2 #include "MakeTall.inc"
  polygon {5, <0,0,0> <wide*3,0,0> <wide*3,tall,0> <0,tall,0> <0,0,0>
  texture {
   pigment {
    image_map { tga "ll_polic.tga" }
    scale <2.25,1,1>
   }
  }
  translate <0,0,-0.001>
  }
}


#declare l3g0_steer =
union
 {
  #declare XW=2 #declare YW = flat #declare ZW=1 #include "BrickBox.inc"
  //#if (Detial_level > 0)
  object { thin_flat_column translate <wide,0,wide*0.5>}
  //#end

  union
   {
    box {<(.5*wide), (flat-0.125), (0*wide)>, <(1.5*wide), (4*flat), (0.125)>}
    difference
     {
      cylinder {<(1.0*wide), (flat-0.125), (0*wide)>, <(1.0*wide), (4*flat), (0*wide)>,(.25*wide)}
      box {<0, 0, 0>, <10, 10, 10> rotate <60, 0, 0> translate <0, (4*flat), 0>}
      box {<0, 0, 0>, <10, 10, -10> }
     }
    cylinder {<0,0,0>, <0, .5*wide, 0>,.5*flat rotate <60, 0, 0> translate <wide, 4*flat, 0>}
   }
  union
   {
    cylinder {<0, 0, 0>, <(0.0*wide), (0.125), (0*wide)>, ((.5*1.125)*tall) open}
    cylinder {<0, 0, 0>, <(0.0*wide), (0.125), (0*wide)>, (((.5*1.125)*tall)-((1/3)*flat)) open }
    torus {(((.5*1.125)*tall)-((.5*1/3)*flat)), ((.5*1/3)*flat) translate <(0.0*wide), (0.125), (0*wide)> }
    disc {<(0.0*wide), 0, (0*wide)>, <0, 1, 0>, ((.5*1.125)*tall), (((.5*1.125)*tall)-((1/3)*flat))}
    union
     {
      difference
       {
        cylinder {<0, 0, 0>, <(0.0*wide), (.3*wide), (0*wide)>, (1.5*.5*flat)}
        cylinder {<0, 0, 0>, <(0.0*wide), (.3*wide), (0*wide)>, (.5*flat) open}
       }
      union
       {
        polygon {5,    <(-.5*0.125), 0, (.6*flat)>,<(+.5*0.125), 0, (.6*flat)>,<(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,<(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>, <(-.5*0.125), 0, (.6*flat)> }
        polygon {4,    <(-.5*0.125), 0, (.6*flat)>,<(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,<(-.5*0.125), (.3*wide), (.6*flat)>, <(-.5*0.125), 0, (.6*flat)>}
        polygon {4,    <(+.5*0.125), 0, (.6*flat)>,<(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,<(+.5*0.125), (.3*wide), (.6*flat)>, <(+.5*0.125), 0, (.6*flat)>}
        polygon {5,    <(+.5*0.125), (.3*wide), (.6*flat)>, <(-.5*0.125), (.3*wide), (.6*flat)>,<(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,<(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,<(+.5*0.125), (.3*wide), (.6*flat)>}
       }
      union
       {
        polygon {5,    <(-.5*0.125), 0, (.6*flat)>,  <(+.5*0.125), 0, (.6*flat)>,  <(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,  <(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,   <(-.5*0.125), 0, (.6*flat)>  }
        polygon {4,    <(-.5*0.125), 0, (.6*flat)>,  <(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,  <(-.5*0.125), (.3*wide), (.6*flat)>,   <(-.5*0.125), 0, (.6*flat)>  }
        polygon {4,    <(+.5*0.125), 0, (.6*flat)>,  <(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,  <(+.5*0.125), (.3*wide), (.6*flat)>,   <(+.5*0.125), 0, (.6*flat)>  }
        polygon {5,    <(+.5*0.125), (.3*wide), (.6*flat)>, <(-.5*0.125), (.3*wide), (.6*flat)>, <(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>, <(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>, <(+.5*0.125), (.3*wide), (.6*flat)> }
        rotate <0, 120, 0>
       }
      union
       {
        polygon {5,    <(-.5*0.125), 0, (.6*flat)>,  <(+.5*0.125), 0, (.6*flat)>,  <(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,  <(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,   <(-.5*0.125), 0, (.6*flat)>  }
        polygon {4,    <(-.5*0.125), 0, (.6*flat)>,  <(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,  <(-.5*0.125), (.3*wide), (.6*flat)>,   <(-.5*0.125), 0, (.6*flat)>  }
        polygon {4,    <(+.5*0.125), 0, (.6*flat)>,  <(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,  <(+.5*0.125), (.3*wide), (.6*flat)>,   <(+.5*0.125), 0, (.6*flat)>  }
        polygon {5,    <(+.5*0.125), (.3*wide), (.6*flat)>, <(-.5*0.125), (.3*wide), (.6*flat)>,<(-.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>, <(+.5*0.125), (.3*wide), (((.5*1.125)*tall)-((.5*1/3)*flat))>,<(+.5*0.125), (.3*wide), (.6*flat)>}
        rotate <0, 240, 0>
       }
      translate <0, (-1.75*0.125), 0>
     }
    translate <0, (.5*wide), 0>
    rotate <60, 0, 0>
    translate <(1.0*wide), (4*flat), (0*wide)>
    texture {l3g0_black}
   }
 }

#declare ll_fence_cutoutboxes_4_hor =
union
 {
  box {<0, 0, 0>, <2*stud_radius, 2*stud_radius, wide> rotate <0, 0, 45> translate <(-1*wide), 0, 0>}
  box {<0, 0, 0>, <2*stud_radius, 2*stud_radius, wide> rotate <0, 0, 45>}
  box {<0, 0, 0>, <2*stud_radius, 2*stud_radius, wide> rotate <0, 0, 45> translate <wide, 0, 0>}
  box {<0, 0, 0>, <2*stud_radius, 2*stud_radius, wide> rotate <0, 0, 45> translate <2*wide, 0, 0>}
  box {<0, 0, 0>, <2*stud_radius, 2*stud_radius, wide> rotate <0, 0, 45> translate <3*wide, 0, 0>}
  translate <(3/2*wide*0.5), (-1/2*flat), 0>
 }



#declare ll_fence_cutout_1x4x1 =
intersection
 {
  box {<wall, flat, 0>, <(4*wide)-wall, tall-wall, (0.126)>
 }
 union
  {
   union
    {
     object {ll_fence_cutoutboxes_4_hor }
     object {ll_fence_cutoutboxes_4_hor translate <-wide*0.5, wide*0.5, 0>}
     object {ll_fence_cutoutboxes_4_hor translate <0, 2*wide*0.5, 0>}
     translate <2/5*wide*0.5, 0, 0>
    }
   box {<wall, flat, 0>, <(3/4*(2*stud_radius)), tall-wall, wide>}
   box {<((4*wide)-3/4*(2*stud_radius)), (tall-wall), wide>, <(4*wide)-wall, flat, 0> }
  }
 translate <(0*wall), 0, (-1/2*wall)>
}


#declare ll_fence_cutout_1x4x2 =
intersection
 {
  box {<wall, flat+wall, 0>, <(4*wide)-wall, 2*tall-wall, 0.126>}
  union
   {
    union
     {
      object {ll_fence_cutoutboxes_4_hor }
      object {ll_fence_cutoutboxes_4_hor translate <-wide*0.5, wide*0.5, 0>}
      object {ll_fence_cutoutboxes_4_hor translate <0, 2*wide*0.5, 0>}
      object {ll_fence_cutoutboxes_4_hor translate <-wide*0.5, 3*wide*0.5, 0>}
      object {ll_fence_cutoutboxes_4_hor translate <0, 4*wide*0.5, 0>}
      translate <(2/5*wide*0.5+0*wall), 0, 0>
     }
    box {<wall, flat, 0>, <(3/4*(2*stud_radius)), (flat+1/2*(2*stud_radius)), wide>}
    box {<((4*wide)-3/4*(2*stud_radius)), (flat+1/2*(2*stud_radius)), wide>, <(4*wide)-wall, flat, 0>}
    box {<wall, (2*tall-wall), 0>, <3/4*(2*stud_radius), 1.5*tall, wide>}
    box {<(4*wide)-3/4*(2*stud_radius), 1.5*tall, wide>, <(4*wide)-wall, 2*tall-wall, 0>}
    translate <0, wall, 0>
   }
 translate <0, 0, (-1/2*wall)>
}

#declare l3g0_fence_1x4x1 =
union
 {
  difference
   {
    union
     {
      #declare XW=4 #declare YW=flat #declare ZW=1 #include "BrickBox.inc"
      box {<0, flat, 0>, <4*wide, tall, wall>}
     }
    object {ll_fence_cutout_1x4x1 scale <1, 1, 2>}
   }
  #if (Detail_level > 0)
  object { thin_flat_column translate <wide,0,wide*0.5>}
  object { thin_flat_column translate <wide*2,0,wide*0.5>}
  object { thin_flat_column translate <wide*3,0,wide*0.5>}
  #end
 }

#declare l3g0_fence_1x4x2 =
union
 {
  difference
   {
    union
     {
      #declare XW=4 #declare YW=flat #declare ZW=1 #include "BrickBox.inc"
      box {<0, flat, 0>, <4*wide, 2*tall, wall> translate <0, 0, (wide*0.5-1/2*wall)>}
     }
    object {ll_fence_cutout_1x4x2 scale <1, 1, 2> translate <0, 0, (wide*0.5-1/2*wall)>}
   }
  #if (Detail_level > 0)
  object { thin_flat_column translate <wide,0,wide*0.5>}
  object { thin_flat_column translate <wide*2,0,wide*0.5>}
  object { thin_flat_column translate <wide*3,0,wide*0.5>}
  #end

 }