/*
l3g0_road_straight              A straight road
l3g0_road_T             A road with 1 `exit'
l3g0_road_X             A crossing
l3g0_road_curve         A curved road

Note:
 straight       - goes along the positive y-axis
 T              - goes along the positive y-axis, and to the negative x
 curve          - starts from negative x  to  positive y

I should still apply
	bump 0.4 scale <0.01, 1.0, 0.01>
to the roads.....
*/
/*
 Made by Edward van der Jagt - bivdjagt@cs.few.eur.nl
				http://www.cs.few.eur.nl/~bivdjagt/
*/


#if (Detail_level > 0)

#declare xOffset=wide
#declare yOffset=wide
#declare xStart=wide*0.5
#declare yStart=wide*0.5
#declare elevation = flat
#declare GridObject = object { stud }
#declare ll_base_9x32_studs=
union
 {
  #declare yLim = 9
  #declare xLim = 32
  #include "grid.inc"
 }

#declare ll_base_9x9_studs=
union
 {
  #declare yLim = 9
  #declare xLim = 9
  #include "grid.inc"
 }

#declare ll_base_9x8_studs=
union
 {
  #declare yLim = 9
  #declare xLim = 8
  #include "grid.inc"
 }
#declare ll_base_8x8_studs=
union
 {
  #declare yLim = 8
  #declare xLim = 8
  #include "grid.inc"
 }
#end

#declare ll_road_zebra_x =
union
 {
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (10.0*wide)>,  <(22*wide), ((flat/1)+.00001), (11.0*wide)>,  <(27*wide), ((flat/1)+.00001), (11.0*wide)>,  <(27*wide), ((flat/1)+.00001), (10.0*wide)>,   <(22*wide), ((flat/1)+.00001), (10.0*wide)>    texture { l3g0_white }}
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (11.5*wide)>,  <(22*wide), ((flat/1)+.00001), (12.5*wide)>,  <(27*wide), ((flat/1)+.00001), (12.5*wide)>,  <(27*wide), ((flat/1)+.00001), (11.5*wide)>,   <(22*wide), ((flat/1)+.00001), (11.5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (13.0*wide)>,  <(22*wide), ((flat/1)+.00001), (14.0*wide)>,  <(27*wide), ((flat/1)+.00001), (14.0*wide)>,  <(27*wide), ((flat/1)+.00001), (13.0*wide)>,   <(22*wide), ((flat/1)+.00001), (13.0*wide)>    texture { l3g0_white }}
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (14.5*wide)>,  <(22*wide), ((flat/1)+.00001), (15.5*wide)>,  <(27*wide), ((flat/1)+.00001), (15.5*wide)>,  <(27*wide), ((flat/1)+.00001), (14.5*wide)>,   <(22*wide), ((flat/1)+.00001), (14.5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (16.0*wide)>,  <(22*wide), ((flat/1)+.00001), (17.0*wide)>,  <(27*wide), ((flat/1)+.00001), (17.0*wide)>,  <(27*wide), ((flat/1)+.00001), (16.0*wide)>,   <(22*wide), ((flat/1)+.00001), (16.0*wide)>    texture { l3g0_white }}
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (17.5*wide)>,  <(22*wide), ((flat/1)+.00001), (18.5*wide)>,  <(27*wide), ((flat/1)+.00001), (18.5*wide)>,  <(27*wide), ((flat/1)+.00001), (17.5*wide)>,   <(22*wide), ((flat/1)+.00001), (17.5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (19.0*wide)>,  <(22*wide), ((flat/1)+.00001), (20.0*wide)>,  <(27*wide), ((flat/1)+.00001), (20.0*wide)>,  <(27*wide), ((flat/1)+.00001), (19.0*wide)>,   <(22*wide), ((flat/1)+.00001), (19.0*wide)>    texture { l3g0_white }}
 polygon { 5,    <(22*wide), ((flat/1)+.00001), (20.5*wide)>,  <(22*wide), ((flat/1)+.00001), (21.5*wide)>,  <(27*wide), ((flat/1)+.00001), (21.5*wide)>,  <(27*wide), ((flat/1)+.00001), (20.5*wide)>,   <(22*wide), ((flat/1)+.00001), (20.5*wide)>    texture { l3g0_white }}
}

#declare ll_road_zebra_y =
union
 {
 polygon { 5,    <(10.0*wide), ((flat/1)+.00001), (5*wide)>,  <(10.0*wide), ((flat/1)+.00001), (10*wide)>,  <(11.0*wide), ((flat/1)+.00001), (10*wide)>,  <(11.0*wide), ((flat/1)+.00001), (5*wide)>,   <(10.0*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(11.5*wide), ((flat/1)+.00001), (5*wide)>,  <(11.5*wide), ((flat/1)+.00001), (10*wide)>,  <(12.5*wide), ((flat/1)+.00001), (10*wide)>,  <(12.5*wide), ((flat/1)+.00001), (5*wide)>,   <(11.5*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(13.0*wide), ((flat/1)+.00001), (5*wide)>,  <(13.0*wide), ((flat/1)+.00001), (10*wide)>,  <(14.0*wide), ((flat/1)+.00001), (10*wide)>,  <(14.0*wide), ((flat/1)+.00001), (5*wide)>,   <(13.0*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(14.5*wide), ((flat/1)+.00001), (5*wide)>,  <(14.5*wide), ((flat/1)+.00001), (10*wide)>,  <(15.5*wide), ((flat/1)+.00001), (10*wide)>,  <(15.5*wide), ((flat/1)+.00001), (5*wide)>,   <(14.5*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(16.0*wide), ((flat/1)+.00001), (5*wide)>,  <(16.0*wide), ((flat/1)+.00001), (10*wide)>,  <(17.0*wide), ((flat/1)+.00001), (10*wide)>,  <(17.0*wide), ((flat/1)+.00001), (5*wide)>,   <(16.0*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(17.5*wide), ((flat/1)+.00001), (5*wide)>,  <(17.5*wide), ((flat/1)+.00001), (10*wide)>,  <(18.5*wide), ((flat/1)+.00001), (10*wide)>,  <(18.5*wide), ((flat/1)+.00001), (5*wide)>,   <(17.5*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(19.0*wide), ((flat/1)+.00001), (5*wide)>,  <(19.0*wide), ((flat/1)+.00001), (10*wide)>,  <(20.0*wide), ((flat/1)+.00001), (10*wide)>,  <(20.0*wide), ((flat/1)+.00001), (5*wide)>,   <(19.0*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
 polygon { 5,    <(20.5*wide), ((flat/1)+.00001), (5*wide)>,  <(20.5*wide), ((flat/1)+.00001), (10*wide)>,  <(21.5*wide), ((flat/1)+.00001), (10*wide)>,  <(21.5*wide), ((flat/1)+.00001), (5*wide)>,   <(20.5*wide), ((flat/1)+.00001), (5*wide)>    texture { l3g0_white }}
}

#declare l3g0_road_straight =
union
 {
  box {<0, 0, 0>, <(32*wide), (flat/2), (32*wide)> translate <0, (flat/2), 0> }
  #if (Detail_level > 0)
  object {ll_base_9x32_studs}
  object {ll_base_9x32_studs translate <0, 0, ((32-9)*wide)>}
  #end
  polygon { 5,    <0, ((flat/1)+.00001), (9*wide)>,  <0, ((flat/1)+.00001), (10*wide)>,  <(32*wide), ((flat/1)+.00001), (10*wide)>,  <(32*wide), ((flat/1)+.00001), (9*wide)>,   <0, ((flat/1)+.00001), (9*wide)>    texture { l3g0_road_color }}
  polygon { 5,    <0, ((flat/1)+.00001), ((32-9)*wide)>,  <0, ((flat/1)+.00001), ((32-10)*wide)>,  <(32*wide), ((flat/1)+.00001), ((32-10)*wide)>,  <(32*wide), ((flat/1)+.00001), ((32-9)*wide)>,   <0, ((flat/1)+.00001), ((32-9)*wide)>    texture { l3g0_road_color }}
  polygon { 5,    <0, ((flat/1)+.00001), (15.5*wide)>,  <0, ((flat/1)+.00001), (16.0*wide)>,  <(1*wide), ((flat/1)+.00001), (16.0*wide)>,  <(1*wide), ((flat/1)+.00001), (15.5*wide)>,   <0, ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(2*wide), ((flat/1)+.00001), (15.5*wide)>,  <(2*wide), ((flat/1)+.00001), (16.0*wide)>,  <(4*wide), ((flat/1)+.00001), (16.0*wide)>,  <(4*wide), ((flat/1)+.00001), (15.5*wide)>,   <(2*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(5*wide), ((flat/1)+.00001), (15.5*wide)>,  <(5*wide), ((flat/1)+.00001), (16.0*wide)>,  <(7*wide), ((flat/1)+.00001), (16.0*wide)>,  <(7*wide), ((flat/1)+.00001), (15.5*wide)>,   <(5*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(8*wide), ((flat/1)+.00001), (15.5*wide)>,  <(8*wide), ((flat/1)+.00001), (16.0*wide)>,  <(10*wide), ((flat/1)+.00001), (16.0*wide)>,  <(10*wide), ((flat/1)+.00001), (15.5*wide)>,   <(8*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(11*wide), ((flat/1)+.00001), (15.5*wide)>,  <(11*wide), ((flat/1)+.00001), (16.0*wide)>,  <(13*wide), ((flat/1)+.00001), (16.0*wide)>,  <(13*wide), ((flat/1)+.00001), (15.5*wide)>,   <(11*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white}}
  polygon { 5,    <(14*wide), ((flat/1)+.00001), (15.5*wide)>,  <(14*wide), ((flat/1)+.00001), (16.0*wide)>,  <(16*wide), ((flat/1)+.00001), (16.0*wide)>,  <(16*wide), ((flat/1)+.00001), (15.5*wide)>,   <(14*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(17*wide), ((flat/1)+.00001), (15.5*wide)>,  <(17*wide), ((flat/1)+.00001), (16.0*wide)>,  <(19*wide), ((flat/1)+.00001), (16.0*wide)>,  <(19*wide), ((flat/1)+.00001), (15.5*wide)>,   <(17*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(20*wide), ((flat/1)+.00001), (15.5*wide)>,  <(20*wide), ((flat/1)+.00001), (16.0*wide)>,  <(21*wide), ((flat/1)+.00001), (16.0*wide)>,  <(21*wide), ((flat/1)+.00001), (15.5*wide)>,   <(20*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  object {ll_road_zebra_x}
  polygon { 5,    <(28*wide), ((flat/1)+.00001), (15.5*wide)>,  <(28*wide), ((flat/1)+.00001), (16.0*wide)>,  <(30*wide), ((flat/1)+.00001), (16.0*wide)>,  <(30*wide), ((flat/1)+.00001), (15.5*wide)>,   <(28*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(31*wide), ((flat/1)+.00001), (15.5*wide)>,  <(31*wide), ((flat/1)+.00001), (16.0*wide)>,  <(32*wide), ((flat/1)+.00001), (16.0*wide)>,  <(32*wide), ((flat/1)+.00001), (15.5*wide)>,   <(31*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
 }

#declare l3g0_road_T =
union
 {
  box {<0, 0, 0>, <(32*wide), (flat/2), (32*wide)> translate <0, (flat/2), 0> }
  #if (Detail_level > 0)
  object {ll_base_9x9_studs }
  object {ll_base_9x9_studs translate <((32-9)*wide), 0, 0>}
  object {ll_base_9x32_studs translate <0, 0, ((32-9)*wide)>}
  #end
  polygon { 8,<0, ((flat/1)+.00001), (9*wide)>,  <0, ((flat/1)+.00001), (10*wide)>,  <(10*wide), ((flat/1)+.00001), (10*wide)>,  <(10*wide), ((flat/1)+.00001), (0*wide)>,  <(9*wide), ((flat/1)+.00001), (0*wide)>,  <(9*wide), ((flat/1)+.00001), (9*wide)>,  <(10*wide), ((flat/1)+.00001), (9*wide)>,   <0, ((flat/1)+.00001), (9*wide)>    texture { l3g0_road_color }}
  polygon { 7,<((32-9)*wide), ((flat/1)+.00001), (9*wide)>,  <((32-9)*wide), ((flat/1)+.00001), (0*wide)>,  <((32-10)*wide), ((flat/1)+.00001), (0*wide)>,  <((32-10)*wide), ((flat/1)+.00001), (10*wide)>,  <(32*wide), ((flat/1)+.00001), (10*wide)>,  <(32*wide), ((flat/1)+.00001), (9*wide)>,   <((32-9)*wide), ((flat/1)+.00001), (9*wide)>    texture { l3g0_road_color }}
  polygon { 5,<0, ((flat/1)+.00001), ((32-9)*wide)>,  <0, ((flat/1)+.00001), ((32-10)*wide)>,  <(32*wide), ((flat/1)+.00001), ((32-10)*wide)>,  <(32*wide), ((flat/1)+.00001), ((32-9)*wide)>,   <0, ((flat/1)+.00001), ((32-9)*wide)>    texture { l3g0_road_color }}
  polygon { 5,<0, ((flat/1)+.00001), (15.5*wide)>,  <0, ((flat/1)+.00001), (16.0*wide)>,  <(1*wide), ((flat/1)+.00001), (16.0*wide)>,  <(1*wide), ((flat/1)+.00001), (15.5*wide)>,   <0, ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(2*wide), ((flat/1)+.00001), (15.5*wide)>,  <(2*wide), ((flat/1)+.00001), (16.0*wide)>,  <(4*wide), ((flat/1)+.00001), (16.0*wide)>,  <(4*wide), ((flat/1)+.00001), (15.5*wide)>,   <(2*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(5*wide), ((flat/1)+.00001), (15.5*wide)>,  <(5*wide), ((flat/1)+.00001), (16.0*wide)>,  <(7*wide), ((flat/1)+.00001), (16.0*wide)>,  <(7*wide), ((flat/1)+.00001), (15.5*wide)>,   <(5*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(8*wide), ((flat/1)+.00001), (15.5*wide)>,  <(8*wide), ((flat/1)+.00001), (16.0*wide)>,  <(10*wide), ((flat/1)+.00001), (16.0*wide)>,  <(10*wide), ((flat/1)+.00001), (15.5*wide)>,   <(8*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(11*wide), ((flat/1)+.00001), (15.5*wide)>,  <(11*wide), ((flat/1)+.00001), (16.0*wide)>,  <(13*wide), ((flat/1)+.00001), (16.0*wide)>,  <(13*wide), ((flat/1)+.00001), (15.5*wide)>,   <(11*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(14*wide), ((flat/1)+.00001), (15.5*wide)>,  <(14*wide), ((flat/1)+.00001), (16.0*wide)>,  <(16*wide), ((flat/1)+.00001), (16.0*wide)>,  <(16*wide), ((flat/1)+.00001), (15.5*wide)>,   <(14*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(17*wide), ((flat/1)+.00001), (15.5*wide)>,  <(17*wide), ((flat/1)+.00001), (16.0*wide)>,  <(19*wide), ((flat/1)+.00001), (16.0*wide)>,  <(19*wide), ((flat/1)+.00001), (15.5*wide)>,   <(17*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(20*wide), ((flat/1)+.00001), (15.5*wide)>,  <(20*wide), ((flat/1)+.00001), (16.0*wide)>,  <(21*wide), ((flat/1)+.00001), (16.0*wide)>,  <(21*wide), ((flat/1)+.00001), (15.5*wide)>,   <(20*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  object {ll_road_zebra_x}
  polygon { 5,<(28*wide), ((flat/1)+.00001), (15.5*wide)>,  <(28*wide), ((flat/1)+.00001), (16.0*wide)>,  <(30*wide), ((flat/1)+.00001), (16.0*wide)>,  <(30*wide), ((flat/1)+.00001), (15.5*wide)>,   <(28*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(31*wide), ((flat/1)+.00001), (15.5*wide)>,  <(31*wide), ((flat/1)+.00001), (16.0*wide)>,  <(32*wide), ((flat/1)+.00001), (16.0*wide)>,  <(32*wide), ((flat/1)+.00001), (15.5*wide)>,   <(31*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(15.5*wide), ((flat/1)+.00001), (0*wide)>,  <(15.5*wide), ((flat/1)+.00001), (1*wide)>,  <(16.0*wide), ((flat/1)+.00001), (1*wide)>,  <(16.0*wide), ((flat/1)+.00001), (0*wide)>,   <(15.5*wide), ((flat/1)+.00001), (0*wide)>    texture { l3g0_white }}
  polygon { 5,<(15.5*wide), ((flat/1)+.00001), (2*wide)>,  <(15.5*wide), ((flat/1)+.00001), (4*wide)>,  <(16.0*wide), ((flat/1)+.00001), (4*wide)>,  <(16.0*wide), ((flat/1)+.00001), (2*wide)>,   <(15.5*wide), ((flat/1)+.00001), (2*wide)>    texture { l3g0_white }}
  object {ll_road_zebra_y}
 }

#declare l3g0_road_X =
union
 {
  box {<0, 0, 0>, <(32*wide), (flat/2), (32*wide)> translate <0, (flat/2), 0>}
  #if (Detail_level > 0)
  object {ll_base_9x9_studs}
  object {ll_base_9x9_studs translate <((32-9)*wide), 0, 0>}
  object {ll_base_9x9_studs translate <0, 0, ((32-9)*wide)>}
  object {ll_base_9x9_studs translate <((32-9)*wide), 0, ((32-9)*wide)>}
  #end

  polygon { 8,<0, ((flat/1)+.00001), (9*wide)>,  <0, ((flat/1)+.00001), (10*wide)>,  <(10*wide), ((flat/1)+.00001), (10*wide)>,  <(10*wide), ((flat/1)+.00001), (0*wide)>,  <(9*wide), ((flat/1)+.00001), (0*wide)>,  <(9*wide), ((flat/1)+.00001), (9*wide)>,  <(10*wide), ((flat/1)+.00001), (9*wide)>,   <0, ((flat/1)+.00001), (9*wide)>    texture { l3g0_road_color }}
  polygon { 7,<((32-9)*wide), ((flat/1)+.00001), (9*wide)>,  <((32-9)*wide), ((flat/1)+.00001), (0*wide)>,  <((32-10)*wide), ((flat/1)+.00001), (0*wide)>,  <((32-10)*wide), ((flat/1)+.00001), (10*wide)>,  <((32-0)*wide), ((flat/1)+.00001), (10*wide)>,  <((32-0)*wide), ((flat/1)+.00001), (9*wide)>,   <((32-9)*wide), ((flat/1)+.00001), (9*wide)>    texture { l3g0_road_color }}
  polygon { 7,<0, ((flat/1)+.00001), ((32-9)*wide)>,  <0, ((flat/1)+.00001), ((32-10)*wide)>,  <(10*wide), ((flat/1)+.00001), ((32-10)*wide)>,  <(10*wide), ((flat/1)+.00001), ((32-0)*wide)>,  <(9*wide), ((flat/1)+.00001), ((32-0)*wide)>,  <(9*wide), ((flat/1)+.00001), ((32-9)*wide)>,   <0, ((flat/1)+.00001), ((32-9)*wide)>    texture { l3g0_road_color }}
  polygon { 7,<((32-10)*wide), ((flat/1)+.00001), ((32-0)*wide)>,  <((32-10)*wide), ((flat/1)+.00001), ((32-10)*wide)>,  <((32-0)*wide), ((flat/1)+.00001), ((32-10)*wide)>,  <((32-0)*wide), ((flat/1)+.00001), ((32-9)*wide)>,  <((32-9)*wide), ((flat/1)+.00001), ((32-9)*wide)>,  <((32-9)*wide), ((flat/1)+.00001), ((32-0)*wide)>,   <((32-10)*wide), ((flat/1)+.00001), ((32-0)*wide)>    texture { l3g0_road_color }}
  polygon { 5,<0, ((flat/1)+.00001), (15.5*wide)>,  <0, ((flat/1)+.00001), (16.0*wide)>,  <(1*wide), ((flat/1)+.00001), (16.0*wide)>,  <(1*wide), ((flat/1)+.00001), (15.5*wide)>,   <0, ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,<(2*wide), ((flat/1)+.00001), (15.5*wide)>,  <(2*wide), ((flat/1)+.00001), (16.0*wide)>,  <(4*wide), ((flat/1)+.00001), (16.0*wide)>,  <(4*wide), ((flat/1)+.00001), (15.5*wide)>,   <(2*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  object {ll_road_zebra_x translate <(-17*wide), 0, 0>}
  object {ll_road_zebra_x }
  polygon { 5,    <(28*wide), ((flat/1)+.00001), (15.5*wide)>,  <(28*wide), ((flat/1)+.00001), (16.0*wide)>,  <(30*wide), ((flat/1)+.00001), (16.0*wide)>,  <(30*wide), ((flat/1)+.00001), (15.5*wide)>,   <(28*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(31*wide), ((flat/1)+.00001), (15.5*wide)>,  <(31*wide), ((flat/1)+.00001), (16.0*wide)>,  <(32*wide), ((flat/1)+.00001), (16.0*wide)>,  <(32*wide), ((flat/1)+.00001), (15.5*wide)>,   <(31*wide), ((flat/1)+.00001), (15.5*wide)>    texture { l3g0_white }}
  polygon { 5,    <(15.5*wide), ((flat/1)+.00001), (0*wide)>,  <(15.5*wide), ((flat/1)+.00001), (1*wide)>,  <(16.0*wide), ((flat/1)+.00001), (1*wide)>,  <(16.0*wide), ((flat/1)+.00001), (0*wide)>,   <(15.5*wide), ((flat/1)+.00001), (0*wide)>    texture { l3g0_white }}
  polygon { 5,    <(15.5*wide), ((flat/1)+.00001), (2*wide)>,  <(15.5*wide), ((flat/1)+.00001), (4*wide)>,  <(16.0*wide), ((flat/1)+.00001), (4*wide)>,  <(16.0*wide), ((flat/1)+.00001), (2*wide)>,   <(15.5*wide), ((flat/1)+.00001), (2*wide)>    texture { l3g0_white }}
  object {ll_road_zebra_y }
  object {ll_road_zebra_y translate <0, 0, (17*wide)>}
  polygon { 5,    <(15.5*wide), ((flat/1)+.00001), (28*wide)>,  <(15.5*wide), ((flat/1)+.00001), (30*wide)>,  <(16.0*wide), ((flat/1)+.00001), (30*wide)>,  <(16.0*wide), ((flat/1)+.00001), (28*wide)>,   <(15.5*wide), ((flat/1)+.00001), (28*wide)>    texture { l3g0_white }}
  polygon { 5,    <(15.5*wide), ((flat/1)+.00001), (31*wide)>,  <(15.5*wide), ((flat/1)+.00001), (32*wide)>,  <(16.0*wide), ((flat/1)+.00001), (32*wide)>,  <(16.0*wide), ((flat/1)+.00001), (31*wide)>,   <(15.5*wide), ((flat/1)+.00001), (31*wide)>    texture { l3g0_white }}
 }

#declare l3g0_road_curve =
union
 {
  box {<0, 0, 0>, <(32*wide), (flat/2), (32*wide)> translate <0, (flat/2), 0>}
  #if (Detail_level > 0)
  object {ll_base_9x32_studs }
  object {ll_base_9x8_studs rotate <0, -90, 0> translate <(9*wide), 0, 0> translate <0, 0, ((32-8)*wide)>}
  object {ll_base_9x8_studs rotate <0, -90, 0> translate <(9*wide), 0, 0> translate <0, 0, ((32-16)*wide)>}
  object {ll_base_9x8_studs rotate <0, -90, 0> translate <(9*wide), 0, 0> translate <0, 0, ((32-24)*wide)>}
  object {ll_base_8x8_studs translate <(9*wide), 0, (8*wide)>}
  object {simple_stud translate <(16*wide+0.4), flat, (9*wide+0.4)>}
  object {simple_stud translate <(17*wide+0.4), flat, (9*wide+0.4)>}
  object {simple_stud translate <(18*wide+0.4), flat, (9*wide+0.4)>}
  object {simple_stud translate <(19*wide+0.4), flat, (9*wide+0.4)>}
  object {simple_stud translate <(20*wide+0.4), flat, (9*wide+0.4)>}
  object {simple_stud translate <(21*wide+0.4), flat, (9*wide+0.4)>}
  object {simple_stud translate <(22*wide+0.4), flat, (9*wide+0.4)>}
  object {simple_stud translate <(23*wide+0.4), flat, (9*wide+0.4)> }
  object {simple_stud translate <(24*wide+0.4), flat, (9*wide+0.4)> }
  object {simple_stud translate <(25*wide+0.4), flat, (9*wide+0.4)> }
  object {simple_stud translate <(16*wide+0.4), flat, (10*wide+0.4)> }
  object {simple_stud translate <(17*wide+0.4), flat, (10*wide+0.4)> }
  object {simple_stud translate <(18*wide+0.4), flat, (10*wide+0.4)> }
  object {simple_stud translate <(19*wide+0.4), flat, (10*wide+0.4)> }
  object {simple_stud translate <(20*wide+0.4), flat, (10*wide+0.4)> }
  object {simple_stud translate <(21*wide+0.4), flat, (10*wide+0.4)> }
  object {simple_stud translate <(22*wide+0.4), flat, (10*wide+0.4)> }
  object {simple_stud translate <(16*wide+0.4), flat, (11*wide+0.4)> }
  object {simple_stud translate <(17*wide+0.4), flat, (11*wide+0.4)> }
  object {simple_stud translate <(18*wide+0.4), flat, (11*wide+0.4)> }
  object {simple_stud translate <(19*wide+0.4), flat, (11*wide+0.4)> }
  object {simple_stud translate <(20*wide+0.4), flat, (11*wide+0.4)> }
  object {simple_stud translate <(16*wide+0.4), flat, (12*wide+0.4)> }
  object {simple_stud translate <(17*wide+0.4), flat, (12*wide+0.4)> }
  object {simple_stud translate <(18*wide+0.4), flat, (12*wide+0.4)> }
  object {simple_stud translate <(16*wide+0.4), flat, (13*wide+0.4)> }
  object {simple_stud translate <(17*wide+0.4), flat, (13*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (15*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (15*wide+0.4)> }
  object {simple_stud translate <(11*wide+0.4), flat, (15*wide+0.4)> }
  object {simple_stud translate <(12*wide+0.4), flat, (15*wide+0.4)> }
  object {simple_stud translate <(13*wide+0.4), flat, (15*wide+0.4)> }
  object {simple_stud translate <(14*wide+0.4), flat, (15*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (16*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (16*wide+0.4)> }
  object {simple_stud translate <(11*wide+0.4), flat, (16*wide+0.4)> }
  object {simple_stud translate <(12*wide+0.4), flat, (16*wide+0.4)> }
  object {simple_stud translate <(13*wide+0.4), flat, (16*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (17*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (17*wide+0.4)> }
  object {simple_stud translate <(11*wide+0.4), flat, (17*wide+0.4)> }
  object {simple_stud translate <(12*wide+0.4), flat, (17*wide+0.4)> }
  object {simple_stud translate <(13*wide+0.4), flat, (17*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (18*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (18*wide+0.4)> }
  object {simple_stud translate <(11*wide+0.4), flat, (18*wide+0.4)> }
  object {simple_stud translate <(12*wide+0.4), flat, (18*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (19*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (19*wide+0.4)> }
  object {simple_stud translate <(11*wide+0.4), flat, (19*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (20*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (20*wide+0.4)> }
  object {simple_stud translate <(11*wide+0.4), flat, (20*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (21*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (21*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (22*wide+0.4)>  }
  object {simple_stud translate <(10*wide+0.4), flat, (22*wide+0.4)> }
  object {simple_stud translate <(9*wide+0.4), flat, (23*wide+0.4)>  }
  object {simple_stud translate <(9*wide+0.4), flat, (24*wide+0.4)>  }
  object {simple_stud translate <(9*wide+0.4), flat, (25*wide+0.4)>  }


  intersection
   {
   object {ll_base_9x9_studs translate <((32-9)*wide), 0, ((32-9)*wide)> }
   union
    {
     box {<(32*wide), (-1*flat), (32*wide)>, <(26*wide), (+3*flat), (25*wide)> }
     box {<(26*wide), (-1*flat), (32*wide)>, <(24*wide), (+3*flat), (28*wide)> }
     box {<(24*wide), (-1*flat), (32*wide)>, <(23*wide), (+3*flat), (30*wide)> }
     box {<(26*wide), (-1*flat), (28*wide)>, <(25*wide), (+3*flat), (26*wide)> }
     box {<(32*wide), (-1*flat), (25*wide)>, <(30*wide), (+3*flat), (23*wide)> }
     box {<(30*wide), (-1*flat), (25*wide)>, <(28*wide), (+3*flat), (24*wide)> }
    }
  }
  #end
  union
   {
    intersection
     {
      difference
       {
        sphere {<(32*wide), (1*flat), (32*wide)>, (23*wide) scale <1, (1/100000), 1> }
        sphere {<(32*wide), (1*flat), (32*wide)>, (22*wide) }
       }
      box {<(32*wide), (0*flat), (32*wide)>, <(0*wide), (2*flat), (0*wide)> }
      texture { l3g0_road_color }
     }
    intersection
     {
      difference
       {
        sphere {<(32*wide), (1*flat), (32*wide)>, (10*wide) scale <1, (1/100000), 1> }
        sphere {<(32*wide), (1*flat), (32*wide)>, (9*wide)}
       }
      box {<(32*wide), (0*flat), (32*wide)>, <(0*wide), (2*flat), (0*wide)> }
      texture { l3g0_road_color }
     }
    intersection
     {
      difference
       {
        sphere {<(32*wide), (1*flat), (32*wide)>, (15.75*wide) scale <1, (1/100000), 1> }
        sphere {<(32*wide), (1*flat), (32*wide)>, (15.25*wide) }
       }
      union
       {
        box {<0, 0, 0>, <(-1*wide), (2*flat), (-32*wide)> translate <(0*wide), 0, 0> rotate <0, 00, 0> translate <(32*wide), (0*flat), (32*wide)> }
        box {<0, 0, 0>, <(-2*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 11.25, 0> translate <(32*wide), (0*flat), (32*wide)>    }
        box {<0, 0, 0>, <(-2*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 22.50, 0> translate <(32*wide), (0*flat), (32*wide)>    }
        box {<0, 0, 0>, <(-2*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 33.75, 0> translate <(32*wide), (0*flat), (32*wide)>    }
        box {<0, 0, 0>, <(-2*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 45.00, 0> translate <(32*wide), (0*flat), (32*wide)>    }
        box {<0, 0, 0>, <(-2*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 56.25, 0> translate <(32*wide), (0*flat), (32*wide)>    }
        box {<0, 0, 0>, <(-2*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 67.50, 0> translate <(32*wide), (0*flat), (32*wide)>    }
        box {<0, 0, 0>, <(-2*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 78.75, 0> translate <(32*wide), (0*flat), (32*wide)>    }
        box {<0, 0, 0>, <(-1*wide), (2*flat), (-32*wide)> translate <(1*wide), 0, 0> rotate <0, 90, 0>    translate <(32*wide), (0*flat), (32*wide)>    }
       }
      texture { l3g0_white }
     }
    translate <0, (flat), 0>
   }
  rotate <0, 90, 0>
  translate <0, 0, (32*wide)>
 }