/*
l3g0_dbl_wheel_plate    A 2x2 with two axle clips
l3g0_small_wheel_hub    The narrow wheel hub that clips on axles
l3g0_small_wheel_tire   Fits on small_wheel_hub, with treads
l3g0_small_wheel                hub and tire together
l3g0_small_space_wheel     3 stud diameter hard plastic hollow wheel.

 Made by Edward van der Jagt - bivdjagt@cs.few.eur.nl
				http://www.cs.few.eur.nl/~bivdjagt/
l3g0_small_wheel_and_plate              plate+hub+wheel
l3g0_small_wheel_housing_basic
l3g0_small_wheel_housing_squared        `closed' wheel-housing 2x4 (with 8 studs)
l3g0_small_wheel_housing_open   `open` wheel-housing 2x4 (with 4 studs)
*/

#declare ll_axle_clip =
difference
 {
  difference
   {
    cylinder {<0, 0, 0>, <0, 0, axle_length>,stud_height }
    box {<-0.05, -1, 0.34>, <0.05, 1, 1> }
   }
  difference
   {
    cylinder {<0, 0, 0.05>, <0, 0, (axle_length-0.05)>,1 }
    cylinder {<0, 0, 0>, <0, 0, axle_length>, (stud_height-0.03)}
   }
}

#declare l3g0_dbl_wheel_plate =
merge
 {
  #declare XW=2 #declare ZW=2 #include "MakeFlat.inc"
  object {ll_axle_clip translate <wide, 0.14, (2*wide)>}
  object {ll_axle_clip rotate <0, 180, 0> translate <wide, 0.14, 0>}
 }

#declare l3g0_small_wheel_hub =
union
 {
  difference
   {
    cylinder { <0,0,0>,<0,0,flat*2>, wide/2}
    cylinder { <0,0,-1>,<0,0,tall> stud_height}
    sphere { <0,0,0>,(wide/2)-(wall/2) scale <1,1,0.5> translate <0,0,flat*2> }
   }

  cylinder { <0,0,flat*2>,<0,0,flat*2-(wall/2)>, stud_height}
  box { <-wide/2,-wall/4,flat*2> <wide/2,wall/4,flat*2-(wall/2)>}
  box { <-wall/4,-wide/2,flat*2> <wall/4,wide/2,flat*2-(wall/2)>}
  translate <wide,flat/2,wall>
 }

#declare l3g0_small_wheel_tire =
union
 {
  #declare OuterRadius = (tall+flat*1.5)/2
  #declare InnerRadius = wide/2
  #declare TreadHeight = flat/3
  #declare Studs = 16
  #declare Thickness = flat*2
  #include "tire.inc"
  translate <wide,flat/2,flat+wall>
 }

#declare l3g0_small_wheel =
union
 {
 object {l3g0_small_wheel_hub }
 object {l3g0_small_wheel_tire texture { l3g0_rubber } }
}

#declare l3g0_small_space_wheel =
union
 {
  #declare OuterRadius = (tall*2+flat*2)/2
  #declare InnerRadius = wide/2
  #declare TreadHeight = wall
  #declare Studs = 10
  #declare Thickness = tall*2+flat
  #include "tire.inc"
  difference
   {
    cylinder {<0,0,-wall>,<0,0,wall>, (tall*2+flat*2)/2 }
    cylinder {<0,0,-wall>,<0,0,wall>, wide/2}
   }
 }

#declare l3g0_tech_tire =
difference
 {
  union
   {
    #declare OuterRadius = 2*wide+.11
    #declare InnerRadius = wide
    #declare TreadHeight = wide*0.3
    #declare Studs = 20
    #declare Thickness = 1
    #include "tire.inc"
    translate <0,0,wide*0.5>
   }
  union
   {
    cone     {<0, 0, 1.01>, (1.5*wide+.05) <0, 0, (wide)>, (wide) }
    cylinder {<0, 0, 1>,                   <0, 0, -1>, (wide) }
   }
 }

#declare l3g0_tech_wheel =
difference
 {
  union
   {
    difference
     {
      union
       {
        cylinder {<0, 0, 0>, <0, 0, .1>, (wide+.05)}
        cone {<0, 0, .1>, (wide+.05) <0, 0, .2>, (wide-.1)}
        cylinder {<0, 0, .2>, <0, 0, (wide-.2)>, (wide-.1) }
        cone {<0, 0, (wide-.2)>, (wide-.1) <0, 0, (wide-.1)>, (wide+.05)}
        cylinder {<0, 0, (wide-.1)>, <0, 0, (wide)>, (wide+.05) open}
       }
      cylinder {<0, 0, -1>, <0, 0, 1>, (wide+.05-.25)}
     }
    box {<-.1, (wide+.05-.2), 0>, <.1, (-1*(wide+.05-.2)), wide>}
    cylinder {<0, 0, 0>, <0, 0, wide>, (wide/2)}
   }
  object {l3g0_tech_axle_2 translate <0, 0, -.5>}
  box {<(-.55), (-.08), (-1)>, <.55, .08, 1> }
 }


#declare l3g0_small_wheel_and_plate =
union
 {
  union
   {
    object {l3g0_dbl_wheel_plate translate <0, 0, wide> }
    object {l3g0_small_wheel texture { l3g0_grey } translate <0, 0, (3*wide)> }
    translate <0, (-2*flat), 0>
    rotate <0, 180, 0>
    translate <(2*wide), 0, (4*wide)>
   }
  object {l3g0_small_wheel texture { l3g0_grey } translate <0, (-2*flat), (3*wide)>}
  translate <0, (2*flat), (-1*wide)>
 }

#declare l3g0_small_wheel_housing_basic =
union
 {
  union
   {
   #declare XW = 2 #declare ZW=2 #include "MakeFlat.inc"
   translate <0,0,wide>
  }
  difference
   {
    union
     {
      #declare XW = 2 #declare YW = flat*2 #declare ZW= 1 #include "BrickBox.inc"
     }
    union
     {
      box { <0,0,-flat> <flat*2,-flat*1.5,flat> translate <wide-flat,flat*1.2,0>}
      box { <0,0,-flat> <flat*2,-flat*2.5,flat> rotate <0,0,-45> translate <(wide-flat),flat*1.2,0>}
      box { <0,0,-flat> <-flat*2,-flat*2.5,flat> rotate <0,0,45> translate <(wide+flat),flat*1.2,0>}
     }
   }
  difference
   {
    union
     {
      #declare XW = 2 #declare YW = flat*2 #declare ZW= 1 #include "BrickBox.inc"
     }
    union
     {
      box { <0,0,-flat> <flat*2,-flat*1.5,flat> translate <wide-flat,flat*1.2,0>}
      box { <0,0,-flat> <flat*2,-flat*2.5,flat> rotate <0,0,-45> translate <(wide-flat),flat*1.2,0>}
      box { <0,0,-flat> <-flat*2,-flat*2.5,flat> rotate <0,0,45> translate <(wide+flat),flat*1.2,0>}
      translate <0,0,wide>
     }
    translate <0,0,wide*3>
   }
 }

#declare l3g0_small_wheel_housing_squared =
union
 {
  object {l3g0_small_wheel_housing_basic }
  object {studx2 translate <0, (2*flat), wide*0.5> }
  object {studx2 translate <0,flat*2,wide*3.5>}
 }


#declare l3g0_small_wheel_housing =
union
 {
  union
   {
    #declare XW = 2 #declare ZW=2 #include "MakeFlat.inc"
    translate <0,0,wide>
   }

  polygon {5,  <0,0,wide> <wide*0.5, flat*2, wide> <wide*1.5, flat*2, wide> <wide*2,0,wide> <0,0,wide>}
  polygon {5,  <0,0,wide> <wide*0.5, flat*2, wide-wall> <wide*1.5, flat*2, wide-wall> <wide*2,0,wide> <0,0,wide>}

  polygon {5,  <0,0,wide*3> <wide*0.5, flat*2, wide*3> <wide*1.5, flat*2, wide*3> <wide*2,0,wide*3> <0,0,wide*3>}
  polygon {5,  <0,0,wide*3> <wide*0.5, flat*2, wide*3+wall> <wide*1.5, flat*2, wide*3+wall> <wide*2,0,wide*3> <0,0,wide*3>}

  difference
   {
    box {<0, 0, 0>, <2*wide, 2*flat, (wide)> translate <0, 0, 3*wide> }
    union
     {
      box {<(5/8*wide),-1, -.1>, <(11/8*wide), (.44), wide> }
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-5/8*wide), 0, 0>          scale <2, 1, 1> rotate <0, 0, -50>  translate <(+11/8*wide), (2*flat), 0> }
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-11/8*wide), 0, 0>         scale <2, 1, 1> rotate <0, 0, +50> translate <(+5/8*wide), (2*flat), 0>  }
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-5/8*wide), (-1*(.44)), 0> scale <2, 1, 1> rotate <0, 0, -50> translate <(+11/8*wide), (+1*(.44)), 0>}
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-11/8*wide), (-1*(.44)), 0>scale <2, 1, 1> rotate <0, 0, +50> translate <(+5/8*wide), (+1*(.44)), 0>}

      scale <1, 1, 1.5>
      translate <(((0)*wide)+(((0)*2)*wide)), ((0)*(3*flat)), ((3)*wide)>
     }
   }
  difference
   {
    box {<0, 0, 0>, <2*wide, 2*flat, wide> }
    merge
     {
      box {<(5/8*wide),-1, -.1>, <(11/8*wide), (.44), wide> }
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-5/8*wide), (-1*(.44)), 0>  scale <2, 1, 1> rotate <0, 0, -50> translate <(+11/8*wide), (+1*(.44)), 0>}
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-11/8*wide), (-1*(.44)), 0> scale <2, 1, 1> rotate <0, 0, +50> translate <(+5/8*wide), (+1*(.44)), 0> }
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-5/8*wide), 0, 0>           scale <2, 1, 1> rotate <0, 0, -50> translate <(+11/8*wide), (2*flat), 0> }
      box {<(5/8*wide), 0, -.1>, <(11/8*wide), (.44), wide> translate <(-11/8*wide), 0, 0>          scale <2, 1, 1> rotate <0, 0, +50> translate <(+5/8*wide), (2*flat), 0>  }

      scale <1, 1, 1.5>
     }
   }
 }