#declare ramp_stud =
difference
 {
  cylinder {   <0, tall+stud_height, 0>,   <0, 0, 0>,   stud_radius  }
  cylinder {   <0, tall+stud_height+1,0>,   <0, 0-1, 0>,  flat/2 }
 }

#declare l3g0_r4x2 =union { #declare XW=2 #declare YW=1 #declare ZW=4 #include "MakeRamp.inc" }
#declare l3g0_r3x2 =union { #declare XW=2 #declare YW=1 #declare ZW=3 #include "MakeRamp.inc" }
#declare l3g0_r2x2 =union { #declare XW=2 #declare YW=1 #declare ZW=2 #include "MakeRamp.inc" }
#declare l3g0_r1x2 =union { #declare XW=2 #declare YW=1 #declare ZW=1 #include "MakeRamp.inc" }
#declare l3g0_r1x2x3 =union { #declare XW=2 #declare YW=3 #declare ZW=1 #include "MakeRamp.inc" }
#declare l3g0_r2x2x3 =union { #declare XW=2 #declare YW=3 #declare ZW=2 #include "MakeRamp.inc" }
#declare l3g0_r1x3 =union { #declare XW=3 #declare YW=1 #declare ZW=1 #include "MakeRamp.inc" }
#declare l3g0_r2x3 =union { #declare XW=3 #declare YW=1 #declare ZW=2 #include "MakeRamp.inc" }
#declare l3g0_r4x3 =union { #declare XW=3 #declare YW=1 #declare ZW=4 #include "MakeRamp.inc" }
#declare l3g0_u1x2 =union { #declare XW=2 #declare YW=1 #declare ZW=1 #include "MakeUp.inc" }
#declare l3g0_u1x3 =union { #declare XW=3 #declare YW=1 #declare ZW=1 #include "MakeUp.inc" }
#declare l3g0_u2x3 =union { #declare XW=3 #declare YW=1 #declare ZW=2 #include "MakeUp.inc" }
#declare l3g0_u2x2 =union { #declare XW=2 #declare YW=1 #declare ZW=2 #include "MakeUp.inc" }


#declare l3g0_reptron_r2x3 =
union
 {
  #declare XW=3 #declare YW=1 #declare ZW=2
  polygon {5, <wide,tall,0>, <wide,tall,ZW*wide>, <wide*XW,0.2, ZW*wide> <wide*XW,0.2,0> <wide,tall,0> translate < 0,-0.001,0>}
  difference
   {
    union
     {
      difference
       {
        #if(Detail_level = 2)
        superellipsoid {
         <0.05, 0.05>
         scale <wide*XW*0.5, YW*tall*0.5, wide*ZW*0.5>
         translate <wide*XW*0.5, YW*tall*0.5, wide*ZW*0.5>
        }
#else
   box { <0, 0, 0>, <XW*wide, YW*tall, ZW*wide>
   }
#end
   prism {
    -wall, (-ZW*wide)+wall,
    5, <wall, 0-.1>, <(XW*wide)-wall+.1, 0-.1>,
    <wide, (YW*tall)-wall>, <wall, (YW*tall)-wall>,
    <wall, 0-.1>
    rotate <-90, 0, 0>
   }
  }
  #declare xOffset=wide
  #declare yOffset=wide
  #declare yLim = ZW-1
  #declare xLim = XW-1
  #declare xStart=wide
  #declare yStart=wide
  #declare elevation = 0
  #declare GridObject = object { column }
  #include "grid.inc"
 }
 difference {
  box {
   <0, 0, 0-.00001>, <XW*wide+.00001, (YW*tall)+.00001, ZW*wide+.00001>
  }
#if(Detail_level = 2)
  superellipsoid {
   <0.05, 0.05>
   scale <sqrt(0.5), sqrt(0.5), 1>
   rotate <0, 0, 45>
   scale <(XW-1)*wide, (YW*tall)-0.2, ZW*wide/2>
   translate <0, 0, ZW*wide/2>
    texture {
     pigment {
      image_map { gif "ll_reptr.gif" transmit 245 1.0}
     }
     rotate <180, 90, 0>
     scale <1, (YW*tall)-0.2, ZW*wide>
    }
  }
#else

  box {
   <-1, -1, -.1>, <1, 1, 1.1>
   scale <sqrt(0.5), sqrt(0.5), 1>
   rotate <0, 0, 45>
   scale <(XW-1)*wide, (YW*tall)-0.2, ZW*wide>
    texture {
     pigment {
      image_map { gif "ll_reptr.gif" transmit 245 1.0 }
     }
     rotate <180, 90, 0>
     scale <1, (YW*tall)-0.2, ZW*wide>
    }
  }
#end
 translate <wide, 0.2, 0>
 }
}
#declare xOffset=wide
#declare yOffset=wide
#declare yLim = ZW
#declare xLim = 1
#declare xStart=wide*0.5
#declare yStart=wide*0.5
#declare elevation = YW*tall
#declare GridObject = object { stud }
#include "grid.inc"
}

#declare l3g0_inverse_ramp_pair_with_cutout_2x4 =
union {
 difference {
  union {
   difference {
#if(Detail_level = 1)
    superellipsoid {
     <0.05, 0.05>
     scale <wide*0.5, tall*0.5, 2*wide*0.5>
     translate <wide*0.5, tall*0.5, 2*wide*0.5>
    }
#else
    box { <0, 0, 0>, <wide, tall, 2*wide> }
#end
    prism {
     -wall, (-2*wide)+wall,
     4, <wide-wall, wall>, <wide-wall, tall+.00001>
     <wall-.00001, tall+.00001>, <wide-wall, wall>
     rotate <-90, 0, 0>
    }
   }
   difference {
#if(Detail_level = 1)
    superellipsoid {
    <0.05, 0.05>
    scale <wide*0.5, tall*0.5, 2*wide*0.5>
    translate <3.5*wide, tall*0.5, 2*wide*0.5>
    }
#else
    box { <0, 0, 0>, <wide, tall, 2*wide>
     translate <3*wide, 0, 0>
    }
#end
    prism {
     -wall, (-2*wide)+wall,
     4, <wide-wall, wall>, <wide-wall, tall+.00001>
     <wall-.00001, tall+.00001>, <wide-wall, wall>
     rotate <-90, 0, 0>
     rotate <0, 180, 0>
     translate <4*wide, 0, 2*wide>
    }
   }
   box { <wide*0.5, 0, 0>, <3.5*wide, flat, 2*wide> }
   object { ramp_stud translate <wide*0.5, 0, wide*0.5> }
   object { ramp_stud translate <wide*0.5, 0, 1.5*wide> }
   object { ramp_stud translate <3.5*wide, 0, wide*0.5> }
   object { ramp_stud translate <3.5*wide, 0, 1.5*wide> }
  }
  difference {
   box {
    <0, 0-.00001, 0-.00001>, <wide+.00001, (tall)-0.2, 2*wide+.00001>
   }
#if(Detail_level = 1)
   superellipsoid {
    <0.05, 0.05>
    scale <sqrt(0.5), sqrt(0.5), 1>
    rotate <0, 0, 45>
    scale <wide, (tall)-0.2, 2*wide/2>
    translate <0, (tall)-0.2, 2*wide/2>
   }
#else
   box {
    <-1, -1, -.1>, <1, 1, 1.1>
    scale <sqrt(0.5), sqrt(0.5), 1>
    rotate <0, 0, 45>
    scale <wide, (tall)-0.2, 2*wide>
    translate <0, (tall)-0.2, 0>
   }
#end
  rotate <0, 180, 0>
  translate <wide, 0, 2*wide>
  }
  difference {
   box {
    <0, 0-.00001, 0-.00001>, <wide+.00001, (tall)-0.2, 2*wide+.00001>
   }
#if(Detail_level = 1)
   superellipsoid {
    <0.05, 0.05>
    scale <sqrt(0.5), sqrt(0.5), 1>
    rotate <0, 0, 45>
    scale <wide, (tall)-0.2, 2*wide/2>
    translate <0, (tall)-0.2, 2*wide/2>
   }
#else
   box {
    <-1, -1, -.1>, <1, 1, 1.1>
    scale <sqrt(0.5), sqrt(0.5), 1>
    rotate <0, 0, 45>
    scale <wide, (tall)-0.2, 2*wide>
    translate <0, (tall)-0.2, 0>
   }
#end
  translate <3*wide, 0, 0>
  }
#if( Detail_level = 1 )
  difference {
   box { <wide, 0-.00001, 0-.00001>, <3*wide, flat+.00001, 2*wide+.00001> }
   superellipsoid {
    <0.05, 0.05>
    scale <3*wide/2, flat/2, 2*wide/2>
    translate <2*wide, flat/2, wide>
   }
  }
#else
#end
  box { <wide+wall, -.00001, wall>,
        <3*wide-wall, flat-wall, 2*wide-wall>
  }
 }
 object { flat_column translate <2*wide, 0, wide> }
 object { studx2 translate <wide, flat, wide*0.5> }
 object { studx2 translate <wide, flat, 1.5*wide> }
}