/*
l3g0_t1x2               Technic beam, 2 studs long
l3g0_t1x4
l3g0_t1x6               Contributed by Jason Eddy
l3g0_t1x8               Contributed by Jason Eddy
l3g0_t1x10              Contributed by Jason Eddy
l3g0_t1x12              Contributed by Jason Eddy
l3g0_t1x16              Technic beam, 16 studs long - Contributed by Jason Eddy
l3g0_tech_1x4_sloped_beam
                        technic beam with 2 studs and vertical upper and lower trapezoidal
                        ramps. Used as leading edge of airplane wing.
l3g0_tech_1x6_sloped_beam
                        technic beam with 2 studs and verical upper
                        ramp. Used as trailing edge of airplane wing.
l3g0_connector_peg              technic connector peg - contributed by Jason Eddy
l3g0_friction_peg               technic friction peg - contributed by Jason Eddy
l3g0_b2x2_with_tech_connector_peg       2x2 brick with connector peg attached
l3g0_tech_piston_rod

*/

#declare tech_beam_cylinder = cylinder {<wide, (tall-wide*0.5), 0>,<wide, (tall-wide*0.5), wide>,(cyl_base_rad+0.01) }

#declare tech_beam_hole =
merge
 {
  cylinder {<wide, (tall-wide*0.5), (-1*0.001)>, <wide, (tall-wide*0.5), (0.16/2)>,cyl_base_rad }
  cylinder {<wide, (tall-wide*0.5), (wide-(0.16/2))>, <wide, (tall-wide*0.5), (wide+0.001)>,(cyl_base_rad) }
  cylinder {<wide, (tall-wide*0.5), 0>, <wide, (tall-wide*0.5), wide>,(stud_radius) }
 }

#declare l3g0_t1x2 = union { #declare XW=2 #include "MakeTech.inc" }
#declare l3g0_t1x3 = union { #declare XW=3 #include "MakeTech.inc" }
#declare l3g0_t1x4 = union { #declare XW=4 #include "MakeTech.inc" }
#declare l3g0_t1x6 = union { #declare XW=6 #include "MakeTech.inc" }
#declare l3g0_t1x8 = union { #declare XW=8 #include "MakeTech.inc" }
#declare l3g0_t1x10 = union { #declare XW=10 #include "MakeTech.inc" }
#declare l3g0_t1x12 = union { #declare XW=12 #include "MakeTech.inc" }
#declare l3g0_t1x16 = union { #declare XW=16 #include "MakeTech.inc" }

#declare l3g0_tech_1x4_sloped_beam =
difference
 {
  merge
   {
    union
     {
      polygon {9, <0, 0, 0>,  <0, 0.96, 0>,  <1.6, 0.96, 0>,  <1.6, (4*flat), 0>,  <3.2, 0.64, 0>,  <3.2, 0, 0>,  <1.6, (-flat), 0>,  <1.6, 0, 0>,   <0, 0, 0>  }
      polygon {9, <0, 0, wide>,  <1.6, 0, wide>,  <1.6, (-flat), wide>,  <3.2, 0, wide>,  <3.2, 0.64, wide>,  <1.6, (4*flat), wide>,  <1.6, 0.96, wide>,  <0, 0.96, wide>,   <0, 0, wide>  }
      polygon {5, <0, 0, 0>,  <1.6, 0, 0>,  <1.6, 0, wide>,  <0, 0, wide>,   <0, 0, 0>  }
      polygon {5, <1.6, 0, 0>,  <1.6, (-flat), 0>,  <1.6, (-flat), wide>,  <1.6, 0, wide>,   <1.6, 0, 0>  }
      polygon {5, <1.6, (-flat), 0>,  <3.2, 0, 0>,  <3.2, 0, wide>,  <1.6, (-flat), wide>,   <1.6, (-flat), 0>  }
      polygon {5, <3.2, 0, 0>,  <3.2, 0.64, 0>,  <3.2, 0.64, wide>,  <3.2, 0, wide>,   <3.2, 0, 0>  }
      polygon {5, <3.2, 0.64, 0>,  <1.6, (4*flat), 0>,  <1.6, (4*flat), wide>,  <3.2, 0.64, wide>,   <3.2, 0.64, 0>  }
      polygon {5, <1.6, (4*flat), 0>,  <1.6, 0.96, 0>,  <1.6, 0.96, wide>,  <1.6, (4*flat), wide>,   <1.6, (4*flat), 0>  }
      polygon {5, <1.6, 0.96, 0>,  <0, 0.96, 0>,  <0, 0.96, wide>,  <1.6, 0.96, wide>,   <1.6, 0.96, 0>  }
      polygon {5, <0, 0.96, 0>,  <0, 0, 0>,  <0, 0, wide>,  <0, 0.96, wide>,   <0, 0.96, 0>  }
     }
    #if (Detail_level > 0)
    object {   tech_stud   translate <wide*0.5, tall, wide*0.5>  }
    object {   tech_stud   translate <(wide+wide*0.5), tall, wide*0.5>  }
    #end
   }
  object {  tech_beam_hole }
  object {  tech_beam_hole  translate <wide, 0, 0> }
 }


#declare l3g0_tech_1x6_sloped_beam =
difference
 {
  union
   {
    difference
     {
      prism
       {
        linear_spline
        0, wide,
        9
        <0,flat>
        <wide*2,flat>
        <wide*2,0>
        <wide*6,0>
        <wide*6,flat>
        <wide*2,tall+flat+flat>
        <wide*2,tall+flat>
        <0,tall+flat>
        <0,flat>
       }

      prism
       {
        linear_spline
        wall, wide-wall,
        7
        <wall,0>
        <wide*6-wall, -wall>
        <wide*6-wall,flat-wall>
        <wide*2,(tall+flat+flat)- wall>
        <wide*2,(tall+flat)- wall>
        <wall,tall+flat>
        <wall,0>
       }
      rotate <-90,0,0>
      translate <0,-flat,wide>
     }

    box { <wide*2,-flat,0> <wide*2+wall,flat,wide> }
    #if (Detail_level > 0)
    object {tech_stud translate <wide*0.5, tall, wide*0.5>}
    object {tech_stud translate <(wide+wide*0.5), tall, wide*0.5>}
    object {thin_flat_column translate <wide,0,wide*0.5> }
    object {thin_column translate <wide*3,-flat,wide*0.5>}
    object {thin_column translate <wide*4,-flat,wide*0.5>}
    object {thin_flat_column translate <wide*5,-flat,wide*0.5>}
    #end

    object {tech_beam_cylinder}
    object {tech_beam_cylinder translate <wide, 0, 0> }
    object {tech_beam_cylinder translate <(2*wide), 0, 0>}
   }
  object {tech_beam_hole }
  object {tech_beam_hole translate <wide, 0, 0> }
  object {tech_beam_hole translate <(2*wide), 0, 0>}
 }


#declare l3g0_tech_connector_peg =
difference
 {
  merge
   {
    cylinder {<0, 0, 0>, <(2*wide), 0, 0>, stud_radius}
    cylinder {<(wide-.07), 0, 0>, <(wide+.07), 0, 0>, (stud_radius+.055)}
    #if (Detail_level=2)
    torus {stud_radius, .03  rotate <0, 0, 90> translate <0, 0, 0>}
    torus {stud_radius, .03  rotate <0, 0, 90> translate <(2*wide), 0, 0> }
    #end
   }
  cylinder {<0, 0, 0>, <(2*wide), 0, 0>, (stud_radius-.04)}
  box {<-1, 1, -.04>, <(.4*wide), -1, .04>}
  box {<(2*wide-.4*wide), 1, -.04>, <2, -1, .04>}
 }


#declare l3g0_tech_friction_peg =
difference
 {
  merge
   {
    cylinder {<0, 0, 0>, <(2*wide), 0, 0>,stud_radius}
    cylinder {<(wide-.07), 0, 0>, <(wide+.07), 0, 0>,(stud_radius+.055)}
    #if (Detail_level = 2)
    torus {stud_radius, .03 rotate <0, 0, 90> translate <0, 0, 0>}
    torus {stud_radius, .03 rotate <0, 0, 90> translate <(2*wide), 0, 0>}
    #end
   }
  cylinder {<0, 0, 0>, <(2*wide), 0, 0>, (stud_radius-.04)}
  box {<-1, 1, -.04>, <(.4*wide), -1, .04> }
  box {<(2*wide-.4*wide), 1, -.04>, <2, -1, .04>}
  box {<(.5*wide), -.04, -1>, <(2*wide-.5*wide), .04, 1>}
 }

#declare l3g0_b2x2_with_tech_connector_peg =
union
 {
  object {tall2x2}
  difference
   {
    object {l3g0_tech_connector_peg  rotate <0, -90, 0>  translate <wide, (tall-wide*0.5), wide>}
    box { <0,0,0> <wide*2,tall,wide*2>}
   }
 }

#declare l3g0_tech_piston_rod =
union
 {
  difference
   {
    union
     {
      object {l3g0_tech_spacer}
      cylinder {<(wide-.01), 0, 0>, <(1.5*wide), 0, 0>,(wide/2)}
      intersection
       {
        cylinder {<(1.5*wide), -1, 0>, <(1.5*wide), 1, 0>, (wide/2+.05)}
        box {<-.2, -.4, -.4>, <(1.5*wide+.2), (wide/2), .4>}
       }
      intersection
       {
        cylinder {<(1.5*wide), -1, 0>, <(1.5*wide), 1, 0>,(wide/2)}
        box {     <-.2, -.4, -.4>, <(2*wide), .4, .4> }
       }
      #if (Detail_level > 0)
      object {simple_stud rotate <90, 0, 0> translate <(1.5*wide), 0, (.5*wide)> }
      object {simple_stud rotate <-90, 0, 0> translate <(1.5*wide), 0, (-.5*wide)>}
      #end
     }
    cylinder {<(1.5*wide), (wide/2+.1), 0>, <(1.5*wide), (wide/2-(0.16/2)), 0>,cyl_base_rad}
    cylinder {<(1.5*wide), (-.5*wide-.1), 0>, <(1.5*wide), (-.5*wide+(0.16/2)), 0>,cyl_base_rad}
    cylinder {<(1.5*wide), -1, 0>,<(1.5*wide), 1, 0>,stud_radius}
   }
 }

#declare piston_head =
union
 {
  #declare XW=2 #declare YW=tall+flat #declare ZW=2 #include "BrickBox.inc"
  #if (Detail_level > 0)
  object { tech_studx2 translate <0,flat+tall,wide*0.5> }
  object { tech_studx2 translate <0,flat+tall,wide*1.5> }
  #end
}


#declare l3g0_tech_piston_head =
difference
 {
  object {piston_head }
  sphere {<0, .32, wide>, (wide/2) }
  sphere {<(2*wide), .32, wide>, (wide/2) }
  box {<-1, -1, (.4)>, <2, (.34), 1.2> }
 }

