/*
   LEGO (Tm) Pieces for POV

   Created by Jon Paynter (jonp@earthlink.net)

   Based on Stefan Maes (maes@uia.ua.ac.be), and Paul Gyugyi's
   (gyugyi@earthsea.stanford.edu) Rayshade LegoLib

   This include file contains deffinitions to generate an arbitrarly sized tire.
*/

/*
  this file expects the following variables to be defined:

  OuterRadius  - set to the radius of the outside of the tire
  InnerRadius  - set to the radius of the 'hole' in the tire
     (Note:  InnerRadius < OuterRadius)

  TreadHeight  - set to the height of the studs on the tread
  Studs - set to the number of 'studs' that will go around the tire
  Thickness - set to the width of the tire

 */

#declare StudWidth = (3.14159265358 * OuterRadius) / Studs

#declare TireStud = intersection
 {
  box { <-StudWidth/2,OuterRadius-(TreadHeight*1.1),0> <StudWidth/2, OuterRadius, Thickness/2> }
  cylinder { <0,0,-Thickness>, <0,0,Thickness>, OuterRadius}
 }

#declare Count=0
#declare RingOfStuds =
union
 {
  #while (Count < (Studs*2))
    object { TireStud rotate <0,0, (360 / (Studs*2)) * Count>}
    #declare Count = Count + 2
  #end
 }

difference
 {
  union
   {
    object {RingOfStuds translate <0,0,-Thickness/2>}
    object {RingOfStuds rotate <0,0, (360 / (Studs*2))> }
    cylinder {<0,0,-(Thickness/2)>, <0,0,Thickness/2>, OuterRadius-TreadHeight}
   }
  cylinder { <0,0,-Thickness>, <0,0,Thickness>, InnerRadius}
  bounded_by {cylinder {<0,0,-Thickness*1.1> < 0,0,Thickness*1.1>, OuterRadius*1.1}}
 }