; TV Noise (PAL version)

; [c] 2010 Ferris / Youth Uprising
				
;==================================================================================================================
; Assembler Directives
				processor 6502
				seg
				org $f000
				
;==================================================================================================================
; Variables
framecounter	equ $80
randseed		equ $81
				
;==================================================================================================================
; Reset
reset			lda #$00
				sta $09
				sta framecounter
				lda #$ab
				sta randseed
				
				; Audio setup
				lda #$08
				sta $15
				lda #$09
				sta $17
				lda #$0f
				sta $19
				
;==================================================================================================================
; Kernal
kernal				inc framecounter
					
					; Main screen turn on.
					lda #$00
					sta $01
					sta $08
					sta $09
					
					; 3 lines of VSync
					lda #$02
					sta $00
					sta $02
					sta $02
					sta $02
					lda #$00
					sta $00
					
					; 37 lines of VBlank (busy wait for 36)
					ldx #$24
vbl						sta $02
					dex
					bne vbl
					
					; Line 37: set up picture
					ldx framecounter
					lda ctab,x
					tay
					sta $02
					
					; 242 lines of picture
					ldx #$f2
						; Set playfield color
picl					iny
						tya
						and #$0f
						sta $08
						; Set playfield pattern (a random pass for each register)
						lda randseed
						asl
						bcc rand_no_eor1
							eor #$cf
rand_no_eor1			sta $0d
						asl
						bcc rand_no_eor2
							eor #$cf
rand_no_eor2			sta $0e
						asl
						bcc rand_no_eor3
							eor #$cf
rand_no_eor3			sta $0f
						sta randseed
						sta $02
					dex
					bne picl
					
					; 30 lines of overscan
					lda #$42
					sta $01
					ldx #$1e
osl						sta $02
					dex
					bne osl
				
				jmp kernal
				
;==================================================================================================================
; Data
ctab			.byte $80,$78,$70,$68,$60,$59,$51,$4a,$43,$3d,$36,$30,$2a,$25,$20,$1b
				.byte $17,$13,$10,$d,$a,$8,$7,$6,$6,$6,$6,$7,$8,$a,$d,$f
				.byte $13,$16,$1a,$1f,$23,$28,$2d,$33,$39,$3f,$45,$4b,$52,$58,$5f,$65
				.byte $6c,$73,$79,$7f,$86,$8c,$92,$98,$9d,$a3,$a8,$ad,$b1,$b6,$b9,$bd
				.byte $c0,$c3,$c6,$c8,$ca,$cb,$cc,$cd,$cd,$cd,$cd,$cc,$cb,$ca,$c8,$c7
				.byte $c5,$c2,$c0,$bd,$ba,$b7,$b4,$b0,$ad,$a9,$a6,$a2,$9f,$9b,$98,$94
				.byte $91,$8e,$8b,$88,$85,$82,$80,$7d,$7b,$79,$77,$76,$74,$73,$73,$72
				.byte $71,$71,$71,$71,$72,$72,$73,$74,$75,$76,$77,$79,$7a,$7c,$7d,$7f
				.byte $80,$82,$83,$85,$86,$88,$89,$8a,$8b,$8c,$8d,$8d,$8e,$8e,$8e,$8e
				.byte $8d,$8c,$8c,$8b,$89,$88,$86,$84,$82,$80,$7d,$7a,$77,$74,$71,$6e
				.byte $6b,$67,$64,$60,$5d,$59,$56,$52,$4f,$4b,$48,$45,$42,$3f,$3d,$3a
				.byte $38,$37,$35,$34,$33,$32,$32,$32,$32,$33,$34,$35,$37,$39,$3c,$3f
				.byte $42,$46,$49,$4e,$52,$57,$5c,$62,$67,$6d,$73,$79,$7f,$86,$8c,$93
				.byte $9a,$a0,$a7,$ad,$b4,$ba,$c0,$c6,$cc,$d2,$d7,$dc,$e0,$e5,$e9,$ec
				.byte $f0,$f2,$f5,$f7,$f8,$f9,$f9,$f9,$f9,$f8,$f7,$f5,$f2,$ef,$ec,$e8
				.byte $e4,$df,$da,$d5,$cf,$c9,$c2,$bc,$b5,$ae,$a6,$9f,$97,$8f,$87,$80
				
;==================================================================================================================
; Output Info
				echo * - reset,"/ $1000 bytes of ROM"
				
;==================================================================================================================
; Hardware Vectors
				org $fffa
				
				.word reset ; NMI
				.word reset ; Reset
				.word reset ; IRQ
