;
;	Simple Timer C replayer for unpacked 200Hz SNDH files 
;	 (c) Gareth Morris 2005
;

	section	text
;................................................................
	clr.l	-(sp)			; supervisor mode
	move.w	#$20,-(sp)		;
	trap	#1			;
	addq.l	#6,sp			;
	move.l	d0,oldusp		; store old user stack pointer

	move.l	$114.w,oldtc		; store old timer C vector
	move.l	#timerc,$114.w		; steal timer C

	moveq	#2,d0			; select sub-tune 2
	bsr	MUSIC			; init music

	move.w	#7,-(sp)		; wait for a key
	trap	#1			;
	addq.l	#2,sp			;

	bsr	MUSIC+$4		; de-init music

	move.l	oldtc,$114.w		; restore timer c

	move.l	oldusp(pc),-(sp)	; user mode
	move.w	#$20,-(sp)		;
	trap	#1			;
	addq.l	#6,sp			;

	clr.w   -(sp)                   ; pterm()
	move.w	#$4c,-(sp)		;
	trap    #1      		;

;................................................................
timerc:	move.w	sr,-(sp)		; store status register
	move.w  #$2500,sr		; enable interrupts except vbl (allows timer effects)
	bsr 	MUSIC+$8		; call music
	move.w	(sp)+,sr		; restore status register
        move.l  oldtc(pc),-(sp)		; go to old vector (system friendly ;) )
        rts

oldtc:	ds.l	1
oldusp:	ds.l	1

;................................................................
MUSIC:	incbin	multsndh.snd		; SNDH file to include
