/*
 Vocoder               SCY/.tSCc.
   26.02.99

   File I/O
*/

// Includes /*fold00*/
#include <fcntl.h>
#include <math.h>
#include "common.h"
#include "fileio.h"
#include "io.h"

#ifndef LINUX
#include <io.h>
#include <SYS\STAT.H>
#endif

// Globals /*fold00*/
extern char *outfile;
struct fs{
   int fd;
   int pos;
};

struct fs fs_formant={0,0};
struct fs fs_carrier={0,0};
struct fs fs_output={0,0};

#define FILE_IO_BUFFER_SIZE 102400
char file_io_buffer[FILE_IO_BUFFER_SIZE];  // @@@ dynamic allocation?


//  *** LINUX section   start *** /*fold00*/
#ifdef LINUX

// file_init_formant /*fold00*/
int file_init_formant(){
   memset(&fs_formant,0,sizeof(fs_formant));
   fs_formant.fd=open(TESTSAMPLE_FORMANT,O_RDONLY|O_NONBLOCK);
   if(!fs_formant.fd){
      ERR_PRINTF("can't open file"TESTSAMPLE_FORMANT": %s\n",strerror(errno));
      return ERR_SYSTEM;
   }
   
   return 0;
}

// file_init_carrier /*fold00*/
int file_init_carrier(){
   memset(&fs_carrier,0,sizeof(fs_carrier));
   fs_carrier.fd=open(TESTSAMPLE_CARRIER,O_RDONLY|O_NONBLOCK);
   if(!fs_carrier.fd){
      ERR_PRINTF("can't open file"TESTSAMPLE_CARRIER": %s\n",strerror(errno));
      return ERR_SYSTEM;
   }
   
   return 0;
}

// file_init_output /*fold00*/
int file_init_output(){
   memset(&fs_output,0,sizeof(fs_output));
   fs_output.fd=open(filename_output,O_WRONLY|O_CREAT|O_NONBLOCK,0666);
   if(!fs_output.fd){
      ERR_PRINTF("can't open file %s: %s\n",filename_output,strerror(errno));
      return ERR_SYSTEM;
   }
   
   return 0;
}


// file_read_formant /*fold00*/
int file_read_formant(Sample *buf,int len){
   int read_len;
   int i;
   
   char *buf2;
   int ret;
   
   len=len<FILE_IO_BUFFER_SIZE?len:FILE_IO_BUFFER_SIZE;

   buf2=file_io_buffer;
   read_len=0;
   while(read_len<len){
      ret=read(fs_formant.fd,buf2,sizeof(file_io_buffer[0])*(len-read_len));
      if(ret==-1){
         return ERR_SYSTEM;
      }
      buf2+=ret;
      read_len+=ret/sizeof(file_io_buffer[0]);
      if(read_len<len){
         if(flag_output==FLAG_IO_FILE){
            if(read_len>0) break;
            return ERR_EOF;
         }
         if(lseek(fs_formant.fd,0,SEEK_SET)<0){ // loop, if possible
            return ERR_EOF;
         }
      }
   }
   
#ifndef FAST_CONVERT_LOOPS
   for(i=0;i<read_len;i++){
      buf[i]=(Sample)file_io_buffer[i]/128.0;
   }
#else
   for(i=0;i<(read_len&~15);i+=16){
      buf[i]=(Sample)file_io_buffer[i]/128.0;
      buf[i+1]=(Sample)file_io_buffer[i+1]/128.0;
      buf[i+2]=(Sample)file_io_buffer[i+2]/128.0;
      buf[i+3]=(Sample)file_io_buffer[i+3]/128.0;
      buf[i+4]=(Sample)file_io_buffer[i+4]/128.0;
      buf[i+5]=(Sample)file_io_buffer[i+5]/128.0;
      buf[i+6]=(Sample)file_io_buffer[i+6]/128.0;
      buf[i+7]=(Sample)file_io_buffer[i+7]/128.0;
      buf[i+8]=(Sample)file_io_buffer[i+8]/128.0;
      buf[i+9]=(Sample)file_io_buffer[i+9]/128.0;
      buf[i+10]=(Sample)file_io_buffer[i+10]/128.0;
      buf[i+11]=(Sample)file_io_buffer[i+11]/128.0;
      buf[i+12]=(Sample)file_io_buffer[i+12]/128.0;
      buf[i+13]=(Sample)file_io_buffer[i+13]/128.0;
      buf[i+14]=(Sample)file_io_buffer[i+14]/128.0;
      buf[i+15]=(Sample)file_io_buffer[i+15]/128.0;
   }
   for(i=read_len&~15;i<read_len;i++){
      buf[i]=(Sample)file_io_buffer[i]/128.0;
   }
#endif

   fs_carrier.pos+=read_len;
   
   return read_len;
}


// file_read_carrier /*fold00*/
int file_read_carrier(Sample *buf,int len){
   int read_len;
   int ret;
   char *buf2;
   int i;
   
   len=len<FILE_IO_BUFFER_SIZE?len:FILE_IO_BUFFER_SIZE;

   buf2=file_io_buffer;
   read_len=0;
   while(read_len<len){
      ret=read(fs_carrier.fd,buf2,sizeof(file_io_buffer[0])*(len-read_len));
      if(ret==-1){
         return ERR_SYSTEM;
      }
      buf2+=ret;
      read_len+=ret/sizeof(file_io_buffer[0]);
      if(read_len<len){
         if(lseek(fs_carrier.fd,0,SEEK_SET)<0){ // loop, if possible
            return ERR_EOF;
         }
      }
   }
   
#ifndef FAST_CONVERT_LOOPS
  for(i=0;i<read_len;i++){
      buf[i]=(Sample)file_io_buffer[i]/128.0;
   }
#else
   for(i=0;i<(read_len&~15);i+=16){
      buf[i]=(Sample)file_io_buffer[i]/128.0;
      buf[i+1]=(Sample)file_io_buffer[i+1]/128.0;
      buf[i+2]=(Sample)file_io_buffer[i+2]/128.0;
      buf[i+3]=(Sample)file_io_buffer[i+3]/128.0;
      buf[i+4]=(Sample)file_io_buffer[i+4]/128.0;
      buf[i+5]=(Sample)file_io_buffer[i+5]/128.0;
      buf[i+6]=(Sample)file_io_buffer[i+6]/128.0;
      buf[i+7]=(Sample)file_io_buffer[i+7]/128.0;
      buf[i+8]=(Sample)file_io_buffer[i+8]/128.0;
      buf[i+9]=(Sample)file_io_buffer[i+9]/128.0;
      buf[i+10]=(Sample)file_io_buffer[i+10]/128.0;
      buf[i+11]=(Sample)file_io_buffer[i+11]/128.0;
      buf[i+12]=(Sample)file_io_buffer[i+12]/128.0;
      buf[i+13]=(Sample)file_io_buffer[i+13]/128.0;
      buf[i+14]=(Sample)file_io_buffer[i+14]/128.0;
      buf[i+15]=(Sample)file_io_buffer[i+15]/128.0;
   }
   for(i=read_len&~15;i<read_len;i++){
      buf[i]=(Sample)file_io_buffer[i]/128.0;
   }
#endif
   fs_carrier.pos+=read_len;
   
   return read_len;
}


// file_output_sample /*fold00*/
int file_output_sample(Sample *buf_left,Sample *buf_right,int len){
   int i;
   int write_len;
   Sample x;

   len=len<FILE_IO_BUFFER_SIZE?len:FILE_IO_BUFFER_SIZE;
   
#ifndef FAST_CONVERT_LOOPS
   for(i=0;i<len;i++){
      x=buf_left[i]+buf_right[i];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i]=(char)(x*127.0);
   }
#else
   for(i=0;i<(len&~15);i+=16){
      x=buf_left[i]+buf_right[i];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i]=(char)(x*127.0);
      x=buf_left[i+1]+buf_right[i+1];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+1]=(char)(x*127.0);
      x=buf_left[i+2]+buf_right[i+2];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+2]=(char)(x*127.0);
      x=buf_left[i+3]+buf_right[i+3];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+3]=(char)(x*127.0);
      x=buf_left[i+4]+buf_right[i+4];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+4]=(char)(x*127.0);
      x=buf_left[i+5]+buf_right[i+5];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+5]=(char)(x*127.0);
      x=buf_left[i+6]+buf_right[i+6];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+6]=(char)(x*127.0);
      x=buf_left[i+7]+buf_right[i+7];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+7]=(char)(x*127.0);
      x=buf_left[i+8]+buf_right[i+8];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+8]=(char)(x*127.0);
      x=buf_left[i+9]+buf_right[i+9];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+9]=(char)(x*127.0);
      x=buf_left[i+10]+buf_right[i+10];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+10]=(char)(x*127.0);
      x=buf_left[i+11]+buf_right[i+11];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+11]=(char)(x*127.0);
      x=buf_left[i+12]+buf_right[i+12];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+12]=(char)(x*127.0);
      x=buf_left[i+13]+buf_right[i+13];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+13]=(char)(x*127.0);
      x=buf_left[i+14]+buf_right[i+14];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+14]=(char)(x*127.0);
      x=buf_left[i+15]+buf_right[i+15];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i+15]=(char)(x*127.0);
   }

   for(i=len&~15;i<len;i++){
      x=buf_left[i]+buf_right[i];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      file_io_buffer[i]=(char)(x*127.0);
   }
#endif

   write_len=write(fs_output.fd,file_io_buffer,sizeof(file_io_buffer[0])*len);
   if(write_len==-1) return ERR_SYSTEM;
   return write_len;
}

// file_restore_formant /*fold00*/
int file_restore_formant(){
   if(fs_formant.fd){
      close(fs_formant.fd);
   }
   return 0;
}

// file_restore_carrier /*fold00*/
int file_restore_carrier(){
   if(fs_carrier.fd){
      close(fs_carrier.fd);
   }
   return 0;
}

// file_restore_output /*fold00*/
int file_restore_output(){
   if(fs_output.fd){
      close(fs_output.fd);
   }
   return 0;
}


//  *** LINUX section    end  *** /*fold00*/
//  *** WIN32 section   start *** /*fold00*/
#else

// file_init_formant /*fold00*/
int file_init_formant(){
   memset(&fs_formant,0,sizeof(fs_formant));
   fs_formant.fd=_open(TESTSAMPLE_FORMANT,_O_RDONLY|_O_BINARY);
   if(!fs_formant.fd){
      ERR_PRINTF("can't open file"TESTSAMPLE_FORMANT": \n");
      return ERR_SYSTEM;
   }
   
   return 0;
}

// file_init_carrier /*fold00*/
int file_init_carrier(){
   memset(&fs_carrier,0,sizeof(fs_carrier));
   fs_carrier.fd=_open(TESTSAMPLE_CARRIER,O_RDONLY|_O_BINARY);
   if(!fs_carrier.fd){
      ERR_PRINTF("can't open file"TESTSAMPLE_CARRIER": \n");
      return ERR_SYSTEM;
   }
   
   return 0;
}

// file_init_output /*fold00*/
int file_init_output(){
   memset(&fs_output,0,sizeof(fs_output));
   fs_output.fd=_open(TESTSAMPLE_OUTPUT,O_WRONLY|O_CREAT, _S_IREAD | _S_IWRITE);
   if(!fs_output.fd){
      ERR_PRINTF("can't open file"TESTSAMPLE_OUTPUT": \n");
      return ERR_SYSTEM;
   }
   
   return 0;
}


// file_read_formant /*fold00*/
int file_read_formant(Sample *buf,int len){
   int read_len;
   int i;
   
   len=len<FILE_IO_BUFFER_SIZE?len:FILE_IO_BUFFER_SIZE;

   read_len=_read(fs_formant.fd,file_io_buffer,sizeof(file_io_buffer[0])*len);
   read_len/=sizeof(file_io_buffer[0]);

   if(read_len==0){
      // return ERR_NODATA;
      return ERR_EOF;
   }else if(read_len==-1){
      return ERR_SYSTEM;
   }
   
   for(i=0;i<read_len;i++){
#if 1
      buf[i]=(Sample)(file_io_buffer[i]/128.0);
#else
      buf[i]=sin(2.0*PI*50/24653*((Sample)i+fs_formant.pos));
#endif
   }
   fs_formant.pos+=read_len;
   
   return read_len;
}


// file_read_carrier /*fold00*/
int file_read_carrier(Sample *buf,int len){
   int read_len;
   int i;
   
   len=len<FILE_IO_BUFFER_SIZE?len:FILE_IO_BUFFER_SIZE;

   read_len=_read(fs_carrier.fd,file_io_buffer,sizeof(file_io_buffer[0])*len);
   read_len/=sizeof(file_io_buffer[0]);
   
   if(read_len==0){
      // Loop, if possible!
      lseek(fs_carrier.fd,0,SEEK_SET);
      read_len=_read(fs_carrier.fd,file_io_buffer,sizeof(file_io_buffer[0])*len);
      read_len/=sizeof(file_io_buffer[0]);
      if(read_len==0) return ERR_EOF;
   }else if(read_len==-1){
      return ERR_SYSTEM;
   }
   
   for(i=0;i<read_len;i++){
#if 1
      buf[i]=(Sample)(file_io_buffer[i]/128.0);
#else
      int j;
#define ANZ 32
      buf[i]=0;
      for(j=0;j<ANZ;j++){
         buf[i]+=sin(2.0*PI*
                     (Sample)SAMPLERATE*(Sample)(j+1.0)/(Sample)ANZ*
                     ((Sample)i+fs_carrier.pos)/24653.0)/ANZ;
      }
#endif
   }
   fs_carrier.pos+=read_len;
   
   return read_len;
}


// file_output_sample /*fold00*/
int file_output_sample(Sample *buf_left,Sample *buf_right,int len){
   int i;
   int write_len;
   Sample x;

   len=len<FILE_IO_BUFFER_SIZE?len:FILE_IO_BUFFER_SIZE;
   
   for(i=0;i<len;i++){
      x=buf_left[i]+buf_right[i];
      if(x<-1.0) x=-1.0;
      if(x>1.0) x=1.0;
      
      file_io_buffer[i]=(char)(x*127.0);
   }

   write_len=_write(fs_output.fd,file_io_buffer,sizeof(file_io_buffer[0])*len);
   if(write_len==-1) return ERR_SYSTEM;
   return write_len;
}

// file_restore_formant /*fold00*/
int file_restore_formant(){
   if(fs_formant.fd){
      close(fs_formant.fd);
   }
   return 0;
}

// file_restore_carrier /*fold00*/
int file_restore_carrier(){
   if(fs_carrier.fd){
      close(fs_carrier.fd);
   }
   return 0;
}

// file_restore_output /*fold00*/
int file_restore_output(){
   if(fs_output.fd){
      close(fs_output.fd);
   }
   return 0;
}


//  *** WIN32 section    end  *** /*fold00*/
#endif





