/*
 Vocoder               SCY/.tSCc.
   26.02.99
*/


// Includes /*fold00*/
#ifndef __IO_H__
#define __IO_H__
#include "common.h"

// Defines /*fold00*/
enum flag_io{
   FLAG_IO_SOUNDCARD,
   FLAG_IO_FILE
};

// Globals /*fold00*/
extern char *filename_output,*filename_carrier,*filename_formant;
extern enum flag_io flag_output,flag_carrier,flag_formant;

// prototypes /*fold00*/
int init_formant();
int init_carrier();
int init_output();

int read_formant(Sample *buf,int len);
int read_carrier(Sample *buf,int len);
int output_sample(Sample *buf_left,Sample *buf_right,int len);

int restore_formant();
int restore_carrier();
int restore_output();

int sound_start();
int sound_pause();
int sound_stop();

void io_pause();

// usage /*fold00*/
/*
 read_formant, read_carrier:

   It returns the amount of read samples or a negative value upon failure.
   
   The read is non-blocking. This means, if no data is available, 0 is
   returned.

  sam_output_sample:
   len is the amount of samples stored in each of the two buffers.

   It returns the amount of read samples or a negative value upon failure.

   The output is non-blocking. This means, if no data could be written, 0 is
   returned.
*/

#endif
