/*
 Vocoder               SCY/.tSCc.
   26.02.99

   Mainroutine
*/

// Includes /*fold00*/
#include "common.h"
#include "vocoder.h"
#include "io.h"
#ifdef USEGTK
#include "wind_common.h"
#include "wind_main.h"
#endif
extern int errno;

// Globals /*fold00*/
int bufferlen;
Sample *buf_formant=NULL;
Sample *buf_carrier=NULL;
Sample *buf_output_left=NULL;
Sample *buf_output_right=NULL;
enum soundmode_t soundmode=SOUND_OFF;

static int mainloop_timeout_tag=-1;
static int mainloop_idle=-1;
static int gui=1;

// cleanup /*fold00*/
void cleanup(){
#ifdef USEGTK
   if(mainloop_timeout_tag>=0)
      gtk_timeout_remove(mainloop_timeout_tag);
   if(mainloop_idle>=0)
      gtk_idle_remove(mainloop_idle);
#endif
   sound_stop();
   vocoder_restore();

   if(buf_formant) free(buf_formant);
   if(buf_carrier) free(buf_carrier);
   if(buf_output_left) free(buf_output_left);
   if(buf_output_right) free(buf_output_right);
}


// init /*fold00*/
int init(){
   // allocate buffers
   bufferlen=1024;

   buf_formant=(Sample *)malloc(bufferlen*sizeof(Sample));
   if(!buf_formant){
      ERR_PRINTF("couldn't allocate buffer for formant\n");
      return 1;
   }
   buf_carrier=(Sample *)malloc(bufferlen*sizeof(Sample));
   if(!buf_carrier){
      ERR_PRINTF("couldn't allocate buffer for carrier\n");
      return 1;
   }

   buf_output_left=(Sample *)malloc(bufferlen*sizeof(Sample));
   if(!buf_output_left){
      ERR_PRINTF("couldn't allocate buffer for left output\n");
      return 1;
   }
   buf_output_right=(Sample *)malloc(bufferlen*sizeof(Sample));
   if(!buf_output_right){
      ERR_PRINTF("couldn't allocate buffer for right output\n");
      return 1;
   }

   memset(buf_formant,0,bufferlen*sizeof(Sample));
   memset(buf_carrier,0,bufferlen*sizeof(Sample));
   memset(buf_output_left,0,bufferlen*sizeof(Sample));
   memset(buf_output_right,0,bufferlen*sizeof(Sample));
   
   return 0;
}

// main_process_buffers /*FOLD00*/
// <0: error
//  0: nothing to do
//  1: ok
//  2: off/pause
//  3: len_formant!=len_carrier

int main_process_buffers(){
   int len_formant,len_carrier,len_output;
   int len;
   int flag;

   if(soundmode==SOUND_OFF){
      return 2;
   }else if(soundmode==SOUND_PAUSE){
      io_pause();
      return 2;
   }

   flag=1;
   while(flag){
      len_formant=read_formant(buf_formant,bufferlen);
      if(len_formant<=0) return len_formant;
      len_carrier=read_carrier(buf_carrier,len_formant);
      if(len_carrier<=0) return len_carrier;

      len=len_carrier;
      vocoder(buf_formant,buf_carrier,buf_output_left,buf_output_right,len);

      while(len>0){
         len_output=output_sample(buf_output_left,buf_output_right,len);
         if(len_output<0) return len_output;
         len-=len_output;
         if(len>0) flag=0;
      }

      if(len_formant!=len_carrier){
         WARN_PRINTF("len_formant (%i) !=len_carrier (%i)\n",len_formant,len_carrier);
         return 3;
      }
   }
   return 1;
}


// mainloop_timeout_callback /*fold00*/
#ifdef USEGTK
gint mainloop_timeout_callback(){
   int errcode;
   int flag=0;

   if(mainloop_timeout_tag>=0){
      gtk_timeout_remove(mainloop_timeout_tag);
      mainloop_timeout_tag=-1;
   }

   errcode=main_process_buffers();

   if(errcode<0) flag=1;     // error
   if(errcode==3) flag=1;    // EOF encountered
   // if(errcode==0);        // idle (nothing to do)
   // if(errcode==2);        // idle (pause/off)

   if(window_counter==0) flag=1;

   if(flag){
      gtk_main_quit();
      return FALSE;
   }

#if 0
   return TRUE;
#else
   mainloop_timeout_tag=gtk_timeout_add(30,mainloop_timeout_callback,NULL);
   return FALSE;
#endif
}
#endif

// mainloop_idle_callback /*fold00*/
#ifdef USEGTK
void mainloop_idle_callback(){
   int errcode;
   int flag=0;

   errcode=main_process_buffers();
   if(errcode<0) flag=1;     // error
   if(errcode==3) flag=1;    // EOF encountered
   //   if(errcode==0);           // idle (nothing to do)
   //   if(errcode==2);           // idle (pause/off)

   if(window_counter==0) flag=1;

   if(flag){
      gtk_main_quit();
      return;
   }
}
#endif

// mainloop /*fold00*/
int mainloop(){
   int errcode;
#ifdef USEGTK
   if(gui){
      mainloop_timeout_tag=gtk_timeout_add(20,mainloop_timeout_callback,NULL);
//      mainloop_idle=gtk_idle_add((GtkFunction)mainloop_idle_callback,NULL);
      gtk_main();
      return 0;
   }
#endif
   while(1){
      errcode=main_process_buffers();
      if(errcode<0) return errcode;  // error
      if(errcode==2) break;          // EOF encountered
      // if(errcode==1);               // idle
   }
   return 0;

}

// usage /*fold00*/
void usage(){
   printf("usage: vocoder [options] [outfile]\n");
   printf("  available options are: \n");
   printf(" -n, --numbands <band>  set number of bands\n");
   printf(" -v, --version          print version and exit\n");
   printf("     --nogui            run in batch mode (needs outfile argument)\n");
}


// process_cmdline /*fold00*/
int process_cmdline(int argc,char **argv){
   int i;
   char tmp[300];
   struct {
      char shortname;
      char longname[30];
   }options_table[]={
      {'n',"--numbands"},
      {'h',"--help"},
      {'v',"--version"}
   };


   for(i=1;i<argc;i++){
      strncpy(tmp,argv[i],sizeof(tmp)-0);
      if(tmp[0]=='-' && tmp[1]!='-'){
         if(strlen(tmp)!=2){
            fprintf(stderr,"unknown option %s\n",argv[i]);
            return ERR_CMDLINE;
         }
         for(i=0;i<(int)(sizeof(options_table)/sizeof(options_table[0]));i++){
            if(options_table[i].shortname==tmp[1]){
               strcat(tmp,options_table[i].longname);
               break;
            }
         }
      }

      if((strcmp(tmp,"--numbands"))==0){
         if(++i<argc){
            num_bands=atoi(argv[i]);
         }
         if(num_bands<1 || num_bands>MAXBANDS){
            fprintf(stderr,"missing or wrong -n argument\n");
            return ERR_CMDLINE;
         }
      }else if((strcmp(tmp,"--help"))==0){
         usage();
         exit(0);
      }else if((strcmp(tmp,"--version"))==0){
         printf("Vocoder v"VERSION" ("VERSIONDATE")\n");
         printf("  coded by Settel <uno4@rz.uni-karlsruhe.de>\n");
         printf("  see also http://www.uni-karlsruhe.de/~uno4/linux/\n");
         exit(0);
      }else if((strcmp(tmp,"--nogui"))==0){
         gui=0;
      }else if(tmp[0]=='-'){
         fprintf(stderr,"unknown option %s\n",argv[i]);
         return ERR_CMDLINE;
      }else{
         if(flag_output==FLAG_IO_FILE){
            fprintf(stderr,"error in command line: double outfile argument\n");
            return ERR_CMDLINE;
         }else{
            filename_output=argv[i];
            flag_output=FLAG_IO_FILE;
         }
      }
   }
   return 0;
}

// main /*fold00*/
int main(int argc,char **argv){
   int errcode=0;


#ifdef USEGTK
   gtk_init(&argc,&argv);
#endif

   if((errcode=process_cmdline(argc,argv))) goto err_exit;

   if((errcode=init())) goto err_exit;
   if((errcode=vocoder_init())) goto err_exit;
   if(flag_output==FLAG_IO_FILE){
      int i;
      i=sound_start();
   }

#ifdef USEGTK
   if(gui) wind_main_init();
#endif
   mainloop();
   
err_exit:
   cleanup();
   return errcode;
}

