/*
 Vocoder               SCY/.tSCc.
   26.02.99
*/


// Includes /*fold00*/
#ifndef __SAMPLEIO_H__
#define __SAMPLEIO_H__
#include "common.h"

// Defines /*fold00*/
#ifdef LINUX
   #define SOUNDDEVICE "/dev/dsp"
#endif


// prototypes /*fold00*/
int sam_init_formant();
int sam_init_carrier();
int sam_init_output();

int sam_read_formant(Sample *buf,int len);
int sam_read_carrier(Sample *buf,int len);
int sam_output_sample(Sample *buf_left,Sample *buf_right,int len);

int sam_restore_formant();
int sam_restore_carrier();
int sam_restore_output();

void sam_read_pause();
void sam_write_pause();

int sam_can_duplex();

// usage /*fold00*/
/*
 sam_read_formant, sam_read_carrier:
   Read formant/carrier from sounddevice.
   It needs a pointer to previously allocated the buffer (which can
   hold len Samples) to which the data should be written.
   It returns the amount of read samples or a negative value upon failure.
   
   The read is non-blocking. This means, if no data is available, 0 is
   returned.

  sam_output_sample:
   write stereosample to sounddevice.
   len is the amount of samples stored in each of the two buffers.

   It returns the amount of read samples or a negative value upon failure.

   The output is non-blocking. This means, if no data could be written, 0 is
   returned.
*/

#endif /*FOLD00*/
