/*
 Vocoder               SCY/.tSCc.
   26.02.99

   Vocoder
*/

// Includes /*fold00*/
#include <math.h>
#include "common.h"
#include "vocoder.h"

// Globals /*fold00*/
#define AMPLIFIER 16.0

int num_bands=MAXBANDS;
float mainvol=1.0*AMPLIFIER;

struct bandpass bands_formant[MAXBANDS];
struct bandpass bands_carrier[MAXBANDS];
struct bands_out bands_out[MAXBANDS];

const Sample decay_table[]={
   1/100.0,
   1/100.0,1/100.0,1/100.0,
   1/125.0,1/125.0,1/125.0,
   1/166.0,1/166.0,1/166.0,
   1/200.0,1/200.0,1/200.0,
   1/250.0,1/250.0,1/250.0
};


// vocoder_do_bandpasses /*fold00*/
void vocoder_do_bandpasses(struct bandpass *bands,Sample sample){
   int i;
   for(i=0;i<num_bands;i++){
      bands[i].high1=sample-bands[i].f*bands[i].mid1-bands[i].low1;
      bands[i].mid1+=bands[i].high1*bands[i].c;
      bands[i].low1+=bands[i].mid1;

      bands[i].high2=bands[i].low1-bands[i].f*bands[i].mid2-bands[i].low2;
      bands[i].mid2+=bands[i].high2*bands[i].c;
      bands[i].low2+=bands[i].mid2;
      bands[i].y=bands[i].high2*bands[i].att;
   }
}


// vocoder /*fold00*/
void vocoder(Sample *formant,Sample *carrier,
             Sample *out_left,Sample *out_right,
             int len){
   int i,j;
   Sample x;

   for(i=0;i<len;i++){
      vocoder_do_bandpasses(bands_carrier,carrier[i]);
      vocoder_do_bandpasses(bands_formant,formant[i]);

#if 1
      out_left[i]=out_right[i]=0.0;
      for(j=0;j<num_bands;j+=1){
         bands_out[j].oldval=bands_out[j].oldval+(fabs(bands_formant[j].y)-bands_out[j].oldval)*bands_out[j].decay;
         x=bands_carrier[j].y*bands_out[j].oldval;
         out_left[i]+=x*bands_out[j].left_val;
         out_right[i]+=x*bands_out[j].right_val;
      }
      out_left[i]*=mainvol;
      out_right[i]*=mainvol;
#else
      out_left[i]=out_right[i]=formant[i];
#endif
   }
}

// vocoder_init /*fold00*/
int vocoder_init(){
   int i;
   float a;
   Sample c;
   
   for(i=0;i<num_bands;i++){
      memset(&bands_formant[i],0,sizeof(bands_formant[i]));

      a=16.0*i/(double)num_bands;  // stretch existing bands
      //      bands_formant[i].freq=300*pow(1.23,a);
      if(a<4.0){
         bands_formant[i].freq=150+420*a/4.0;
      }else{
         bands_formant[i].freq=600*pow(1.23,a-4.0);
      }
      c=bands_formant[i].freq*2*M_PI/44100.0;
      bands_formant[i].c=c*c;
#if 0
      bands_formant[i].f=0.2/c;
      bands_formant[i].att=1/(25.0+((exp(bands_formant[i].freq/44100.0)-1)*30));
#else
      bands_formant[i].f=0.4/c;
      bands_formant[i].att=1/(6.0+((exp(bands_formant[i].freq/44100.0)-1)*10));
#endif
      
      memcpy(&bands_carrier[i],&bands_formant[i],sizeof(bands_formant[i]));

      
      bands_out[i].decay=decay_table[(int)a];
      bands_out[i].oldval=0.0;

      vocoder_set_band(i,1.0,0.0);
   }
   
   return 0;
}

// vocoder_restore /*fold00*/
int vocoder_restore(){
   return 0;
}

// vocoder_set_band /*fold00*/
void vocoder_set_band(int band,float vol,float pan){
   float l,r;

   l=r=1.0;
   if(pan<0.0){
      r=1.0+pan;
   }else if(pan>0.0){
      l=1.0-pan;
   }
   bands_out[band].pan=pan;
   bands_out[band].left_val=vol*l;
   bands_out[band].right_val=vol*r;
}

// vocoder_get_band_freq /*fold00*/
Sample vocoder_get_band_freq(int band){
   return bands_formant[band].freq;
}

// vocoder_get_band_vol /*fold00*/
float vocoder_get_band_vol(int band){
   float l,r;

   l=bands_out[band].left_val;
   r=bands_out[band].right_val;
   return (l>r?l:r);
}

// vocoder_get_band_pan /*fold00*/
float vocoder_get_band_pan(int band){
   return bands_out[band].pan;
}

// vocoder_set_mainvol /*fold00*/
void vocoder_set_mainvol(float vol){
   mainvol=vol*AMPLIFIER;
}

// vocoder_get_mainvol /*fold00*/
float vocoder_get_mainvol(){
   return mainvol/AMPLIFIER;
}
