/*
 Vocoder               SCY/.tSCc.
   01.03.99
*/


// Includes /*fold00*/
#ifndef __VOCODER_H__
#define __VOCODER_H__
#include "common.h"

// Defines /*fold00*/
#ifndef MAXBANDS
#define MAXBANDS 16
#endif

// Globals /*fold00*/
extern int num_bands;

// structures /*fold00*/
struct bandpass{
   Sample c,f,att;

   Sample freq;
   Sample low1,low2;
   Sample mid1,mid2;
   Sample high1,high2;
   Sample y;
};

struct bands_out{
   Sample decay;
   Sample oldval;
   Sample left_val,right_val;
   float pan;
};


// prototypes /*fold00*/
int vocoder_init();
void vocoder(Sample *formant,Sample *carrier,
             Sample *out_left,Sample *out_right,
             int len);
int vocoder_restore();
void vocoder_set_band(int band,float vol,float pan);
Sample vocoder_get_band_freq(int band);
float vocoder_get_band_vol(int band);
float vocoder_get_band_pan(int band);
void vocoder_set_mainvol(float vol);
float vocoder_get_mainvol();


// usage /*fold00*/
/*
*/

#endif
