/*
 Vocoder               SCY/.tSCc.
   26.02.99
*/


// Includes /*fold00*/
#ifndef __FILEIO_H__
#define __FILEIO_H__
#include "common.h"

// Defines /*fold00*/
#define TESTSAMPLE_FORMANT "formant.raw"
#define TESTSAMPLE_CARRIER "carrier.raw"
// #define TESTSAMPLE_OUTPUT  "out.raw"


// prototypes /*fold00*/
int file_init_formant();
int file_init_carrier();
int file_init_output();

int file_read_formant(Sample *buf,int len);
int file_read_carrier(Sample *buf,int len);
int file_output_sample(Sample *buf_left,Sample *buf_right,int len);

int file_restore_formant();
int file_restore_carrier();
int file_restore_output();


// usage /*fold00*/
/*
 file_read_formant, file_read_carrier:
   It needs a pointer to previously allocated the buffer (which can
   hold len Samples) to which the data should be written.
   It returns the amount of read samples or a negative value upon failure.
   
   The read is non-blocking. This means, if no data is available, 0 is
   returned.

  file_output_sample:
   write stereosample to sounddevice.
   len is the amount of samples stored in each of the two buffers.

   It returns the amount of read samples or a negative value upon failure.

   The output is non-blocking. This means, if no data could be written, 0 is
   returned.
*/

#endif
