/*
 Vocoder               SCY/.tSCc.
   26.02.99

   General I/O
*/

// Includes /*fold00*/
#include "common.h"
#include "io.h"
#include "sampleio.h"
#include "fileio.h"

// Globals /*fold00*/
char *filename_output="out.raw";
char *filename_carrier="carrier.raw";
char *filename_formant="formant.raw";
enum flag_io flag_output=FLAG_IO_SOUNDCARD;
enum flag_io flag_formant=FLAG_IO_FILE;
enum flag_io flag_carrier=FLAG_IO_FILE;

// Defines /*fold00*/

// sound_start /*fold00*/
int sound_start(){
   int ret;
   if(soundmode==SOUND_PLAY) return -1;
   if(soundmode==SOUND_OFF){
      ret=init_formant();
      if(ret) return ret;
      ret=init_carrier();
      if(ret){
         restore_formant();
         return ret;
      }
      ret=init_output();
      if(ret){
         restore_formant();
         restore_carrier();
         return ret;
      }
   }
   soundmode=SOUND_PLAY;
   return 0;
}

// sound_pause /*fold00*/
int sound_pause(){
   int ret;

   if(soundmode==SOUND_PAUSE) return -1;
   if(soundmode==SOUND_OFF){
      ret=init_formant();
      if(ret) return ret;
      ret=init_carrier();
      if(ret){
         restore_formant();
         return ret;
      }
      ret=init_output();
      if(ret){
         restore_formant();
         restore_carrier();
         return ret;
      }
   }
   soundmode=SOUND_PAUSE;
   return 0;
}

// sound_stop /*fold00*/
int sound_stop(){
   if(soundmode==SOUND_OFF) return -1;
   restore_formant();
   restore_carrier();
   restore_output();
   soundmode=SOUND_OFF;
   return 0;
}

// io_pause /*fold00*/
void io_pause(){
#if 0
   // @@@ really need that?
   if(flag_output==FLAG_IO_FILE){
      sam_read_pause();
   }
   if(flag_carrier!=FLAG_IO_FILE || flag_formant!=FLAG_IO_FILE){
      sam_write_pause();
   }
#endif
}

// init_formant /*fold00*/
int init_formant(){
   if(flag_formant==FLAG_IO_FILE){
      return file_init_formant();
   }else{
      return sam_init_formant();
   }
}

// init_carrier /*fold00*/
int init_carrier(){
   if(flag_carrier==FLAG_IO_FILE){
      return file_init_carrier();
   }else{
      return sam_init_carrier();
   }
}

// init_output /*fold00*/
int init_output(){
#ifdef LINUX
   if(flag_output==FLAG_IO_FILE){
      return file_init_output();
   }else{
      return sam_init_output();
   }
#else
   return file_init_output();
#endif
}


// read_formant /*fold00*/
int read_formant(Sample *buf,int len){
   if(flag_formant==FLAG_IO_FILE){
      return file_read_formant(buf,len);
   }else{
      return sam_read_formant(buf,len);
   }
}


// read_carrier /*fold00*/
int read_carrier(Sample *buf,int len){
   if(flag_carrier==FLAG_IO_FILE){
      return file_read_carrier(buf,len);
   }else{
      return sam_read_carrier(buf,len);
   }
}


// output_sample /*fold00*/
int output_sample(Sample *buf_left,Sample *buf_right,int len){
#ifdef LINUX
   if(flag_output==FLAG_IO_FILE){
      return file_output_sample(buf_left,buf_right,len);
   }else{
      return sam_output_sample(buf_left,buf_right,len);
   }
#else
   return file_output_sample(buf_left,buf_right,len);
#endif
}

// restore_formant /*fold00*/
int restore_formant(){
   if(flag_formant==FLAG_IO_FILE){
      return file_restore_formant();
   }else{
      return sam_restore_formant();
   }
}

// restore_carrier /*fold00*/
int restore_carrier(){
   if(flag_carrier==FLAG_IO_FILE){
      return file_restore_carrier();
   }else{
      return sam_restore_carrier();
   }
}

// restore_output /*fold00*/
int restore_output(){
#ifdef LINUX
   if(flag_output==FLAG_IO_FILE){
      return file_restore_output();
   }else{
      return sam_restore_output();
   }
#else
   return file_restore_output();
#endif
}

