/*
 Vocoder               SCY/.tSCc.
   26.02.99

   Sample I/O
*/
#undef SAFE_INIT

// Includes /*fold00*/
#include <fcntl.h>
#ifdef LINUX
#include <sys/ioctl.h>
#include <linux/soundcard.h>
#endif
#include "common.h"
#include "sampleio.h"

//  *** LINUX section   start *** /*fold00*/
#ifdef LINUX

// Globals /*fold00*/
static unsigned char outbuf[4096];
static unsigned char inbuf[4096];
static int inbuf_len=0;
static int sam_fd=-1;
static int usage_cnt=0;
static int stereo=1;
static int samplingfreq=44100;
static int nrbits=8;
static int sizepersample;
static int caps=0;
static int oss_version=0;
static int fragments=0x0002000C;

// *** get/set *** /*FOLD00*/
// sam_can_duplex /*fold00*/
int sam_can_duplex(){
   return caps&DSP_CAP_DUPLEX;
}

// *** init *** /*FOLD00*/
// sam_init_all_sub /*fold00*/
static int sam_init_all_sub(){
   sam_fd=open(SOUNDDEVICE,O_RDWR);
   if(sam_fd<0){
      ERR_PRINTF("can't open sounddevice "SOUNDDEVICE": %s\n",strerror(errno));
      return -1;
   }
#ifdef OSS_GETVERSION
   if(ioctl(sam_fd,OSS_GETVERSION,&oss_version)) WARN_PRINTF("OSS_GETVERSION: %s\n",strerror(errno));
#else
	oss_version=0;
#endif
   if(ioctl(sam_fd,SNDCTL_DSP_RESET)) WARN_PRINTF("DSP_RESET: %s\n",strerror(errno));
   if(ioctl(sam_fd,SNDCTL_DSP_SYNC)) WARN_PRINTF("DSP_SYNC: %s\n",strerror(errno));
   if(ioctl(sam_fd,SNDCTL_DSP_SETFRAGMENT,&fragments)) WARN_PRINTF("DSP_SETFRAGMENT: %s\n",strerror(errno));
   if(ioctl(sam_fd,SNDCTL_DSP_SAMPLESIZE,&nrbits)) WARN_PRINTF("DSP_SAMPLESIZE: %s\n",strerror(errno));
   if(ioctl(sam_fd,SNDCTL_DSP_STEREO,&stereo)) WARN_PRINTF("DSP_STEREO: %s\n",strerror(errno));
   if(nrbits!=8 && nrbits!=16){
      ERR_PRINTF("unknown number of bits per sample: %i\n",nrbits);
      return -2;
   }
   if(ioctl(sam_fd,SNDCTL_DSP_SPEED,&samplingfreq)) WARN_PRINTF("DSP_SPEED: %s\n",strerror(errno));

   if(ioctl(sam_fd,SNDCTL_DSP_GETCAPS,&caps)) WARN_PRINTF("DSP_GETCAPS: %s\n",strerror(errno));
   if(sam_can_duplex()){
      if(ioctl(sam_fd,SNDCTL_DSP_SETDUPLEX,0)) WARN_PRINTF("DSP_SETDUPLEX: %s\n",strerror(errno));
   }
   

   printf("%2.3fkHz, %i bit, %s, %s, %#08x (caps: %x)\n[OSS version %x]\n",
          samplingfreq/1000.0,nrbits,stereo?"stereo":"mono",
          caps&DSP_CAP_DUPLEX?"duplex":"simplex",
          fragments,caps,oss_version);

   sizepersample=1;
   if(stereo) sizepersample*=2;
   if(nrbits==16) sizepersample*=2;

   return 0;
}

// sam_init_all /*fold00*/
static int sam_init_all(){
   static int sam_restore_all();
   int ret;
#ifdef SAFE_INIT
   int loops;
#endif
   
   // @@@ DSP_CAP_DUPLEX
   if(usage_cnt!=0) return 0;
   usage_cnt++;

   ret=sam_init_all_sub();
   if(ret){
      usage_cnt--;
      return ret;
   }

#ifdef SAFE_INIT

   printf("initiate I/O\n");
   memset(outbuf,0,sizeof(outbuf));  // initiate I/O
   read(sam_fd,inbuf,sizeof(inbuf));
   write(sam_fd,outbuf,sizeof(outbuf));
   printf("ok\n");
   loops=0;
   while(loops<5){
      audio_buf_info info;
      int len;
      int cnt;

      cnt=0;
      while(1){
         ioctl(sam_fd,SNDCTL_DSP_GETISPACE,&info); // avoid blocking I/O
         if(info.fragments) break;
         usleep(25000);
         cnt++;
         if(cnt>10){
            int old_usage_cnt;
            
            printf("failure detected, retrying\n");
            old_usage_cnt=usage_cnt;
            usage_cnt=1;
            ret=sam_restore_all();
            if(ret) return ret;
            ret=sam_init_all_sub();
            if(ret) return ret;
            usage_cnt=old_usage_cnt;

            printf("initiate I/O\n");
            memset(outbuf,0,sizeof(outbuf));  // initiate I/O
            read(sam_fd,inbuf,sizeof(inbuf));
            write(sam_fd,outbuf,sizeof(outbuf));
            loops=0;
            cnt=0;
         }
      }
      len=read(sam_fd,inbuf,sizeof(inbuf));
      if(len<0) continue;
      len=write(sam_fd,outbuf,sizeof(outbuf));
      if(len<0) printf("error while write: %s\n",strerror(errno));

      loops++;
   }
   printf("init comleted successfully\n");
#endif

   return 0;
}

// sam_init_formant /*fold00*/
int sam_init_formant(){
   return sam_init_all();
}

// sam_init_carrier /*fold00*/
int sam_init_carrier(){
   return sam_init_all();
}

// sam_init_output /*fold00*/
int sam_init_output(){
   return sam_init_all();
}


// *** in/out *** /*FOLD00*/
// sam_read_all /*fold00*/
int sam_read_all(Sample *buf,int len,int flag){
   static int pos_formant=0;
   static int pos_carrier=0;
   audio_buf_info info;
   int pos;
   int i;
   int inbufpos;

   pos=flag?pos_carrier:pos_formant;
   
   if(pos>=inbuf_len){
      int len2;
      len2=sizeof(inbuf)/sizepersample;
      len=len<len2?len:len2;

      while(1){
         ioctl(sam_fd,SNDCTL_DSP_GETISPACE,&info); // avoid blocking I/O
         if(info.bytes==0){
            usleep(250000);
            continue;
         }
//         if(flag) printf("fragments: %i\n",info.fragments);
         if(info.bytes<len) len=info.bytes;
            break;
      }
      if(info.fragments>3){
         while(info.fragments>1){
            read(sam_fd,inbuf,len*sizepersample);
            ioctl(sam_fd,SNDCTL_DSP_GETISPACE,&info); // avoid blocking I/O
            printf("skipping fragment\n");
         }
      }

      inbuf_len=read(sam_fd,inbuf,len*sizepersample);
      if(inbuf_len<=0) return -1;
      inbuf_len/=sizepersample;
      pos=0;
      pos_carrier=pos_formant=0;
   }
   len=len<(inbuf_len-pos)?len:inbuf_len-pos;

   inbufpos=pos*sizepersample+flag;
   for(i=0;i<len;i++){
      buf[i]=(Sample)(inbuf[inbufpos]-127.0)/128.0;
      inbufpos+=sizepersample;
   }
   pos+=len;
   if(flag) pos_carrier=pos; else pos_formant=pos;
   
   return len;
}

// sam_read_formant /*fold00*/
inline int sam_read_formant(Sample *buf,int len){
   return sam_read_all(buf,len,0);
}


// sam_read_carrier /*fold00*/
inline int sam_read_carrier(Sample *buf,int len){
   return sam_read_all(buf,len,1);
}


// sam_output_sample /*fold00*/
int sam_output_sample(Sample *buf_left,Sample *buf_right,int len){
   audio_buf_info info;
   int ret,i;
   int c;
   int cnt,total;
   Sample x;

   cnt=0;
   total=0;
   ioctl(sam_fd,SNDCTL_DSP_GETOSPACE,&info); // avoid blocking I/O
   if(info.bytes<len) len=info.bytes;

   for(i=0;i<len;i++){
      if(stereo){
         x=buf_left[i];
         if(x<-1.0) x=-1.0;
         if(x>1.0) x=1.0;

         if(nrbits==8){
            outbuf[cnt++]=(unsigned char)(x*127.0+127.0);
         }else{
            c=(int)(x*32767.0);
            outbuf[cnt++]=(unsigned char)c&255;
            outbuf[cnt++]=(unsigned char)(c>>8);
         }

         x=buf_right[i];
         if(x<-1.0) x=-1.0;
         if(x>1.0) x=1.0;

         if(nrbits==8){
            outbuf[cnt++]=(unsigned char)(x*127.0+127.0);
         }else{
            c=(int)(x*32767.0);
            outbuf[cnt++]=(unsigned char)c&255;
            outbuf[cnt++]=(unsigned char)(c>>8);
         }
      }else{
         x=buf_left[i]+buf_right[i];
         if(x<-1.0) x=-1.0;
         if(x>1.0) x=1.0;

         if(nrbits==8){
            outbuf[cnt++]=(unsigned char)(x*127.0+127.0);
         }else{
            c=(int)(x*32767.0);
            outbuf[cnt++]=(unsigned char)c&255;
            outbuf[cnt++]=(unsigned char)(c>>8);
         }
      }

      if(cnt>=(signed int)sizeof(outbuf)){
         ret=write(sam_fd,outbuf,cnt);
         if(ret==-1){
            ERR_PRINTF("error writing outbuf: %s\n",strerror(errno));
            return -1;
         }
         total+=ret/sizepersample;
         if(cnt!=ret) return total; // write buffer full, returning
      }
   }


   if(cnt){  // flush
      ret=write(sam_fd,outbuf,cnt);
      if(ret==-1){
         ERR_PRINTF("error writing outbuf: %s\n",strerror(errno));
         return -1;
      }
      total+=ret/sizepersample;
   }
   return total;
}

// sam_read_pause /*fold00*/
void sam_read_pause(){
   printf("sam_read_pause(): read pause\n");
}

// sam_write_pause /*fold00*/
void sam_write_pause(){
   printf("write pause()\n");
}

// *** restore *** /*FOLD00*/
// sam_restore_all /*fold00*/
static int sam_restore_all(){
   int ret;
   
   usage_cnt--;
   if(usage_cnt!=0 || sam_fd==-1) return 0;
   ioctl(sam_fd,SNDCTL_DSP_SYNC,&ret);
   close(sam_fd);
   sam_fd=-1;
   return 0;
}


// sam_restore_formant /*fold00*/
int sam_restore_formant(){
   return sam_restore_all();
}
// sam_restore_carrier /*fold00*/
int sam_restore_carrier(){
   return sam_restore_all();
}
// sam_restore_output /*fold00*/
int sam_restore_output(){
   return sam_restore_all();
}

//  *** LINUX section    end  *** /*fold00*/
#endif


