/*
 Vocoder               SCY/.tSCc.
   12.03.99

   GUI: About dialog
*/

// Includes /*fold00*/
#include "wind_about.h"
#include "wind_common.h"

// Icons /*fold00*/
#include "imgs/vocoder.xpm"
#include "imgs/icon.xpm"

// Globals /*fold00*/
struct wind_about wind_about={};

static void wind_about_delete(GtkWidget *widget,GdkEvent *event,gpointer data);
static void wind_about_done();

// wind_about_close /*fold00*/
void wind_about_close(){
   struct wind_about *w=&wind_about;
   if(w->window==NULL) return;
   gtk_widget_destroy(w->window);
   w->window=NULL;
   window_counter--;
   if(window_counter==0) wind_cleanup();
}

// wind_about_init /*fold00*/
void wind_about_init(){
   struct wind_about *w=&wind_about;

   if(w->window) return;
   window_counter++;

   w->window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(GTK_WINDOW(w->window),"Vocoder // About");
   gtk_signal_connect(GTK_OBJECT(w->window),"delete_event",GTK_SIGNAL_FUNC(wind_about_delete),NULL);
   gtk_container_border_width(GTK_CONTAINER(w->window),10);
   gtk_widget_realize(w->window);
   wind_create_icon(w->window,icon_xpm);

   // Main VBox
   w->mainvbox=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(w->window),w->mainvbox);

   // Logo
   w->logo_pixmap=gdk_pixmap_create_from_xpm_d(w->window->window,
                                               &w->logo_mask,NULL,
                                               vocoder_xpm);
   w->logo=gtk_pixmap_new(w->logo_pixmap,w->logo_mask);
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->logo,FALSE,FALSE,5);


   // Version
   w->version_frame=gtk_frame_new("Version");
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->version_frame,TRUE,TRUE,5);

   w->version_label=gtk_label_new("v"VERSION" from "VERSIONDATE);
   gtk_container_add(GTK_CONTAINER(w->version_frame),w->version_label);
   gtk_container_border_width(GTK_CONTAINER(w->version_frame),5);

   // Author
   w->author_frame=gtk_frame_new("Author");
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->author_frame,TRUE,TRUE,5);

   w->author_label=gtk_label_new("Coded by Achim 'Settel' Settelmeier\n<uno4@rz.uni-karlsruhe.de>");
   gtk_container_add(GTK_CONTAINER(w->author_frame),w->author_label);
   gtk_container_border_width(GTK_CONTAINER(w->author_frame),5);


   // Button
   w->button_done=gtk_button_new_with_label("Done");
   gtk_signal_connect(GTK_OBJECT(w->button_done),"clicked",GTK_SIGNAL_FUNC(wind_about_done),NULL);
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->button_done,TRUE,TRUE,5);

   gtk_widget_show_all(w->window);
}
/***** Callbacks *****/ /*FOLD00*/
// wind_about_done /*fold00*/
void wind_about_done(){
   wind_about_close();
}

// wind_about_delete /*fold00*/
void wind_about_delete(GtkWidget *widget,GdkEvent *event,gpointer data){
   USE(widget);
   USE(event);
   USE(data);
   wind_about_close();
}

