/*
 Newsreader          coded by Settel (uno4@rz.uni-karlsruhe.de)
 common stuff
    16.11.98
*/


// Includes /*fold00*/
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include "wind_common.h"
#include "common.h"

// Defines /*fold00*/

// Globals /*fold00*/
int window_counter=0;

// wind_cleanup /*fold00*/
void wind_cleanup(){
//   wind_about_close();
//   wind_main_close();  // @@@
   window_counter=0;
//   gtk_main_quit();
}

// wind_create_icon /*fold00*/
void wind_create_icon(GtkWidget *window,gchar **icon_xpm){
   GtkStyle *style;
   GdkBitmap *icon_mask;
   GdkPixmap *icon_pixmap;

   style=gtk_widget_get_style(window);
   icon_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&icon_mask,
                                            &style->bg[GTK_STATE_NORMAL],
                                            icon_xpm);
   gdk_window_set_icon(window->window,NULL,icon_pixmap,icon_mask);

}

// wind_insert_buttons /*fold00*/
void wind_insert_buttons(GtkWidget *w,GtkWidget *toolbar,
                         struct wind_buttons_t *wb,int anz){
   int i;
   GtkStyle *style;
   GdkBitmap *mask;
   GdkPixmap *pixmap;
   GtkWidget *wpixmap;
   
   style=gtk_widget_get_style(w);
   for(i=0;i<anz;i++){
      pixmap=gdk_pixmap_create_from_xpm_d(w->window,&mask,
                                          &style->bg[GTK_STATE_NORMAL],
                                          wb[i].xpm);
      wpixmap=gtk_pixmap_new(pixmap,mask);
      wb[i].widget=gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
                                           wb[i].label,wb[i].description,
                                           wb[i].path,wpixmap,
                                           GTK_SIGNAL_FUNC(wb[i].func),
                                           toolbar);

   }
}

// wind_update /*fold00*/
void wind_update(){
   while(gtk_events_pending()){
      gtk_main_iteration();
   }
}

// wind_status /*fold00*/
void wind_status(GtkWidget *statusbar,gchar *text){
   gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
   if(text)
      gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,text);
   wind_update();
}

// wind_progress /*fold00*/
void wind_progress(GtkWidget *progressbar,gfloat percentage){
   gtk_progress_bar_update(GTK_PROGRESS_BAR(progressbar),percentage);
   wind_update();
}

// wind_alert /*fold00*/
void wind_alert_destroy(GtkWidget *widget,gpointer data){
   USE(widget);
   gtk_widget_destroy((GtkWidget *)data);
}

void wind_alert(char *headline,char *text,char *buttontext){
   GtkWidget *window,*button,*label;
   char tmpbuf[256];
   char *pos,*pos2;
   

   window=gtk_dialog_new();
   gtk_signal_connect(GTK_OBJECT(window),"destroy",
                      GTK_SIGNAL_FUNC(wind_alert_destroy),window);
   gtk_window_set_title(GTK_WINDOW(window),headline?headline:"Alert");

   button=gtk_button_new_with_label(buttontext);
   GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
                      button,TRUE,TRUE,0);
   gtk_widget_grab_default(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",
                      GTK_SIGNAL_FUNC(wind_alert_destroy),window);

   pos2=text;
   while((pos=strchr(pos2,'\n'))){
      strncpy(tmpbuf,pos2,pos-pos2);
      tmpbuf[pos-pos2]=0;
      label=gtk_label_new(tmpbuf);
      gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                         label,TRUE,TRUE,0);
      gtk_misc_set_padding(GTK_MISC(label),10,pos2==text?10:0);
      pos2=pos+1;
   }
   strncpy(tmpbuf,pos2,255);
   label=gtk_label_new(tmpbuf);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                      label,TRUE,TRUE,0);
   gtk_misc_set_padding(GTK_MISC(label),10,pos2==text?10:0);
   

   gtk_widget_show_all(window);
}

// str_errcode /*fold00*/
char *err_strings[]={
   "no data available",
   "system error",
   "unspecified error",
   "end of data",
   "command line error"
};
void str_errcode(char *str,int err){
   if(err==ERR_SYSTEM){
      strcpy(str,strerror(errno));
      return;
   }
   if(err>0){
      strcpy(str,"");
      return;
   }
   strcpy(str,err_strings[-err]);
}
