/*
 Vocoder               SCY/.tSCc.
   12.03.99

   GUI: Mainwindow
*/

// Includes /*fold00*/
#include "io.h"
#include "wind_main.h"
#include "wind_about.h"
#include "wind_setbands.h"
#include "wind_common.h"

// Icons /*fold00*/
#include "imgs/icon.xpm"
#include "imgs/vocoder.xpm"
#include "imgs/exit.xpm"
#include "imgs/start.xpm"
#include "imgs/pause.xpm"
#include "imgs/stop.xpm"
#include "imgs/mute.xpm"
#include "imgs/unmute.xpm"

// Globals /*fold00*/
struct wind_main wind_main={};
extern char *outfile;

static void wind_main_volume(GtkAdjustment *adj,gpointer data);

static void wind_main_band_volume(GtkAdjustment *adj,gpointer data);
static void wind_main_band_panning(GtkAdjustment *adj,gpointer data);

static void wind_main_delete(GtkWidget *widget,GdkEvent *event,gpointer data);
static void wind_main_button_exit();
static void wind_main_button_start();
static void wind_main_button_pause();
static void wind_main_button_stop();
static void wind_main_button_unmute();
static void wind_main_button_mute();

static void wind_main_formant_file_toggle();
static void wind_main_carrier_file_toggle();
static void wind_main_output_file_toggle();

static void wind_main_about();
static void wind_main_setbands();

// Menubar
//   path,accel,callback,callback_action(int),item_type
static GtkItemFactoryEntry main_menu_items[]={
   {"/_File",NULL,NULL,0,"<Branch>"},
   {"/File/_New","<control>N",NULL,0,NULL},
   {"/File/_Load","<control>O",NULL,0,NULL},
   {"/File/_Save","<control>S",NULL,0,NULL},
   {"/File/Save _As",NULL,NULL,0,NULL},
   {"/File/Sep1",NULL,NULL,0,"<Separator>"},
   {"/File/_Quit","<control>Q",NULL,0,NULL},
   {"/_Settings",NULL,NULL,0,"<Branch>"},
   {"/Settings/_Number of bands","F2",wind_main_setbands,0,NULL},
   {"/_Help",NULL,NULL,0,"<LastBranch>"},
   {"/Help/_About","F1",wind_main_about,0,NULL}
};

// Toolbar
#define BUTTONS_START 1
#define BUTTONS_PAUSE 2
#define BUTTONS_STOP  3
static struct wind_buttons_t wind_main_buttons[]={
   {"Exit","Exit program","Main/Exit",exit_xpm,wind_main_button_exit,NULL},
   {"Start","start vocoder","Main/Start",start_xpm,wind_main_button_start,NULL},
   {"Pause","pause vocoder","Main/Pause",pause_xpm,wind_main_button_pause,NULL},
   {"Stop","stop vocoder","Main/Stop",stop_xpm,wind_main_button_stop,NULL},
   {"Mute","mute all bands","Main/Mute",mute_xpm,wind_main_button_mute,NULL},
   {"Unmute","unmute all bands","Main/Unmute",unmute_xpm,wind_main_button_unmute,NULL}
};
static int wind_main_anzbuttons=sizeof(wind_main_buttons)/sizeof(wind_main_buttons[0]);



// wind_main_create_bands /*fold00*/
void wind_main_create_bands(struct wind_main *w){
   int i;

   if(w->bandbars_hbox){            // recreate it?
      gtk_widget_destroy(w->bandbars_hbox);
   }
   w->bandbars_hbox=gtk_hbox_new(TRUE,5);
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->bandbars_hbox,TRUE,TRUE,0);
   gtk_container_border_width(GTK_CONTAINER(w->bandbars_hbox),5);

   for(i=0;i<num_bands;i++){
      struct wind_main_bandbar *b=&w->bandbars[i];
      char tmp[20];
      int freq;

      b->band=i;
      // Freqlabel
      freq=(int)vocoder_get_band_freq(i);
      if(freq<1000){
         sprintf(tmp,"%i",freq);
      }else{
         sprintf(tmp,"%1ik%1i",freq/1000,(freq/100)%10);
      }
      b->frame=gtk_frame_new(tmp);
      gtk_box_pack_start(GTK_BOX(w->bandbars_hbox),b->frame,TRUE,TRUE,0);
      b->vbox=gtk_vbox_new(FALSE,5);
      gtk_container_add(GTK_CONTAINER(b->frame),b->vbox);

      // Volume
      b->volume_adjustment=gtk_adjustment_new(1.0-vocoder_get_band_vol(i),0.0,1.0,0.01,0.25,0.0);
      b->volume=gtk_vscale_new(GTK_ADJUSTMENT(b->volume_adjustment));
      gtk_signal_connect(GTK_OBJECT(b->volume_adjustment),"value_changed",
                         GTK_SIGNAL_FUNC(wind_main_band_volume),b);
      gtk_scale_set_draw_value(GTK_SCALE(b->volume),0);
      gtk_box_pack_start(GTK_BOX(b->vbox),b->volume,TRUE,TRUE,0);

      // Panning
      b->panning_adjustment=gtk_adjustment_new(vocoder_get_band_pan(i),-1.0,1.0,0.1,0.25,0.1);
#if 0
      b->panning=gtk_hscale_new(GTK_ADJUSTMENT(b->panning_adjustment));
      gtk_scale_set_draw_value(GTK_SCALE(b->panning),0);
#else
      b->panning=gtk_hscrollbar_new(GTK_ADJUSTMENT(b->panning_adjustment));
#endif
      gtk_signal_connect(GTK_OBJECT(b->panning_adjustment),"value_changed",
                         GTK_SIGNAL_FUNC(wind_main_band_panning),b);
      gtk_box_pack_start(GTK_BOX(b->vbox),b->panning,FALSE,FALSE,5);
   }
}

// wind_main_set_vol_pan /*fold00*/
void wind_main_set_vol_pan(struct wind_main_bandbar *b){
   gfloat v,p;

   v=GTK_ADJUSTMENT(b->volume_adjustment)->value;
   p=GTK_ADJUSTMENT(b->panning_adjustment)->value;
   vocoder_set_band(b->band,1.0-v,p);
}

// wind_main_init /*fold00*/
void wind_main_init(){
   struct wind_main *w=&wind_main;
   GtkWidget *alignment;
   
   window_counter++;
   w->window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(GTK_WINDOW(w->window),"Vocoder");
   gtk_signal_connect(GTK_OBJECT(w->window),"delete_event",GTK_SIGNAL_FUNC(wind_main_delete),NULL);
   gtk_widget_realize(w->window);
   wind_create_icon(w->window,icon_xpm);

   // Main VBox
   w->mainvbox=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(w->window),w->mainvbox);

   // Create Menu
   w->menu_items=main_menu_items;
   w->anz_menu_items=sizeof(main_menu_items)/sizeof(main_menu_items[0]);
   w->accel_group=gtk_accel_group_new();
   w->item_factory=gtk_item_factory_new(GTK_TYPE_MENU_BAR,"<Main>",w->accel_group);
   gtk_item_factory_create_items(w->item_factory,w->anz_menu_items,w->menu_items,NULL);
   gtk_accel_group_attach(w->accel_group,GTK_OBJECT(w->window));
   w->menubar=gtk_item_factory_get_widget(w->item_factory,"<Main>");
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->menubar,FALSE,TRUE,0);

   // Toolbar
   w->buttonhbox=gtk_hbox_new(FALSE,5);
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->buttonhbox,FALSE,FALSE,0);
   w->toolbar=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_BOTH);
#ifdef GTK_RELIEF_HALF
   // Gtk+ 1.2 feature?
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(w->toolbar),GTK_RELIEF_HALF);
#endif
   gtk_box_pack_start(GTK_BOX(w->buttonhbox),w->toolbar,FALSE,FALSE,0);
   wind_insert_buttons(w->window,w->toolbar,wind_main_buttons,wind_main_anzbuttons);
   gtk_widget_set_sensitive(wind_main_buttons[BUTTONS_STOP].widget,0); // deactivate the stop-button


   w->controls_hbox=gtk_hbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(w->controls_hbox),10);
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->controls_hbox,FALSE,FALSE,0);

   // Formant
   w->formant_frame=gtk_frame_new("Formant");
   gtk_box_pack_start(GTK_BOX(w->controls_hbox),w->formant_frame,FALSE,FALSE,0);
   // Formant::FileToggle
   w->formant_vbox=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(w->formant_frame),w->formant_vbox);
   w->formant_radio_soundcard=gtk_radio_button_new_with_label(NULL,"Soundcard");
   gtk_box_pack_start(GTK_BOX(w->formant_vbox),w->formant_radio_soundcard,FALSE,FALSE,0);
   gtk_signal_connect(GTK_OBJECT(w->formant_radio_soundcard),"toggled",
                      GTK_SIGNAL_FUNC(wind_main_formant_file_toggle),NULL);
   w->formant_radio_file=gtk_radio_button_new_with_label_from_widget(
                         GTK_RADIO_BUTTON(w->formant_radio_soundcard),"File");
   gtk_box_pack_start(GTK_BOX(w->formant_vbox),w->formant_radio_file,FALSE,FALSE,0);
   w->formant_file_entry=gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(w->formant_vbox),w->formant_file_entry,FALSE,FALSE,0);
   if(flag_formant==FLAG_IO_FILE){
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w->formant_radio_file),1);
      gtk_widget_set_sensitive(w->formant_file_entry,1);
   }else{
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w->formant_radio_soundcard),1);
      gtk_widget_set_sensitive(w->formant_file_entry,0);
   }
   if(filename_formant) gtk_entry_set_text(GTK_ENTRY(w->formant_file_entry),filename_formant);

   // Carrier
   w->carrier_frame=gtk_frame_new("Carrier");
   gtk_box_pack_start(GTK_BOX(w->controls_hbox),w->carrier_frame,FALSE,FALSE,0);
   // Carrier::FileToggle
   w->carrier_vbox=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(w->carrier_frame),w->carrier_vbox);
   w->carrier_radio_soundcard=gtk_radio_button_new_with_label(NULL,"Soundcard");
   gtk_box_pack_start(GTK_BOX(w->carrier_vbox),w->carrier_radio_soundcard,FALSE,FALSE,0);
   gtk_signal_connect(GTK_OBJECT(w->carrier_radio_soundcard),"toggled",
                      GTK_SIGNAL_FUNC(wind_main_carrier_file_toggle),NULL);
   w->carrier_radio_file=gtk_radio_button_new_with_label_from_widget(
                         GTK_RADIO_BUTTON(w->carrier_radio_soundcard),"File");
   gtk_box_pack_start(GTK_BOX(w->carrier_vbox),w->carrier_radio_file,FALSE,FALSE,0);
   w->carrier_file_entry=gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(w->carrier_vbox),w->carrier_file_entry,FALSE,FALSE,0);
   if(flag_carrier==FLAG_IO_FILE){
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w->carrier_radio_file),1);
      gtk_widget_set_sensitive(w->carrier_file_entry,1);
   }else{
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w->carrier_radio_soundcard),1);
      gtk_widget_set_sensitive(w->carrier_file_entry,0);
   }
   if(filename_carrier) gtk_entry_set_text(GTK_ENTRY(w->carrier_file_entry),filename_carrier);

   // Output
   w->output_frame=gtk_frame_new("Output");
   gtk_box_pack_start(GTK_BOX(w->controls_hbox),w->output_frame,FALSE,FALSE,0);
   gtk_container_set_border_width(GTK_CONTAINER(w->output_frame),0);
   w->output_hbox=gtk_hbox_new(FALSE,5);
   gtk_container_add(GTK_CONTAINER(w->output_frame),w->output_hbox);

   // Output::Mainvolume
   w->mainvol_adj=gtk_adjustment_new(0.0,0.0,1.0,0.01,0.25,0.0);
   w->mainvol=gtk_vscale_new(GTK_ADJUSTMENT(w->mainvol_adj));
   gtk_signal_connect(GTK_OBJECT(w->mainvol_adj),"value_changed",
                      GTK_SIGNAL_FUNC(wind_main_volume),NULL);
   gtk_scale_set_draw_value(GTK_SCALE(w->mainvol),0);
   gtk_box_pack_start(GTK_BOX(w->output_hbox),w->mainvol,FALSE,FALSE,0);

   // Output::FileToggle
   w->output_vbox=gtk_vbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(w->output_hbox),w->output_vbox,FALSE,FALSE,0);
   w->output_radio_soundcard=gtk_radio_button_new_with_label(NULL,"Soundcard");
   gtk_box_pack_start(GTK_BOX(w->output_vbox),w->output_radio_soundcard,FALSE,FALSE,0);
   gtk_signal_connect(GTK_OBJECT(w->output_radio_soundcard),"toggled",
                      GTK_SIGNAL_FUNC(wind_main_output_file_toggle),NULL);
   w->output_radio_file=gtk_radio_button_new_with_label_from_widget(
                        GTK_RADIO_BUTTON(w->output_radio_soundcard),"File");
   gtk_box_pack_start(GTK_BOX(w->output_vbox),w->output_radio_file,FALSE,FALSE,0);
   w->output_file_entry=gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(w->output_vbox),w->output_file_entry,FALSE,FALSE,0);
   if(flag_output==FLAG_IO_FILE){
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w->output_radio_file),1);
      gtk_widget_set_sensitive(w->output_file_entry,1);
   }else{
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w->output_radio_soundcard),1);
      gtk_widget_set_sensitive(w->output_file_entry,0);
   }
   if(filename_output) gtk_entry_set_text(GTK_ENTRY(w->output_file_entry),filename_output);

   // Logo and Version
   w->logo_hbox=gtk_hbox_new(FALSE,0);
   alignment=gtk_alignment_new(0.5,0.0,0.0,0.0);
   gtk_container_add(GTK_CONTAINER(alignment),w->logo_hbox);
   gtk_box_pack_start(GTK_BOX(w->buttonhbox),alignment,TRUE,TRUE,0);

   w->logo_pixmap=gdk_pixmap_create_from_xpm_d(w->window->window,
                                               &w->logo_mask,NULL,
                                               vocoder_xpm);
   w->logo=gtk_pixmap_new(w->logo_pixmap,w->logo_mask);
   gtk_box_pack_start(GTK_BOX(w->logo_hbox),w->logo,FALSE,FALSE,0);
#if 0
   w->logo_version=gtk_label_new("v"VERSION" ("VERSIONDATE")");
#else
   w->logo_version=gtk_label_new("v"VERSION);
#endif
   alignment=gtk_alignment_new(0.0,1.0,0.0,0.0);
   gtk_container_add(GTK_CONTAINER(alignment),w->logo_version);
   gtk_box_pack_start(GTK_BOX(w->logo_hbox),alignment,FALSE,FALSE,10);

   // Bands
   wind_main_create_bands(w);
   gtk_widget_show_all(w->window);
}

// wind_main_set_numbands /*fold00*/
void wind_main_set_numbands(){
   struct wind_main *w=&wind_main;
   vocoder_init();
   wind_main_create_bands(w);
   gtk_widget_show_all(w->window);
}

// wind_main_select_playbutton /*fold00*/
void wind_main_select_playbutton(int i){
   struct wind_main *w=&wind_main;

   gtk_widget_set_sensitive(wind_main_buttons[BUTTONS_START].widget,i==BUTTONS_START?0:1);
   gtk_widget_set_sensitive(wind_main_buttons[BUTTONS_PAUSE].widget,i==BUTTONS_PAUSE?0:1);
   gtk_widget_set_sensitive(wind_main_buttons[BUTTONS_STOP].widget,i==BUTTONS_STOP?0:1);
   gtk_widget_show_all(w->toolbar);
}

/***** Callbacks *****/ /*FOLD00*/
// wind_main_about /*fold00*/
void wind_main_about(){
   wind_about_init();
}

// wind_main_setbands /*fold00*/
void wind_main_setbands(){
   wind_setbands_init();
}

// wind_main_button_exit /*fold00*/
void wind_main_button_exit(){
   wind_cleanup();
}

// wind_main_delete /*fold00*/
void wind_main_delete(GtkWidget *widget,GdkEvent *event,gpointer data){
   USE(widget);
   USE(event);
   USE(data);
   window_counter--;
   if(window_counter==0) wind_cleanup();
}
// wind_main_button_mute /*fold00*/
void wind_main_button_mute(){
   struct wind_main *w=&wind_main;
   struct wind_main_bandbar *b;
   int i;

   for(i=0;i<num_bands;i++){
      b=&w->bandbars[i];
      gtk_adjustment_set_value(GTK_ADJUSTMENT(b->volume_adjustment),1.0);
      wind_main_set_vol_pan(b);
   }
}

// wind_main_button_unmute /*fold00*/
void wind_main_button_unmute(){
   struct wind_main *w=&wind_main;
   struct wind_main_bandbar *b;
   int i;

   for(i=0;i<num_bands;i++){
      b=&w->bandbars[i];
      gtk_adjustment_set_value(GTK_ADJUSTMENT(b->volume_adjustment),0.0);
      wind_main_set_vol_pan(b);
   }
}

// wind_main_button_start /*fold00*/
void wind_main_button_start(){
   int ret;
   char tmp[300];

   if((ret=sound_start())==0){
      wind_main_select_playbutton(BUTTONS_START);
      return;
   }

   wind_main_select_playbutton(BUTTONS_STOP);
   strcpy(tmp,"Couldn't start sound: \n");
   str_errcode(tmp+strlen(tmp),ret);
   wind_alert("Error starting sound",tmp,"Ok");
}

// wind_main_button_pause /*fold00*/
void wind_main_button_pause(){
   char tmp[300];
   int ret;

   if((ret=sound_pause())==0){
      wind_main_select_playbutton(BUTTONS_PAUSE);
      return;
   }
   wind_main_select_playbutton(BUTTONS_STOP);
   strcpy(tmp,"Couldn't start sound: \n");
   str_errcode(tmp+strlen(tmp),ret);
   wind_alert("Error starting sound",tmp,"Ok");
}
// wind_main_button_stop /*fold00*/
void wind_main_button_stop(){
   sound_stop();
   wind_main_select_playbutton(BUTTONS_STOP);
}


// wind_main_volume /*fold00*/
static void wind_main_volume(GtkAdjustment *adj,gpointer data){
   USE(adj);
   USE(data);
   vocoder_set_mainvol(1.0-GTK_ADJUSTMENT(adj)->value);
}

// wind_main_band_volume /*fold00*/
static void wind_main_band_volume(GtkAdjustment *adj,gpointer data){
   struct wind_main_bandbar *b=(struct wind_main_bandbar *)data;
   USE(adj);
   wind_main_set_vol_pan(b);
}

// wind_main_band_panning /*fold00*/
static void wind_main_band_panning(GtkAdjustment *adj,gpointer data){
   struct wind_main_bandbar *b=(struct wind_main_bandbar *)data;
   USE(adj);
   wind_main_set_vol_pan(b);
}

// wind_main_formant_file_toggle /*fold00*/
void wind_main_formant_file_toggle(){
   struct wind_main *w=&wind_main;

   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w->formant_radio_file))){
      gtk_widget_set_sensitive(w->formant_file_entry,1);
      wind_main_button_stop();
      flag_formant=FLAG_IO_FILE;
   }else{
      gtk_widget_set_sensitive(w->formant_file_entry,0);
      wind_main_button_stop();
      flag_formant=FLAG_IO_SOUNDCARD;
   }
}

// wind_main_carrier_file_toggle /*fold00*/
void wind_main_carrier_file_toggle(){
   struct wind_main *w=&wind_main;

   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w->carrier_radio_file))){
      gtk_widget_set_sensitive(w->carrier_file_entry,1);
      wind_main_button_stop();
      flag_carrier=FLAG_IO_FILE;
   }else{
      gtk_widget_set_sensitive(w->carrier_file_entry,0);
      wind_main_button_stop();
      flag_carrier=FLAG_IO_SOUNDCARD;
   }
}

// wind_main_output_file_toggle /*fold00*/
void wind_main_output_file_toggle(){
   struct wind_main *w=&wind_main;

   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w->output_radio_file))){
      gtk_widget_set_sensitive(w->output_file_entry,1);
      wind_main_button_stop();
      flag_output=FLAG_IO_FILE;
   }else{
      gtk_widget_set_sensitive(w->output_file_entry,0);
      wind_main_button_stop();
      flag_output=FLAG_IO_SOUNDCARD;
   }

}
