/*
 Vocoder               SCY/.tSCc.
   12.03.99

   GUI: Set bands dialog
*/

// Includes /*fold00*/
#include "vocoder.h"
#include "wind_main.h"
#include "wind_setbands.h"
#include "wind_common.h"

// Icons /*fold00*/
#include "imgs/icon.xpm"

// Globals /*fold00*/
struct wind_setbands wind_setbands={};

static void wind_setbands_delete(GtkWidget *widget,GdkEvent *event,gpointer data);
static void wind_setbands_ok();
static void wind_setbands_apply();
static void wind_setbands_cancel();

// wind_setbands_close /*fold00*/
void wind_setbands_close(){
   struct wind_setbands *w=&wind_setbands;
   if(w->window==NULL) return;
   gtk_widget_destroy(w->window);
   w->window=NULL;
   window_counter--;
   if(window_counter==0) wind_cleanup();
}

// wind_setbands_init /*fold00*/
void wind_setbands_init(){
   struct wind_setbands *w=&wind_setbands;

   if(w->window) return;
   window_counter++;

   w->window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(GTK_WINDOW(w->window),"Vocoder // Set bands");
   gtk_signal_connect(GTK_OBJECT(w->window),"delete_event",GTK_SIGNAL_FUNC(wind_setbands_delete),NULL);
   gtk_container_border_width(GTK_CONTAINER(w->window),0);
   gtk_widget_realize(w->window);
   wind_create_icon(w->window,icon_xpm);

   // Main VBox
   w->mainvbox=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(w->window),w->mainvbox);

   // Spinbutton
   w->numbands_frame=gtk_frame_new("Number of bands");
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->numbands_frame,TRUE,TRUE,5);
   w->numbands_align=gtk_alignment_new(0.5,0.5,0.0,0.0);
   gtk_container_add(GTK_CONTAINER(w->numbands_frame),w->numbands_align);
   w->numbands_adj=gtk_adjustment_new(num_bands,4.0,MAXBANDS,1.0,4.0,1.0);
   w->numbands_spin=gtk_spin_button_new(GTK_ADJUSTMENT(w->numbands_adj),1.0,0);
   gtk_container_add(GTK_CONTAINER(w->numbands_align),w->numbands_spin);

   // Buttons
   w->buttonhbox=gtk_hbox_new(TRUE,10);
   gtk_box_pack_start(GTK_BOX(w->mainvbox),w->buttonhbox,FALSE,FALSE,5);
   w->button_ok=gtk_button_new_with_label("Ok");
   gtk_signal_connect(GTK_OBJECT(w->button_ok),"clicked",GTK_SIGNAL_FUNC(wind_setbands_ok),NULL);
   gtk_box_pack_start(GTK_BOX(w->buttonhbox),w->button_ok,TRUE,TRUE,5);
   w->button_apply=gtk_button_new_with_label("Apply");
   gtk_signal_connect(GTK_OBJECT(w->button_apply),"clicked",GTK_SIGNAL_FUNC(wind_setbands_apply),NULL);
   gtk_box_pack_start(GTK_BOX(w->buttonhbox),w->button_apply,TRUE,TRUE,5);
   w->button_cancel=gtk_button_new_with_label("Cancel");
   gtk_signal_connect(GTK_OBJECT(w->button_cancel),"clicked",GTK_SIGNAL_FUNC(wind_setbands_cancel),NULL);
   gtk_box_pack_start(GTK_BOX(w->buttonhbox),w->button_cancel,TRUE,TRUE,5);

   gtk_widget_show_all(w->window);
}
/***** Callbacks *****/ /*FOLD00*/
// wind_setbands_ok /*fold00*/
void wind_setbands_ok(){
   wind_setbands_apply();
   wind_setbands_close();
}

// wind_setbands_apply /*fold00*/
void wind_setbands_apply(){
   struct wind_setbands *w=&wind_setbands;
   int new_numbands=(int)GTK_ADJUSTMENT(w->numbands_adj)->value;

   if(new_numbands!=num_bands){
      num_bands=new_numbands;

      wind_main_set_numbands();
   }
}
// wind_setbands_cancel /*fold00*/
void wind_setbands_cancel(){
   wind_setbands_close();
}

// wind_setbands_delete /*fold00*/
void wind_setbands_delete(GtkWidget *widget,GdkEvent *event,gpointer data){
   USE(widget);
   USE(event);
   USE(data);
   wind_setbands_close();
}

