IMPLEMENTATION MODULE MidiCom;
IMPORT Cookie;
IMPORT InOut;
IMPORT GEMDOS;


(* 
 Library zu Midicom
 Setzt Midicom-version ab 3.91 voraus

 (c) Georg Wagner
		 Im Altried 1H
		 8051 Zuerich

		 Email: wagg@zellweger.ch

	24.5.94: Version 1.0, Erste  oeffentliche Version
	25.6.94: Version 1.1, Anpassung an neue Schnittstelle

	Die Module MIDICOM.D und MIDICOM.M sind Freeware. Sie koennen, solange
	sie nicht kommerziell vertrieben werden, frei verwendet werden.

	Das Copyright verbleibt aber beim Autor.
	Werden an dieser Library Korrekturen angebracht oder basierend auf
	dieser Library eigene Module erstellt, wuerde ich mich freuen, entsprechende
	Belegexemplare zu erhalten. 
*)

IMPORT AES;
FROM FastStorage IMPORT ALLOCATE, DEALLOCATE;
FROM SYSTEM IMPORT CODE, ADDRESS, ADR, TSIZE;

TYPE

			tMsg = RECORD what:SHORTINT;(*2 byte *)
											 size: SHORTINT;
											 ptr : tpIoRec; (*4 byte *)
											 name: ADDRESS; (*4 byte *)
											 an  : SHORTINT; (* 2 byte *)
											 fill: SHORTINT; (* 2 Byte *)
								END;	 (* summe = 16 Byte *)

		 tMsgProc = PROCEDURE (VAR tMsg): LONGINT;

		 tpInfo = POINTER TO RECORD
							 parameters: ADDRESS;
							 kernel:		 ADDRESS;
							 lw:				 SHORTINT;
							 mygemdos: tMsgProc;
						 END;

VAR apl: LONGINT;
		rBuf: tpIoRec;
		mcMessage: tMsgProc;
		info: tpInfo;


PROCEDURE wait (timer: SHORTCARD);
BEGIN
	AES.in2(timer,0);
	AES.call(24,2,1,0)
END wait;

(*
PROCEDURE system(VAR sys: tSystem; VAR apps: tapp): BOOLEAN;
BEGIN
END system;
*)

	PROCEDURE enter(name: STRING;buffSize:SHORTINT):LONGINT;

	BEGIN
	 buffSize:=buffSize-1;
	 IF buffSize<1999 THEN buffSize:=1999 END;
	 IF buffSize>29999 THEN buffSize:=29999 END;
	 IF rBuf = NIL THEN
		 ALLOCATE(rBuf, TSIZE(tIoRec));
		 ALLOCATE(rBuf^.ibuf, buffSize); 
	 END;
	 WITH rBuf^ DO
		size:=buffSize+1; (* groesse des Buffers			 *)
		nl	:=0;					 (* naechste Leseposition 	 *)
		nw	:=0;					 (* naechste Schreibposition *)
		berr:={}; 					(* status/fehler						*)
		back:=-1; 				 (* Ack: msg gelesen				 *)
	 END;
	 apl:= writeMsg(cASSIGN,0,0,0,ADR(name),rBuf);
	 IF apl >= 0 THEN
		RETURN apl
	 ELSE 
		RETURN 0;
	 END; 
	END enter;

	PROCEDURE leave();
	BEGIN 
	 VOID(writeMsg(cGOODBYE,apl,0,0,NIL,NIL));
	 IF rBuf # NIL THEN
		DEALLOCATE(rBuf^.ibuf, rBuf^.size-1);
		DEALLOCATE(rBuf, TSIZE(tIoRec));
	 END; 
	END leave;

(* $E+ *) 
PROCEDURE  message(VAR msg:tMsg): LONGINT;
VAR stack: ADDRESS;
erg: LONGINT;
BEGIN
stack:= GEMDOS.Super(0);
erg:= info^.mygemdos(msg);
VOID(GEMDOS.Super(stack));
RETURN erg;
END message;
(* $E= *)

(* $X- $Y- $E+*)
PROCEDURE trap111(VAR msg:tMsg):LONGINT;
BEGIN 
(*\ONYX v2.00  13.05.94 19:27*)(*$D-*)
(*14 bytes of MC68000 code*)

CODE(0206EH,00008H);

CODE(02F08H);

CODE(03F3CH,0006FH);

CODE(04E41H);

CODE(05C4FH);

(*$D=*)
(*\= 
		 movea.l 8(A6),A0
		 move.l  A0,-(SP)
		 move.w  #111,-(SP) 		 ;nummer 111
		 trap 	 #1
		 addq.w  #6,SP
\*)
END trap111;
(* $X= $Y= $E=*)


PROCEDURE writeMsg(what,aplNum,an, size:SHORTINT; name: ADDRESS;data:tpIoRec):LONGINT;
VAR buf:tMsg;
	
BEGIN
	buf.what:=what;
	buf.size:=size;
	buf.an:=an;
	buf.ptr:=data;
	buf.name:= name;
	buf.fill:=aplNum;
	RETURN mcMessage(buf); (* trap111(buf); *)
END writeMsg;

PROCEDURE transmit(size,an:SHORTINT; name: STRING; data: ADDRESS):LONGINT;

BEGIN
	RETURN	writeMsg( cSENDDATA ,apl,an,size,ADR(name),data);
END transmit;

	PROCEDURE read(msg: ADDRESS;VAR esc,len:SHORTINT):BOOLEAN;
	TYPE
		tlen = RECORD
						 CASE : BOOLEAN OF
							 FALSE: asInt: SHORTCARD;|
							 TRUE:	asChar: ARRAY [0..1] OF CHAR;
						 END;
					 END;

	VAR i:SHORTINT;
			j: tlen;
			message: tpBuf;
	BEGIN
		message:= msg;
		esc:= 0;
		WITH rBuf^ DO
			IF nl = nw THEN RETURN FALSE END;
			j.asChar[0]:= ibuf^[nl]; INC(nl);
			IF nl = size THEN nl:= 0 END;
			j.asChar[1]:= ibuf^[nl]; INC(nl);
			IF nl = size THEN nl:= 0 END;

			IF j.asInt > 4000 THEN
				esc:= j.asInt;
				j.asChar[0]:= ibuf^[nl]; INC(nl);
				IF nl = size THEN nl:= 0 END;
				j.asChar[1]:= ibuf^[nl]; INC(nl);
				IF nl = size THEN nl:= 0 END;
				len:= j.asInt;
			END;
			FOR i:= 0 TO j.asInt - 3 DO
				message^[i]:= ibuf^[nl]; INC(nl);
				IF nl = size THEN nl:= 0 END;
			END;
		END;
		RETURN TRUE; 
	END read;

PROCEDURE keepToken();
BEGIN 
 IF (rBuf^.berr * cReady = cReady ) THEN
	WHILE (cDataWaiting IN rBuf^.berr) DO wait(5) END;
	rBuf^.back:=-1;
	VOID(writeMsg(cKEEPTKN,apl,0,0,NIL,NIL));
 END;
END keepToken;

PROCEDURE tokenWaits():BOOLEAN;
BEGIN
 IF (rBuf^.berr * cReady = cReady) THEN
	RETURN ((rBuf^.berr* {cStopTkn,cWaitTkn} ) = {cStopTkn,cWaitTkn});
 ELSE
	 RETURN TRUE;
 END;
END tokenWaits;

PROCEDURE freeToken();
BEGIN 
 IF (rBuf^.berr * cReady = cReady ) THEN
	WHILE (cDataWaiting IN rBuf^.berr) DO wait(5) END;
	VOID(writeMsg(cFREETKN,apl,0,0, NIL, NIL));
 END;
END freeToken;

PROCEDURE getIoRec();
BEGIN
 VOID(writeMsg(cGETIOREC,apl,0,0,NIL,NIL));
END getIoRec;

PROCEDURE sysTime();
BEGIN
	IF (rBuf^.berr*cReady = cReady) THEN VOID(writeMsg(cSETTIME,apl,0,0, NIL, NIL)) END;
END sysTime;

PROCEDURE busy():BOOLEAN;
(* ring geschlossen und im sende-Modus, 
	 Problem: seit der Version 3.91 scheint Midicom immer busy zu sein.
	 Bei frueheren Versionen funktionierte es korrekt. Harald?
*)
BEGIN 
	RETURN ((rBuf^.berr * cReady = cReady ) AND (cDataWaiting IN rBuf^.berr));
END busy;

PROCEDURE ready(): BOOLEAN;
BEGIN
	RETURN (rBuf^.berr * cReady = cReady );
END ready;

PROCEDURE closed():BOOLEAN;
(* ring geschlossen *)
BEGIN 
	RETURN (rBuf^.berr * cReady = cReady );
END closed;

PROCEDURE newState():BOOLEAN;
(* ring-Verwaltung wurde gendert *)
BEGIN 
	RETURN (cNewState IN rBuf^.berr) (*  ((rBuf^.berr & 2048)=2048) *);
END  newState;


BEGIN
	mcMessage:= trap111;
	IF Cookie.Get(LONGCARD("MICO"), info) THEN 
		mcMessage:= message;
	END;
END MidiCom.


		
	
	