DEFINITION MODULE MidiCom;
(*

 Library zu Midicom
 Setzt Midicom-version ab 3.91 voraus

 (c) Georg Wagner
		 Im Altried 1H
		 8051 Zuerich

		 Email: wagg@zellweger.ch
	29.5.94: Version 1.1, Anpassung an neue Schnittstelle, Auslesen des
					 MICO-Cookies, laeuft unter MiNT. 
	24.5.94: Version 1.0, Erste  oeffentliche Version

	Die Module MIDICOM.D und MIDICOM.M sind Freeware. Sie koennen, solange
	sie nicht kommerziell vertrieben werden, frei verwendet werden.

	Das Copyright verbleibt aber beim Autor.
	Werden an dieser Library Korrekturen angebracht oder basierend auf
	dieser Library eigene Module erstellt, wuerde ich mich freuen, entsprechende
	Belegexemplare zu erhalten.

	Bekannte Maengel: Die Funktion get_mc_sys wurde noch nicht implementiert.

*)

FROM SYSTEM IMPORT ADDRESS;
CONST 
	
(* msg-Konstanten *)
			cASSIGN 	 = 6000; (* Appl meldet sich an 	*)
			cGOODBYE	 = 6001; (* Appl meldet sich ab 	*)
			cSENDDATA  = 6002; (* Nutznachricht senden	*)
			cKEEPTKN	 = 6004; (* warte auf token 			*)
			cFREETKN	 = 6005; (* befreie Token 				*) 
			cSETTIME	 = 6007; (* setze Zeit fr ganzen Ring gleich *)
			cSTOP 		 = 6008;
			cGETIOREC  = 6009; (* Lese Ring-Karte 			*)
			cRESTART	 = 6025
			cPRTCONF	 = 6030;

			cSync 			 = 0;
			cTest 			 = 1;
			cFirstTkn 	 = 2;
			cStopTkn		 = 3;
			cWaitTkn		 = 4;
			cSendPrt		 = 5;
			cDataWaiting = 6;
			cHasPrinter  = 7;
			cPrg				 = 8;
			cPrinting 	 = 9;
			cJobsPending = 10;
			cNewState 	 = 11;
			cReady			 = {cSync, cTest, cFirstTkn};


	 TYPE 
			tBuf= ARRAY [0..29999] OF CHAR;
			tpBuf= POINTER TO tBuf;
			tpIoRec= POINTER TO tIoRec;
			tIoRec=RECORD ibuf: tpBuf;		 (* Zeiger auf den buffer *)
										size: SHORTINT; 	 (* groesse des Buffers 	*)
										nw	: SHORTINT; 	 (* naechste Leseposition 	 *)
										nl	: SHORTINT; 	 (* naechste Schreibposition *)
										berr: BITSET; 		 (* status/fehler 					 *)
										back: SHORTINT; 	 (* Ack=0 wenn msg gelesen	 *)
						 END;
(*
			 tSystem = RECORD
									 PrtLock: 	 SHORTINT;
									 SendFF:		 SHORTINT;
									 No:				 SHORTINT;
									 Errbell: 	 SHORTINT;
									 PrtTimeOut: SHORTINT;
									 PrtTimeFF:  SHORTINT;
									 Speed: 		 SHORTINT;
									 TimeOut: 	 SHORTINT;
									 PrtPack: 	 SHORTINT;
									 PrtConf: 	 SHORTINT;
									 Received:	 LONGCARD;
									 Errors:		 LONGCARD;
									 TOSOff:		 SHORTINT 
								 END;

			 tpSystem = POINTER TO tSystem;

	tstr9 = ARRAY[0..9] OF CHAR; (* = 10 Byte *)

	tadm = RECORD
					 CASE : BOOLEAN OF
						 TRUE: application :ARRAY [0..5] OF tstr9;	(* Appl. Name 	 *)
									 rName	:tstr9;
									 status :BITSET; (* Status-Bits *)
									 diskST :SHORTINT;|
						 FALSE: ary:ARRAY [0..73] OF CHAR;
					 END;
				 END;

	tapp = ARRAY [0..7] OF tadm;

PROCEDURE system(VAR sys: tSystem; VAR apps: tapp): BOOLEAN;
*)

PROCEDURE enter(name: STRING; buffSize:SHORTINT): LONGINT;
PROCEDURE leave();
PROCEDURE transmit(size,an:SHORTINT; name:STRING; data:ADDRESS): LONGINT;
PROCEDURE read(msg:ADDRESS;VAR esc,len:SHORTINT): BOOLEAN;
PROCEDURE keepToken();
PROCEDURE freeToken();
PROCEDURE getIoRec();
PROCEDURE sysTime();
PROCEDURE busy(): BOOLEAN;
PROCEDURE ready(): BOOLEAN;
PROCEDURE closed(): BOOLEAN;
PROCEDURE newState(): BOOLEAN;

PROCEDURE wait (timer: SHORTCARD);
END MidiCom.
		
	
	