PMF$  ' Source code for Hisoft C Interpreter.  C This small chunk of # commands are instructions to the compiler.  I For now, you can ignore them, as we will be examining them next month.  #<stdio.h># STandarD Input and Output Header   #FALSE #n
TRUE(){(WW)} #nFALSE(){(W_)} #FALSE H*********************************************************************** H Set up global variables. These variables are visible to all functions  H***********************************************************************  G*board
NULL;; Pointer to Othello Board   H The representation of the Othello pieces used in the screen display is J stored in the piece[] array, while (int)player indicates which player's  K turn it is, and is an index into the piece[] array giving the piece used   by that player.  Gpiece[W]{O,X};; player_;;  end_othello_;; Set non-zero to exit Othello     Error messages for Othello G*errors[W]{/ end_othello  Not enough memory,3 1  Error displaying Board,3 2  
Quit pressed3 3  };;   ;********************************************************** # main()  - Entry point of program  ;**********************************************************  
main() { x,y;;# Coordinates of the player's move  
init();;  Initialises global variables.  get_move();;  Gets a move from the player.   show_board();; Displays Othello Board.   make_move();; Make the move specified.     
init();; Initialise Othello.      > Main loop - repeats until end_othello takes a non-zero value  (!end_othello) { ! Read in a move from the player. B Note that the player's move, translated into coordinates in the  C Othello Board, is "returned" via pointers to (int)x and (int)y .  get_move(&x,&y);;  A The first thing we check is whether or not the player has quit, A skipped a go or restarted the game. x is set to -1 to indicate   the latter two options.   $(!end_othellox-W) { $(make_move(x,y)) { 4 Switch to next player if the move given was legal. $(player_) playerW;; ~ player_;;   Re-display the Othello Board. show_board();; } ~ { ! Move was illegal, so try again. /(: Illegal Move: Press a Key);;  (W);;  ) Back space over previous message, erase $ it and then backspace back again.   /(\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b);; /(\b\b\b\b\b\b\b\b\b\b\b\b\b\b);; /(                             );; /(\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b);; /(\b\b\b\b\b\b\b\b\b\b\b\b\b\b);; };; };; };;    Handle error codes. /(\n\n%s\nPress a Key\n,errors[end_othello-W]);;  (W);;   : Free block of memory used by Othello Board if necessary. $(board
NULL) (board);; };;   E******************************************************************** / get_move()  -    Get a move from the player.  <                  Reads in two characters from the player,  ?                  and translates them into coordinates in the  =                  Othello board. Those coordinates are then  =                  placed into two integers via the pointers  4                  (int *)x and (int *)y passed in.  E********************************************************************  get_move(x,y) *x,*y;; { Gc;;% The character typed by the player.  show_board();; Displays Othello Board.   setup_board();;  Set up Board for a new game.     < We first of all obtain a single character from the player, ? repeating this as many times as is necessary before we get a  
 valid one.   8{ 5 The ampersand (&) performs a bitwise AND operation. 7 we use it here because we are only interested in the  : lower word of the value returned from Bconin(), as that  7 word contains the ASCII code of the character typed.   c(G)((W)&);;  8 Convert a lower-case character into an upper-case one. E Note the use of the -= operator, which subtracts the result of the  F right-hand side from the variable on the left, exactly as if we had  D used "c = c - ('a' - 'A');" Similarly, we can use other shorthand  / operators, such as +=, *=, /=, %=, etc, etc.   $(cacz) ca-A;;  > Note that valid characters are ''A' to 'H', 'Q', 'R' and ESC } (!((cAcH) cQcRc));;   *yc-A;;  $(c) .(c);;  Echo character to the screen     J We only bother to obtain the second character from the user if the first + was a coordinate, rather than a command.   $(cAcH) { < Next we repeat the operation but we're looking for a digit  from '1' to '8' this time.  8{ c(G)((W)&);;  $(cacz) ca-A;;  5 Valid characters are '1' to '8' and 'Q', 'R' or ESC } ((c1c8) cQcRc);;   $(c1c8) { .(c);; Echo character to the screen   *xc-1;; };; };;   $ Handle commands given by the user.  $(cQ) Quit program    end_othelloW;;  $(c) ESC pressed = skip a turn  {  Switch to next player. $(player_) playerW;; ~ player_;;  show_board();; };;  $(cR) Restart (new game)   setup_board();;  $(ccR) Signal no move entered  *x-W;; };;   B***************************************************************** 6 show_board()  -  Displays the entire Othello Board.  @                  Since we are using a memory block, and we no  @                  longer put EOS characters on the end of each  =                  line of the Board, this function is now a  ?                  little more complex than it was last month.   ?                  This function also now detects a Game Over.  B*****************************************************************  show_board() { Gthispiece;; A piece on the board.   x,y;;" Offsets into the Board "array."  
cnt0,
cnt1;;$ Count of pieces owned by players.  Gget_piece();;  Get value of specific piece.   setup_board();;  Set up Board for a new game.     + Resets the count of pieces owned to zero. J Note that every C expression has a value. The value of an assignment is  G the value assigned, thus the value of "cnt1 = 0;" is zero, which can  4 iself be assigned to a variable, as happens here.   
cnt0
cnt1_;;   /(%cE,);;#' VT52 control code - clears the screen  /(  12345678\n  ________ \n);;  (y_;;yW;;y) { B This first putchar() will ensure that the leftmost column of the A Board will contain one of the letters 'A' to 'H', depending on  A the line. Note that a char is merely an 8-bit integer like any  C other integer. It only "becomes" an ASCII code when we use it as   such.   .(A+y);; .(|);;  (x_;;xW;;x) { thispieceget_piece(x,y);;  : putchar() returns -1 on errors, so we can test its value 6 within the conditional, with no need for a separate  ! statement or another variable.   $((.(thispiece))-W) { end_othelloW;;  o;;% Exit function, but no return value  };;  2 Update the count of pieces owned by each player. ; Note the use of "cnt0++", which increments (adds one to)  ? the variable cnt0, exactly as if we had typed the expression  = "cnt0 = cnt0 + 1" or "x += 1". "cnt0++" is preferred here,  8 though, not only because it saves typing, but it also  ? allows the compiler to generate slightly more efficent code.  > Similarly, "cnt0--" would decrement (subtract one from) the   variable cnt0.   $(thispiecepiece[_]) 
cnt0;; ~ { $(thispiecepiece[W]) 
cnt1;; };; };;  .(|);; .(
);; Output '\n' at end of line  };;  /(   \n\n);; /(Score:\t%c: %d\t\t%c: %d\n,piece[_],
cnt0,piece[W],
cnt1);;   # Check to see if the game is over. K This happens if all of the squares are filled or if either player has no  I pieces remaining on the board. A Game Over is also forced when neither  H player has any legal moves available, but we'll cover that next month  0 when we add a computer player to the program.   $((
cnt0+
cnt1)@W
cnt0_
cnt1_) { /(\nGame Over: );;  $(
cnt0
cnt1) /(It was a draw);; ~ { $(
cnt0
cnt1) player_;; ~ playerW;;  /(Player \'%c\' has won,piece[player]);; };;  /(.\n\nPress a Key\n);;$ Wait for a key press.  (W);;  setup_board();;$ Set up board for new game.  } ~ { 0 Game not over, so prompt user to enter a move.  /(\n\nCommands available: );; /(+Q (Quit), R (Restart), ESC (skip a go)\n\n);; /(*Type your move, player \'%c\' (e.g. A7): ,piece[player]);; };; };;   D******************************************************************* C make_move()  -   Check the legality of placing a piece belonging  ?                  to the current (int)player at square (int)x  8                  on line (int)y of the Othello Board.   =                  If the move is legal, then perform it and  8                  return TRUE, otherwise return FALSE.  D*******************************************************************  make_move(x,y) x,y;;" Coordinates to place new piece.  { x_off;; x-offset from <x,y>    y_off;; y-offset from <x,y>    was_legalFALSE;;$ Assume legal is illegal at first.  opposing();;! Check if pieces is opponent's.  follow_trail();;& Check if trail exists in some dirn.  flip_trail();;' Flip all opponent's pieces in trail.  set_piece();;  Set value of specific piece.   Gget_piece();;  Get value of specific piece.     H If the proposed move is to a non-empty square then it is automatically  illegal.   $(get_piece(x,y).) o(FALSE);;   ; We loop around all eight neighbours of the current piece. C Note that there is no need in this instance to check whether the  A coordinates given are off the Board, as that is checked in the   opposing() function.   (y_off-W;;y_offW;;y_off) { (x_off-W;;x_offW;;x_off) { ; Don't include the current piece (the one a <x,y>) in this 
 search.   $(x_off_y_off_) { $(opposing(x+x_off,y+y_off)) { ' We have found an adjacent piece which  belongs to the opponent.   $(follow_trail(x,y,x_off,y_off)) { ' Having found a valid trail of pieces, & we execute the move by flipping any  " opponent's pieces in the trail.   flip_trail(x,y,x_off,y_off);;    Set the (int)was_legal flag to % indicate that this move is a legal   one.   was_legal
TRUE;; };; };; };; };; };;  = Return a flag indicating whether this move was a legal one.  o(was_legal);; };;   F********************************************************************* C follow_trail()  -     Given a position on the Board (x, y), this  F                       function attempts to follow a trail of pieces  4                       in the direction specified.   E                       If the trail consists of an unbroken line of  F                       pieces belonging to the opponent of the owner  B                       of the piece at <x,y> followed by a piece  E                       belonging to the owner of the piece at <x,y>  @                       then TRUE is returned, otherwise FALSE.   H                       The direction is specified as a pair of offsets  I                       (int x_dirn and y_dirn) to be successively added  2                       to the <x,y> coordinates.  E********************************************************************  follow_trail(x,y,x_dirn,y_dirn) x,y;;! Coordinates of start of trail.  x_dirn,y_dirn;; Direction of trail.    { opposing();;& Check if piece belongs to opponent.  Gget_piece();;  Get value of specific piece.     K Continue moving in the direction given by <x_dirn, y_dirn> until we reach H a piece which does not belong to the opponent of current (int)player.   I This is a do{}while loop since we must move one square in the required  / direction before we can make the first test.   8{ xx_dirn;; yy_dirn;; } (opposing(x,y));;   6 Check whether we have reached the edge of the Board. < If so, this trail is not a good one, and so return FALSE.   $(x_xWy_yW) o(FALSE);;   @ Check if the piece at the end of the trail is an empty square. M If so, this trail is not a good one (it should end in a piece owned by the  ; the current (int)player, and so return FALSE. Otherwise,   return TRUE (trail valid).   $(get_piece(x,y).) o(FALSE);; ~ o(
TRUE);; };;   F********************************************************************* > flip_trail()  -  Given a position on the Board (x, y), this  A                  function attempts to follow a trail of pieces  /                  in the direction specified.   B                  A trail consists of an unbroken line of pieces  <                  belonging to the opponent of the current  A                  (int)player, followed by a piece belonging to  ,                  the current (int)player.   B                  Every one of the opponents pieces in the trail  B                  is flipped over to become a piece belonging to  ,                  the current (int)player.   C                  The direction is specified as a pair of offsets  D                  (int x_dirn and y_dirn) to be successively added  -                  to the <x,y> coordinates.   A                  Finally, note that this function assumes that  @                  the trail to be flipped both exists and is a  @                  valid one, having been previously checked by  #                  follow_trail().  D*******************************************************************  flip_trail(x,y,x_dirn,y_dirn) x,y;;! Coordinates of start of trail.  x_dirn,y_dirn;; Direction of trail.    { opposing();;& Check if piece belongs to opponent.  set_piece();;  Set value of specific piece.     K Continue moving in the direction given by <x_dirn, y_dirn> until we reach ? a piece which does not belong to the opponent of the current  1 (int)player, which marks the end of the trail.   I This is a do{}while loop since we must move one square in the required  / direction before we can make the first test.   8{ set_piece(x,y,piece[player]);;) Flip the piece   xx_dirn;; yy_dirn;; } (opposing(x,y));; };;   G********************************************************************** H opposing() -     Takes as arguments the coordinates of a piece on the  +                  Board ( int x, int y ).   I                  Returns TRUE if there is a piece at coordinates <x,y>  9                  which does not belong to (int)player.  G**********************************************************************  opposing(x,y) x,y;;! Coordinates of piece to check.  { Gthispiece;;! Holds piece at position <x,y>.  Gget_piece();;  Get value of specific piece.     A If this piece is off the Board then return FALSE automatically.  $(x_xWy_yW) o(FALSE);;  thispieceget_piece(x,y);;$ Get piece at position  <x,y>    $(thispiecepiece[player]thispiece.) o(
TRUE);; ~ o(FALSE);; };;   F********************************************************************* , init()  -   Initialises global variables.  F*********************************************************************  
init() { setup_board();;$ Set up Board for a new game.    K The major variable is the Board itself. We use malloc() to obtain a block ; of memory 8*8 bytes long, room for an 8x8 Othello Board.     board(G*)(()(W*W));;  I You should always check the value of the pointer returned from malloc()  $(board
NULL) end_othelloW;; ~ setup_board();; };;   G********************************************************************** D setup_board()  -      Sets up a blank Board ready for a new game.  G**********************************************************************  setup_board() { x;; Looping variable.    set_piece();;  Set value of specific piece.   show_board();; Displays Othello Board.     - First move of the game goes to player zero.  player_;;  (x_;;x@W;;x) *(board+x).;;$ An empty square is denoted by '.'    G Othello starts off with the central four pieces already on the Board.  set_piece(W,W,piece[_]);; set_piece(W,W,piece[W]);; set_piece(W,W,piece[W]);; set_piece(W,W,piece[_]);;   show_board();; Display the Othello Board   };;   G********************************************************************** > get_piece()  -   Returns the value of the piece at position  7                  (int)x on line (int)y of the Board.   A                  The value returned is a char (a member of the  A                  char piece[] array) indicating which player's  :                  piece is at this square, or '.' if the  $                  square is empty.  G**********************************************************************  Gget_piece(x,y) x,y;;" Coordinates of square to check.  { G Note the use off offsets with the (char *)board pointer to address an * individual element of the memory block.   o(*(board+(W*y)+x));; };;   G********************************************************************** C set_piece()  -   Actually change the piece at position (int)x on  B                  line (int)y of the Board to a new piece, given  '                  by (char)newpiece .  G**********************************************************************  set_piece(x,y,newpiece) x,y;;" Coordinates to place new piece.  Gnewpiece;; New value of piece.    { 0 Change the Board to reflect the player's move.  *(board+(W*y)+x)newpiece;; };;    End of File OTHELLO2.C  