
;****************************************************************
;*								*
;*	Recupere l(image d'un disk				*
;*	Code and Idea by Leonard/OXYGENE.			*
;*								*
;****************************************************************


; Tailles utilisateurs.
NBS		equ	9
NBT		equ	78
CMD_READ	equ	8
CMD_WRITE	equ	9


	section	text

		movea.l	sp,a5
		lea	my_stack,a7
		move.l	4(a5),a5
		move.l	#256,d7
		add.l	$c(a5),d7
		add.l	$14(a5),d7
		add.l	$1c(a5),d7
		move.l	d7,prg_size
		move.l	d7,-(sp)
		pea	(a5)
		clr.w	-(sp)
		move.w	#$4a,-(sp)
		trap	#1
		lea	12(sp),sp


		lea	txt_intro,a0
		bsr	print
		bsr	wait_key

		moveq	#CMD_READ,d0
		bsr.s	copy_disk

		lea	txt_chg,a0
		bsr	print
		bsr	wait_key

		moveq	#CMD_WRITE,d0
		bsr.s	copy_disk
		
		lea	txt_over,a0
		bsr	print
		bsr	wait_key

		rts

		
		
		clr.w	-(sp)
		trap	#1



copy_disk	clr.w	track
		move.l	#buffer,ptr
		move.w	d0,cmd
.loop:		move.w	track,d0
		moveq	#0,d1			; Side 0
		move.w	cmd,d3
		move.l	ptr,a0
		bsr	Track_Acces
		add.l	#512*NBS,ptr
		move.w	track,d0
		moveq	#1,d1			; Side 1
		move.w	cmd,d3
		move.l	ptr,a0
		bsr	Track_Acces
		add.l	#512*NBS,ptr
		addq.w	#1,track
		cmpi.w	#NBT,track
		bne.s	.loop
		rts

error		lea	txt_err,a0
		bsr	print
		bsr	wait_key
		rts
		
track		dc.w	0
cmd		dc.w	0
ptr		dc.l	0

txt_err		dc.b	'DISK ERROR.',0
txt_over	dc.b	'Ok, fini.',0
txt_chg		dc.b	7,'Change disk.',0
		even

sector		dc.w	0
print:		pea	(a0)
		move.w	#9,-(sp)
		trap	#1
		addq.l	#6,sp
		rts

wait_key:
		move.w	#7,-(sp)
		trap	#1
		addq.w	#2,sp
		rts


; D0: Track
; D1: Side
; D3: Command (8=read,9=write)
; A0: Buffer adress.
Track_Acces	cmpi.w	#CMD_READ,d3
		beq.s	.ok
		cmpi.w	#CMD_WRITE,d3
		bne.s	.non
.ok:		and.w	#1,d1
		move.w	#NBS,-(sp)	; Count
		move.w	d1,-(sp)	; Side
		move.w	d0,-(sp)	; Track
		move.w	#1,-(sp)	; Secteur deb
		clr.w	-(sp)		; Drive A:
		clr.l	-(sp)
		pea	(a0)		; buffer
		move.w	d3,-(sp)	; Command
		trap	#14
		lea	20(sp),sp
.non:		rts


;***************************************************************************
;***************************************************************************

	section	data

changed		dc.w	2	; Flag premier changement pour MEDIA-CHG.


txt_intro	dc.b	27,'E'
		dc.b	'GET DISK.',10,13
		dc.b	'(C)OXYGENE 1995 by Leonard.',10,13
		dc.b	'Insert disk to be copied.',10,13
		dc.b	0
		even


		even

;***************************************************************************
;***************************************************************************

	section	bss

		ds.l	64
my_stack:
prg_size	ds.l	1

buffer		ds.b	512*2*NBS*NBT

		END






