

;*****************************************************************
;*								*
;*	68000 Desassembleur, RAM-Viewer, MEMORY looker		*
;*	and Break-Proof written by Leonard / OXYGENE.		*
;*								*
;*****************************************************************


;	*********************************
;	*	Constantes:		*
;	*********************************
PIC		equ	0

;	*********************************
;	*	Partionnement Mmoire	*
;	*********************************
TOP		equ	$400000
SMEM1		equ	TOP-(32000*2)

;**********************************************************
	SECTION		TEXT
;**********************************************************





;*****************************************************************************
;*****************************************************************************
;*****************************************************************************


AA
;	*************************************************
;	*						*
;	*	FLIP-O-Demo 2.				*
;	*	Debugger resident.			*
;	*	(C)oderight OXYGENE 1994.		*
;	*	Written by Leonard.			*
;	*						*
;	*************************************************

; FLIP-Debug-2 contient:
;  -Un viewer de RAM.
;  -"     "   de registres.
; Initialisation avec: JSR debug
; Appel avec retour avec TRAP #15
; ATTENTION: Flip-Debug utilise $200.w

TrueTOP		equ	$400000
Place		equ	32000+(256*2*8)+256+16*80
CoulCadre	equ	$7			; Couleur des cadres.

D_Init		bra	.deb
		dc.b	'"DD" v3.1 by Leonard/OXYGENE.'
		dc.b	'68000-Desassembler,Register display, memory viewer '
		dc.b	'and restart-code option. Contact us at: OXYGENE,'
		dc.b	'22 rue Jean Mermoz, 91700 STE Genevieve des Bois,FRANCE.'
		dc.b	'Or 3615 RTEL BAL "LEONHARD".'
		even
	.deb:	clr.w	$200.w
		movem.l	d0-a6,-(sp)
		lea	StartError(pc),a0
		lea	$8.w,a1
		move.w	#($60-$8)/4-1,d0
	.Loop1:	move.l	a0,(a1)+
		adda.l	#$01000000,a0
		dbf	d0,.Loop1
		lea	StartNormal(pc),a0
		move.l	a0,$bc.w
		lea	UnRte(pc),a0
		move.l	a0,$64.w
		move.l	a0,$68.w
		movem.l	(sp)+,d0-a6
		rts
UnRte		rte

	; Sauvegarde de la zone $000  $200 pour afficher
	; la "vraie" RAM.
SauveRAM	movem.l	d0/a0-a1,-(sp)
		lea	LowRAM(pc),a1
		suba.l	a0,a0
		move.w	#$400/4-1,d0
	.Loop1:	move.l	(a0)+,(a1)+
		dbf	d0,.Loop1
		movem.l	(sp)+,d0/a0-a1
		rts

SauveContexte	movem.l	d0/a0-a1,-(sp)
		lea	Contexte(pc),a1
		movea.w	#$fa01,a0
		moveq	#15,d0
	.Loop1:	move.b	(a0),(a1)+
		addq.w	#2,a0
		dbf	d0,.Loop1
		move.b	$ffff8260.w,(a1)+	; Rsolution
		move.b	$ffff820a.w,(a1)+	; Synchronisation cran
		move.b	$ffff8201.w,(a1)+	; Adresse vido H
		move.b	$ffff8203.w,(a1)+	; Adresse vido M
		move.b	$ffff820d.w,(a1)+	; Adresse vido L (ste)
		move.b	$ffff8265.w,(a1)+	; Dcalage (STE)
		movea.w	#$8240,a0
		moveq	#7,d0
	.Loop2:	move.l	(a0)+,(a1)+
		dbf	d0,.Loop2
		moveq	#11,d0
	.Loop3:	move.b	d0,$ffff8800.w
		move.b	$ffff8800.w,(a1)+
		or.l	d0,d0
		dbf	d0,.Loop3
		movem.l	(sp)+,d0/a0-a1
		rts

Initialisations
	; Mise  jour de la table du clavier.
		lea	Clavier(pc),a0
		moveq	#128/4-1,d0
	.cl:	clr.l	(a0)+
		dbf	d0,.cl

	; Construction des octets "graphique" pour affichage rapide.
		move.l	LesOctets(pc),a1
		lea	.table(pc),a2
		move.w	#255,d7
		moveq	#0,d6
	.Loop1:	moveq	#0,d0
		moveq	#0,d1
		moveq	#$0f,d1
		and.b	d6,d1
		move.b	d6,d0
		lsr.b	#4,d0
		move.b	0(a2,d0.w),d0
		move.b	0(a2,d1.w),d1
		sub.b	#32,d0
		sub.b	#32,d1
		lsl.w	#3,d0
		lsl.w	#3,d1
		lea	Font88(pc),a0
		movea.l	a0,a3
		add.w	d0,a0
		add.w	d1,a3
		moveq	#7,d2
	.Loop2:	move.b	(a0)+,(a1)+
		move.b	(a3)+,(a1)+
		dbf	d2,.Loop2
		addq.w	#1,d6
		dbf	d7,.Loop1
		rts

	.table:	dc.b	'0123456789ABCDEF'
		even

StartNormal	move.w	#$2700,sr
		move.b	#'N',$200.w
		bra.s	hop
StartError	move.w	#$2700,sr
		sf	$200.w

hop:		move.l	a0,$204.w
		move.b	#1,$ffff8260.w		; MED res.
		lea	Registers(pc),a0
		move.w	(sp),(a0)+		; SR
		move.l	2(sp),(a0)+		; PC
		movem.l	d0-a7,(a0)
		cmpi.b	#'N',$200.w
		beq.s	.yes

; Rcupration du vecteur d'erreur.
		lea	StartError(pc),a1
		move.l	a1,d0
		rol.l	#8,d0
		move.b	d0,$202.w			; Numro du vecteur.
		cmpi.b	#1,d0
		bhi.s	.yes
		addq.l	#8,sp
		move.w	(sp),-6(a0)
		move.l	2(sp),-4(a0)
	.yes:

	.yes2:	move.l	$204.w,32(a0)		; Vrai "A0"
		lea	16*4(a0),a0
		move.l	usp,a1
		move.l	a1,(a0)+
		lea	MyStack(pc),sp
		lea	VariablesPC(pc),a6
		bsr	SauveContexte
		clr.b	$ffff820a.w		; 60Hz
		move.l	#$08080000,$ffff8800.w
		move.l	#$09090000,$ffff8800.w
		move.l	#$0a0a0000,$ffff8800.w
		move.l	#$0707ffff,$ffff8800.w
		bsr	SauveRAM
		bsr	SearchFree		; Cherche la place en RAM.
		bsr	SearchProcessor
		lea	VariablesPC(pc),a6
		bsr	Initialisations
 		bsr	My_ITs
		move.b	#$ff,$201.w
		clr.w	Xp(a6)
		clr.w	Yp(a6)

	; Rcupration de l'adresse vido.
		moveq	#0,d7
		move.b	OldVdh(pc),d7
		swap	d7
		move.b	OldVdm(pc),d7
		lsl.w	#8,d7
		moveq	#0,d0
		move.l	#TrueTOP-32000,d1
		bsr	Clipping
		lea	AD_Video(pc),a0
		move.l	d7,(a0)

	; Rcupration du PC prsum.
		move.l	LePC(pc),d7
		moveq	#0,d0
		move.l	#TOP-40,d1
		bsr	Clipping
		lea	RAM_Pointer(pc),a0
		move.l	d7,(a0)

		move.b	#2,$ffff820a.w	; 50Hz

		cmpi.b	#'N',$200.w
		beq	HelpPage	; Page d'aide pour commencer.
		bsr	InitREG_Display
		bra	REG_Display


;*********************************
; Dfinition des touches:	;*
KeyA	equ	$10		;*
KeyD	equ	$20		;*
KeyL	equ	$26		;*
KeyM	equ	$27		;*
KeyP	equ	$19		;*
KeyR	equ	$13		;*
KeyT	equ	$14		;*
KeyX	equ	$2d		;*
KeyAlt	equ	$38		;*
KeyUp	equ	$48		;*
KeyDown	equ	$50		;*
KeyRight =	$4d		;*
KeyLeft	equ	$4b		;*
KeyHelp	equ	$62		;*
KeyShift =	$36		;*
KeyShift2 =	$2a		;*
KeyPlus	equ	$4e		;*
KeyMoins =	$4a		;*
KeyCTRL	equ	$1d		;*
KeySpace =	57		;*
KeyBack	equ	$0e		;*
;*********************************


Cadre		; Trace un cadre 2 plans:
		; D0,D1: Xd,Yd
		; D2,D3: Xf,Yf
;		lea	TOP-32000,a1
		move.l	Ecran(pc),a1
		sub.w	d1,d3		; Delta Y
		mulu.w	#160,d1
		add.l	d1,a1
		subq.w	#(2+1),d3	; Ligne haut et bas + DBF.
		bmi	.fin
		sub.w	d0,d2		; Nb de tranches.
		lsl.w	#2,d0
		add.w	d0,a1
		move.w	d2,d0		; Nb de tranches -1
		lsl.w	#2,d0
		bsr.s	.ligne
	.Loop2:	ori.l	#$80008000,(a1)
		ori.l	#$00010001,0(a1,d0.w)
		lea	160(a1),a1
		dbf	d3,.Loop2
	.ligne:	move.w	d2,d1
		movea.l	a1,a2
	.Loop1:	move.l	#-1,(a2)+
		dbf	d1,.Loop1
		lea	160(a1),a1
	.fin:	rts

Dispatch	suba.l	a0,a0
		suba.l	a1,a1
		lea	Clavier(pc),a5
		tst.b	KeyR(a5)
		beq.s	.non01
		lea	InitREG_Display(pc),a0	; Le JSR
		lea	REG_Display(pc),a1	; Le JUMP
		bra.s	.hop
	.non01:	tst.b	KeyHelp(a5)
		beq.s	.non02
		lea	$0.w,a0
		lea	HelpPage(pc),a1		; Le JUMP
		bra.s	.hop
	.non02:	tst.b	KeyM(a5)
		beq.s	.non03
		lea	InitRAM_Display(pc),a0
		lea	RAM_Display(pc),a1
		bra.s	.hop
	.non03:	tst.b	KeyL(a5)
		beq.s	.non04
		lea	$0.w,a0
		lea	RAM_Looker(pc),a1
		bra.s	.hop
	.non04:	tst.b	KeyD(a5)
		beq.s	.non05
		lea	InitDES_Display(pc),a0
		lea	DES_Routine(pc),a1
		bra.s	.hop
	.non05:
		nop
	.hop:	cmpa.l	#0,a0
		beq.s	.bra
		pea	(a1)
		jsr	(a0)
		move.l	(sp)+,a1
	.bra:	cmpa.l	#0,a1
		beq.s	.rien
		addq.l	#4,sp			; Evite le RTS
		jmp	(a1)
	.rien:	rts

		; Recherche d'une zone de (place) octets pour y placer
		; l'cran.

SearchFree
		move.w	sr,-(sp)
		move.w	#$2700,sr
		movem.l	d0-d1/a0-a2,-(sp)
		suba.l	a0,a0
		clr.w	$ffff8240.w
		move.l	#Place,d0		; Place initiale.
		lea	((TrueTOP-Place)&-4),a1
	.Loop2:	cmpa.l	a0,a1
		beq.s	.NotFound
		not.w	$ffff8240.w
		move.l	d0,d1
		movea.l	a0,a2			; Adresse dispo.
	.Loop1:	tst.l	(a0)+
		bne.s	.Loop2
		subq.l	#4,d1
		bpl.s	.Loop1
	.Yeah:	lea	255(a2),a2
		move.l	a2,d0
		clr.b	d0
	.haha:	lea	Ecran(pc),a0
		move.l	d0,(a0)
		lea	LesOctets(pc),a0
		add.l	#32000,d0
		move.l	d0,(a0)
		lea	BufferGraphique(pc),a0
		add.l	#(256*2*8),d0
		move.l	d0,(a0)
		movem.l	(sp)+,d0-d1/a0-a2
		rte
.NotFound	movea.l	a1,a2
		bra.s	.Yeah

SearchProcessor	move.w	sr,-(sp)
		move.w	#$2700,sr
		move.l	$10.w,d7
		lea	.Back(pc),a0
		move.l	a0,$10.w
		move.l	a7,a5
		moveq	#'0',d1			; Num du processeur.
		dc.w	$42c0	; MOVE CCR,D0  P=10
		moveq	#'1',d1
		dc.w	$49c0	; EXTB.L D0   P=20
		moveq	#'2',d1
		dc.l	$4e7a0002
		bset	#9,d0
		dc.l	$4e7b0002
		dc.l	$4e7a0002
		bclr	#9,d0
		beq.s	.Back
		moveq	#'3',d1
		dc.l	$4e7b0002
	.Back:	move.l	a5,sp
		move.l	d7,$10.w
		lea	Processor(pc),a0
		move.w	d1,(a0)
		rte

;***************************************************************************
;	*********************************************************
;	*	Affichage des Registres.			*
;	*	Initialisation de l'cran.			*
;	*							*
;	*********************************************************
InitREG_Display	lea	Clavier(pc),a5
	.Waitk:	tst.b	KeyR(a5)
		bne.s	.Waitk
		bsr	MedRes
;		lea	MyPal2(pc),a0
;		lea	$ffff8240.w,a1
;		move.l	(a0)+,(a1)+
;		move.l	(a0)+,(a1)+
;		move.l	Ecran(pc),a0
;		move.w	#(32000/4)-1,d0
;		moveq	#0,d1
;	.Cls:	move.l	d1,(a0)+
;		dbf	d0,.Cls
		moveq	#3,d0
		moveq	#37,d2
		moveq	#9,d1
		move.w	#30,d3
		bsr	Cadre
		moveq	#0,d0
		moveq	#18,d2
		moveq	#42,d1
		move.w	#199,d3
		bsr	Cadre
		moveq	#20,d0
		moveq	#39,d2
		moveq	#42,d1
		move.w	#199,d3
		bsr	Cadre

		move.w	#8,Xp(a6)
		move.w	#2,Yp(a6)
		lea	.txt1(pc),a0
		bsr	Print
		move.w	#1,Xp(a6)
		move.w	#6,Yp(a6)
		lea	.txt2(pc),a0
		bsr	Print
		rts

.txt1:	dc.b	'"R"egister viewer. Press HELP for Infos.',-1
.txt2:	dc.b	'ERROR-Status:',-1
	even

;	*********************************************************
;	*							*
;	*	Code pour l'affichage des registres.		*
;	*							*
;	*********************************************************
REG_Display	move.w	#1,Xp(a6)
		move.w	#7,Yp(a6)
		cmpi.b	#'N',$200.w
		bne.s	.non0
		lea	.txt0(pc),a0
		bsr	Print
		bra	.cont
	.non0:	moveq	#0,d0
		move.b	$202.w,d0		; Numro d'exeption.
		cmpi.b	#9,d0
		bls.s	.exist
		moveq	#0,d0
	.exist:	lea	.TableTxt(pc),a1
		add.w	d0,d0
		add.w	d0,a1
		lea	.txt1(pc),a0
		add.w	(a1),a0
		bsr	Print
; Affichage des registres de D0  D7 et A0  A7
	.cont:	moveq	#1,d6
		moveq	#9,d7
		lea	D0D7(pc),a1
		move.b	#'D',d0
		bsr	PrintCol
		moveq	#18,d6
		moveq	#9,d7
		lea	A0A7(pc),a1
		move.b	#'A',d0
		bsr	PrintCol

; Affichage du registre USP
		lea	(.reg0+5)(pc),a2
		move.l	LeUSP(pc),d0
		bsr	Fill
		move.w	#17,Xp(a6)
		move.w	#17,Yp(a6)
		lea	(.reg0)(pc),a0
		bsr	Print

; Affichage du PC:
		lea	.reg11(pc),a2
		move.l	LePC(pc),d0
		bsr	Fill
		move.w	#1,Xp(a6)
		move.w	#19,Yp(a6)
		lea	.reg1(pc),a0
		bsr	Print

; Affichage du SR:
		lea	.reg21(pc),a2
		moveq	#0,d0
		move.w	LeSR(pc),d0
		bsr	Fill
		move.w	#1,Xp(a6)
		move.w	#20,Yp(a6)
		lea	.reg2(pc),a0
		bsr	Print

; Affichage du processeur
		move.w	Processor(pc),d0
		lea	.Proc1(pc),a0
		move.b	d0,(a0)
		move.w	#1,Xp(a6)
		move.w	#22,Yp(a6)
		lea	.Proc(pc),a0
		bsr	Print


; Affichage de l'adresse de relocation de RAM-Debug.
		lea	.reg31(pc),a2
		move.l	Ecran(pc),d0
		bsr	Fill
		move.w	#1,Xp(a6)
		move.w	#23,Yp(a6)
		lea	.reg3(pc),a0
		bsr	Print


	.loopf:	bsr	Vsync
		bsr	Dispatch
		bra.s	.loopf

.reg0		dc.b	'USP:$00000000',-1
.reg1		dc.b	'PC:$'
.reg11		dc.b	'00000000',-1
.reg2		dc.b	'SR:$'
.reg21		dc.b	'00000000',-1
.reg3		dc.b	'Relocation ecran RAM-Debug:$'
.reg31		dc.b	'00000000',-1
.Proc		dc.b	'Processeur trouve: MC-680'
.Proc1		dc.b	'00',-1
		even

.TableTxt	dc.w	.txt1-.txt1
		dc.w	.txt2-.txt1
		dc.w	.txt3-.txt1
		dc.w	.txt4-.txt1
		dc.w	.txt5-.txt1
		dc.w	.txt6-.txt1
		dc.w	.txt7-.txt1
		dc.w	.txt8-.txt1
		dc.w	.txt9-.txt1
		dc.w	.txt10-.txt1
.txt0	dc.b	'Interruption manuelle.',-1
.txt1	dc.b	'$08 Erreur BUS.',-1			00
.txt2	dc.b	'$0C Adresse IMPAIR.',-1		01
.txt3	dc.b	'$10 Instruction ILLEGAL.',-1		02
.txt4	dc.b	'$14 Division par ZERO',-1		03
.txt5	dc.b	'$18 Instruction CHK',-1		04
.txt6	dc.b	'$1C Instruction TRAPV',-1		05
.txt7	dc.b	'$20 Violation Privilege',-1		06
.txt8	dc.b	'$24 Exception TRACE',-1		07
.txt9	dc.b	'$28 Line A',-1				08
.txt10	dc.b	'$2C Line F',-1				09
		even

PrintCol	moveq	#7,d5		; 8 registres
		lea	.provis1(pc),a0
		move.b	d0,(a0)
		move.b	#'0',1(a0)
	.loop1:	move.l	(a1)+,d0
		lea	.provis2(pc),a2
		bsr	Fill
		move.w	d6,Xp(a6)
		move.w	d7,Yp(a6)
		lea	.provis1(pc),a0
		bsr	Print
		addq.b	#1,1(a0)
		addq.w	#1,d7
		dbf	d5,.loop1
		rts

.provis1	dc.b	'D0:$'
.provis2	dc.b	'00000000',-1
		even

Fill		moveq	#7,d2
	.loop2:	moveq	#$f,d1
		rol.l	#4,d0
		and.l	d0,d1
		move.b	.table(pc,d1.w),(a2)+
		dbf	d2,.loop2
		rts
.table:		dc.b	'0123456789ABCDEF'
		even

;***************************************************************************
;	*********************************************************
;	*	Affichage de la RAM				*
;	*	Initialisation de l'cran.			*
;	*							*
;	*********************************************************
InitRAM_Display	lea	Clavier(pc),a5
	.Waitk:	tst.b	KeyM(a5)
		bne.s	.Waitk
		clr.b	$fffffa1b.w
		bsr	MedRes
		lea	MyPal2(pc),a0
		lea	$ffff8240.w,a1
		move.l	(a0)+,(a1)+
		move.l	(a0)+,(a1)+
		move.l	Ecran(pc),a0
		move.w	#(32000/4)-1,d0
		moveq	#0,d1
	.Cls:	move.l	d1,(a0)+
		dbf	d0,.Cls
		moveq	#3,d0
		moveq	#37,d2
		moveq	#9,d1
		move.w	#30,d3
		bsr	Cadre
		moveq	#0,d0
		moveq	#39,d2
		moveq	#52,d1
		move.w	#199,d3
		bsr	Cadre
		move.w	#8,Xp(a6)
		move.w	#2,Yp(a6)
		lea	.txt1(pc),a0
		bsr	Print

		moveq	#2,d6
		moveq	#8,d7
		moveq	#15,d5
	.loop:	move.w	d6,Xp(a6)
		move.w	d7,Yp(a6)
		lea	.txt2(pc),a0
		movem.w	d5-d7,-(sp)
		bsr	Print
		movem.w	(sp)+,d5-d7
		addq.w	#1,d7
		dbf	d5,.loop
		bsr	Initialisations
		rts
.txt1:	dc.b	'"M"emory viewer. Use arrows keys, shift and CONTROL to scroll.',-1
.txt2:	dc.b	'$',-1
	even
MyPal2		dc.w	$000,$777,$047,CoulCadre

;	*********************************************************
;	*							*
;	*	Code pour l'affichage de la RAM.		*
;	*							*
;	*********************************************************
RAM_Display	bsr	Vsync
		bsr	Dispatch

		bsr	Put_RAM_Page

		move.l	RAM_Pointer(pc),d7	; Position en RAM
		moveq	#0,d0			; Dplacement
		moveq	#1,d1			; Multiplicateur.

		lea	Clavier(pc),a5
		tst.b	KeyA(a5)
		beq.s	.non00
		bsr	GetNumber
		bra.s	RAM_Display
	.non00:	tst.b	KeyT(a5)
		beq.s	.non0
		not.b	$201.w			; VRAIE-Mmoire.
	.non0:	tst.b	KeyShift(a5)
		beq.s	.non1
		move.w	#16,d1			; Mutiplicateur sur 16
	.non1:	tst.b	KeyShift2(a5)
		beq.s	.non11
		move.w	#16,d1			; Mutiplicateur sur 16
	.non11:	tst.b	KeyUp(a5)
		beq.s	.non2
		add.w	#-16,d0
	.non2:	tst.b	KeyDown(a5)
		beq.s	.non3
		add.w	#16,d0
	.non3:	tst.b	KeyLeft(a5)
		beq.s	.non4
		add.w	#-1,d0
	.non4:	tst.b	KeyRight(a5)
		beq.s	.non5
		add.w	#1,d0
	.non5:	tst.b	KeyCTRL(a5)
		beq.s	.non6
		move.w	#512,d1
	.non6:
		muls.w	d1,d0			; Dplacement * Multi.
		add.l	d0,d7			; Nouvelle position.

		moveq	#0,d0		; Borne infrieure
		move.l	#TOP-256,d1	; Borne suprieure.
		bsr	Clipping	; Clippe D7
		lea	RAM_Pointer(pc),a0
		move.l	d7,(a0)

;		lea	TOP-32000,a1
		move.l	Ecran(pc),a1
		lea	160*187+132(a1),a1
		moveq	#$f,d0
		and.b	$201.w,d0
		move.b	d0,(a1)
		move.b	d0,160(a1)
		move.b	d0,320(a1)
		move.b	d0,480(a1)
		bra	RAM_Display


Put_RAM_Page	move.l	RAM_Pointer(pc),a4
		move.l	Ecran(pc),a1
		move.l	LesOctets(pc),a2
		lea	8*160*8(a1),a1
		moveq	#15,d7			; 16 lignes
	.Loop1: lea	8+2(a1),a0
		move.l	a4,d0
		bsr	PrintLong		; Affichage de l'adresse.
		moveq	#15,d1			; 16 colonnes.
		lea	28(a1),a0
		lea	68(a0),a5
		move.l	#$fffe0002,d2
		move.l	#$00030001,d3
	.Loop2:	moveq	#0,d0
		move.b	(a4)+,d0		; Lecture de l'octet.
		tst.b	$201.w
		beq.s	.ok0
		cmp.l	#$201,a4
		bhi.s	.ok0
		lea	LowRAM(pc),a3
		add.l	a4,a3
		move.b	-1(a3),d0
	.ok0:
		lsl.w	#4,d0
		lea	0(a2,d0.w),a3
		move.w	(a3)+,(a0)
i		set	160
		rept	7
		move.w	(a3)+,i(a0)
i		set	i+160
		endr
		addq.w	#4,a0
		add.w	d2,a0
		swap	d2

		lea	Font88(pc),a3
		lsr.w	#4,d0

		cmpi.b	#' ',d0
		bhs.s	.ok1
		move.b	#'.',d0
	.ok1:	cmpi.b	#'z',d0
		bls.s	.ok2
		move.b	#'.',d0
	.ok2:
;		cmpi.b	#'q',d0
;		blo.s	.ok3
;		subq.w	#1,d0
;	.ok3:
		subi.w	#32,d0
		lsl.w	#3,d0

		add.w	d0,a3
		move.b	(a3)+,(a5)
i		set	160
		rept	7
		move.b	(a3)+,i(a5)
i		set	i+160
		endr
		add.w	d3,a5
		swap	d3

		dbf	d1,.Loop2

		lea	8*160(a1),a1
;		lea	16(a4),a4
		dbf	d7,.Loop1
		rts

Clipping	; En entre: D7 donne  clipper.
		;            D0-D1: Bornes.
		tst.l	d7
		bpl.s	.ok0
		moveq	#0,d7
	.ok0:	cmp.l	d0,d7
		bhs.s	.ok1			; Op2>=Op1
		move.l	d0,d7
	.ok1:	cmp.l	d1,d7			; Op2<=Op1
		bls.s	.ok2
		move.l	d1,d7
	.ok2:	rts

;*****************************************************************************
;	*********************************************************
;	*							*
;	*	Code pour la page d'aide.			*
;	*							*
;	*********************************************************
HelpPage	lea	Clavier(pc),a5
	.Waitk:	tst.b	KeyHelp(a5)
		bne.s	.Waitk
	.Help:	bsr	MedRes
		move.w	#1,Xp(a6)
		clr.w	Yp(a6)
		lea	.txt1(pc),a0
		bsr	Print
		move.w	#1,Xp(a6)
		move.w	#8,Yp(a6)
		lea	.txt2(pc),a0
		bsr	Print

	.Loop:	bsr	Vsync
		bsr	Dispatch
		lea	Clavier(pc),a5
		tst.b	KeySpace(a5)
		beq.s	.Loop
	.Loop2:	tst.b	KeySpace(a5)
		bne.s	.Loop2

		bsr	MedRes
		move.w	#1,Xp(a6)
		clr.w	Yp(a6)
		lea	.txt3(pc),a0
		bsr	Print

	.Loop3:	bsr	Vsync
		bsr	Dispatch
		lea	Clavier(pc),a5
		tst.b	KeySpace(a5)
		beq.s	.Loop3
	.Loop4:	tst.b	KeySpace(a5)
		bne.s	.Loop4
		bra	.Help

.txt1:	dc.b	'            ****************************************************',10
	dc.b	'            *                                                  *',10
	dc.b	'            *              "DD" v3.1 (Demo-Debug)              *',10
	dc.b	'            *             Code by Leonard / OXYGENE.           *',10
	dc.b	'            *                                                  *',10
	dc.b	'            ****************************************************',-1

.txt2:	dc.b	'Welcome in the "DD" v3.1. This demo-debugger contains:',10
	dc.b	'  - An ASCCI "M"emory-Viewer.',10
	dc.b	'  - A Graphic RAM-"L"ooker.',10
	dc.b	'  - A "R"egisters displayer.',10
	dc.b	'  - An MC-68000 "D"esassembler.',10,10
	dc.b	'This utility was especially developped for the acheivement of this demo.',10
	dc.b	'It was written with a powerfull SYSTEM (Who works with GEM when we  code',10
	dc.b	'screens) wich is included in that demo. The SYSTEM  ( File  loader, Demo',10
	dc.b	'installator, "DD" 3.1 and Packer) was develloped by OXYGENE.',10
	dc.b	'If you are interrested by talking about it, or if you want to send  some',10
	dc.b	'donations, write to:',10,10
	dc.b	'                            OXYGENE,',10
	dc.b	'                        22 Rue JEAN MERMOZ,',10
	dc.b	'                   91700 STE-GENEVIEVE des BOIS.',10
	dc.b	'                             FRANCE.                    (Space for next)'
	dc.b	-1

.txt3:	dc.b	'If the "DD" is appared by a manual interrupt, the  demo  can  be  executed',10
	dc.b	'again, just press ALTERNATE-X !!!',10,10
	dc.b	'"DD" controls:',10
	dc.b	'--------------',10,10
	dc.b	'"M"emory assci viewer:',10
	dc.b	'    Use arrows to scroll, SHIFT or CNTRL to make  faster. The',10
	dc.b	'    "T" key toggle RAM between $0 and $200. (RAM before "DD" and "DD" RAM.',10
	dc.b	'    "A" to go to "A"dress.',10
	dc.b	'"L"ooker. (Graphics.)',10
	dc.b	'    This mode show you Memory as Graphic-page.',10
	dc.b	'    Use the cursor keys to scroll, SHIFT to make faster.  STE  owners  can',10
	dc.b	'    move screen 2bytes by 2bytes. "P" to toggle palette.',10
	dc.b	'"R"egisters-Display.',10
	dc.b	'    You can see registers-status before ERROR or Manual-Interrupt.The "DD"',10
	dc.b	'    tell you the ERROR type. (BUS, ILLEG etc...)',10
	dc.b	'"D"esassembler.',10
	dc.b	'    This is a true and powerfull 68000 desassembler. You  can  use  arrows',10
	dc.b	'    to scroll (as always SHIFT to make it faster) and "A" to set Adress.',10,10
	dc.b	'            And now press "D","L","M","R",HELP or ALTERNATE-X...'
	dc.b	-1
	even

;	*********************************************************
;	*							*
;	*	Code pour le looker de RAM.			*
;	*							*
;	*********************************************************
RAM_Looker	lea	Clavier(pc),a5
	.Wait:	tst.b	KeyL(a5)
		bne.s	.Wait
		clr.b	$fffffa1b.w
		bsr	LowRes
		lea	PalType(pc),a0
		clr.b	(a0)

	.Loop:	bsr	Vsync
		bsr	Dispatch
		move.l	AD_Video(pc),d7
		move.l	d7,d0
		lsr.w	#8,d0
		move.l	d0,$ffff8200.w
		move.b	d7,$ffff820d.w

		moveq	#0,d0
		moveq	#1,d1
		lea	Clavier(pc),a5
		tst.b	KeyP(a5)
		beq.s	.non0
		lea	PalType(pc),a0
		not.b	(a0)
		clr.b	KeyP(a5)
	.non0:	tst.b	KeyShift(a5)
		beq.s	.non1
		moveq	#16,d1			; Mutiplicateur sur 16
	.non1:	tst.b	KeyShift2(a5)
		beq.s	.non11
		moveq	#16,d1			; Mutiplicateur sur 16
	.non11:	tst.b	KeyUp(a5)
		beq.s	.non2
		add.w	#-160*8,d0
	.non2:	tst.b	KeyDown(a5)
		beq.s	.non3
		add.w	#160*8,d0
	.non3:	tst.b	KeyLeft(a5)
		beq.s	.non4
		add.w	#-2,d0
	.non4:	tst.b	KeyRight(a5)
		beq.s	.non5
		add.w	#2,d0
	.non5:
		muls.w	d1,d0			; Dplacement * Multi.
		add.l	d0,d7			; Nouvelle position.
	; Clippe D7.
		moveq	#0,d0
		move.l	#TrueTOP-32000,d1
		bsr	Clipping
		lea	AD_Video(pc),a0
		move.l	d7,(a0)

		lea	OldPal(pc),a2
		lea	PalType(pc),a0
		tst.b	(a0)
		beq.s	.old
		lea	PalSys(pc),a2
	.old:	movea.w	#$8240,a1
		moveq	#7,d0
	.loopp:	move.l	(a2)+,(a1)+
		dbf	d0,.loopp
		bra	.Loop


PrintAdresse	; En entre: A0 pointe sur cran
		; 	     D0 est l'adresse  afficher.


PrintLong	; En entre: A0: Pointe sur l'cran.
		;  	     D0: Adresse  afficher.
		movem.l	d1-d3/a1,-(sp)
		moveq	#7,d1
		move.l	#$00030001,d3
	.Loop1:	moveq	#$f,d2
		rol.l	#4,d0
		and.w	d0,d2
		move.b	.table(pc,d2.w),d2
		subi.b	#32,d2
		lea	Font88(pc),a1
		lsl.w	#3,d2
		add.w	d2,a1
		move.b	(a1)+,(a0)
i		set	160
		rept	7
		move.b	(a1)+,i(a0)
i		set	i+160
		endr
		add.w	d3,a0
		swap	d3
		dbf	d1,.Loop1
		movem.l	(sp)+,d1-d3/a1
		rts

	.table:	dc.b	'0123456789ABCDEF'
		even
.provis		dc.b	'$'
.provis2	dc.b	'00000000',-1,-1
		even


;	*********************************************************
;	*	Affichage de l'ecran Debugger.			*
;	*	Initialisation de l'cran.			*
;	*							*
;	*********************************************************
InitDES_Display	lea	Clavier(pc),a5
	.Waitk:	tst.b	KeyD(a5)
		bne.s	.Waitk
		bsr	MedRes
		moveq	#0,d0
		moveq	#39,d2
		moveq	#4,d1
		moveq	#20,d3
		bsr	Cadre
		moveq	#0,d0
		moveq	#39,d2
		moveq	#23,d1
		move.w	#199,d3
		bsr	Cadre
		move.w	#8,Xp(a6)
		move.w	#1,Yp(a6)
		lea	.txt1(pc),a0
		bsr	Print
		bsr	Initialisations
		lea	RAM_Pointer(pc),a0
		move.l	(a0),d0
		bclr.l	#0,d0
		move.l	d0,(a0)
		lea	TailleInstruction(pc),a0	; Implicitement
		move.w	#2,(a0)				; on descend de 2
		rts					; octets.
.txt1:	dc.b	'MC68000 "D"esassembleur v1.0 by Leonard / OXYGENE.',-1
	even


;************************************************************************
;************************************************************************
;************************************************************************
;******								  ******
;******								  ******
;******								  ******
;******								  ******
;******								  ******
;******								  ******
;************************************************************************
;************************************************************************
;************************************************************************


DES_Routine
		bsr	DisasemblePage
	.LoopM:	moveq	#0,d3
		bsr	Dispatch
		move.l	RAM_Pointer(pc),d7	; Position en RAM
		moveq	#0,d0			; Dplacement
		moveq	#1,d1			; Multiplicateur.
		lea	Clavier(pc),a5
		tst.b	KeyA(a5)
		beq.s	.non0
		bsr	GetNumber
		lea	RAM_Pointer(pc),a0
		andi.l	#-2,(a0)
		bra.s	DES_Routine
	.non0:	tst.b	KeyShift(a5)
		beq.s	.non1
		add.w	#16,d1			; Mutiplicateur sur 16
	.non1:	tst.b	KeyShift2(a5)
		beq.s	.non11
		add.w	#16,d1			; Mutiplicateur sur 16
	.non11:	tst.b	KeyUp(a5)
		beq.s	.non2
		subq.w	#4,d0
		moveq	#-1,d3
	.non2:	tst.b	KeyDown(a5)
		beq.s	.non3
		add.w	TailleInstruction(pc),d0
		moveq	#-1,d3
	.non3:	tst.b	KeyRight(a5)
		beq.s	.non4
		addq.w	#2,d0
		moveq	#-1,d3
	.non4:	tst.b	KeyLeft(a5)
		beq.s	.non5
		subq.w	#2,d0
		moveq	#-1,d3
	.non5:	tst.b	KeyCTRL(a5)
		beq.s	.non6
		add.w	#512,d1
	.non6:	muls.w	d1,d0			; Dplacement * Multi.
		add.l	d0,d7			; Nouvelle position.
		moveq	#0,d0			; Borne infrieure
		move.l	#TOP-2,d1		; Borne suprieure.
		bsr	Clipping		; Clippe D7
		lea	RAM_Pointer(pc),a0
		move.l	d7,(a0)
		tst.l	d3
		beq	.LoopM
		bra	DES_Routine

DisasemblePage
		move.w	#20,-(sp)		; Nb de lignes
		move.w	#4,Yp(a6)
		move.l	RAM_Pointer(pc),a0	; Pointeur sur le code.
		lea	String(pc),a5		; Pointeur en sortie.
		clr.w	Flag1(a6)
	.Loop:	move.l	a0,d7
		bsr	Sort32First
		bsr	Tab
		move.w	(a0)+,d0		; Premier mot.
		move.w	#2,MaTaille(a6)
		bsr	DesassembleLine
		move.b	#10,(a5)+
		tst.w	Flag1(a6)
		bne.s	.non
		move.l	RAM_Pointer(pc),d0
		sub.l	a0,d0
		neg.l	d0
		lea	TailleInstruction(pc),a1
		move.w	d0,(a1)
		move.w	#-1,Flag1(a6)
	.non:	subq.w	#1,(sp)
		bne.s	.Loop
		addq.w	#2,sp
		move.b	#-1,(a5)
		move.l	Ecran(pc),a1
		move.w	#(20*8)-1,d1
		lea	4*8*160(a1),a1
		moveq	#0,d0
	.Loop0:
i		set	8*4
		rept	24
		move.w	d0,i(a1)
i		set	i+4
		endr
		lea	160(a1),a1
		dbf	d1,.Loop0
		move.w	#1,Xp(a6)
		move.w	#4,Yp(a6)
		lea	String(pc),a0
		bra	Print

NbLigne		dc.w	0
String		dcb.b	40*20,' '
		even

DesassembleLine
	; Premire tape: Dispatch selon le code opratoire.
	; (Livre SYBEX page 119)
		move.w	d0,d1
		andi.w	#%1111000000000000,d1
		rol.w	#6,d1
		jmp	.Bras(pc,d1.w)
	.Bras:	bra	ManipulationDeBit	0000	*
		bra	LesMOVEs		0001	*
		bra	LesMOVEs		0010	*
		bra	LesMOVEs		0011	*
		bra	AutresInstructions	0100	*
		bra	Quick_Scc_DBcc		0101	*
		bra	Bcc_BSR			0110	*
		bra	InstMoveq		0111	*
		bra	OR_DIV_SBCD		1000	*
		bra	SUB_SUBX		1001	*
		bra	NotUsed			1010	*
		bra	CMP_EOR			1011	*
		bra	AND_MUL_ABCD_EXG	1100	*
		bra	ADD_ADDX		1101	*
		bra	Rotations		1110	*
		bra	NotUsed			1111	*

NotUsed
NotFound	lea	.TestDC(pc),a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	d0,d7
		bra	Sort16

.TestDC		dc.b	'DC.W '
		even


;**********************************************************************
;
;	******  ******  ******  ******
;	**  **  **  **  **  **  **  **
;	**  **  **  **  **  **  **  **
;	**  **  **  **  **  **  **  **
;	******  ******  ******  ******

ManipulationDeBit
		lea	.Table(pc),a1
		bra	Menu
	.Table:
		dc.w	%1111111111111111,%0000001000111100
		dc.w	InstANDI_To_CCR-s
		dc.b	'ANDI    '
		dc.w	%1111111111111111,%0000001001111100
		dc.w	InstANDI_To_SR-s
		dc.b	'ANDI    '
		dc.w	%1111000100111000,%0000000100001000
		dc.w	InstMOVEP-s
		dc.b	'MOVEP   '
		dc.w	%1111111100000000,%0000011000000000
		dc.w	InstADDI-s
		dc.b	'ADDI    '
		dc.w	%1111111100000000,%0000001000000000
		dc.w	InstANDI-s
		dc.b	'ANDI    '
		dc.w	%1111111111000000,%0000100001000000
		dc.w	InstBCHG_AE-s
		dc.b	'BCHG    '
		dc.w	%1111000111000000,%0000000101000000
		dc.w	InstBCHG_Dn-s
		dc.b	'BCHG    '
		dc.w	%1111111111000000,%0000100010000000
		dc.w	InstBCLR_AE-s
		dc.b	'BCLR    '
		dc.w	%1111000111000000,%0000000110000000
		dc.w	InstBCLR_Dn-s
		dc.b	'BCLR    '
		dc.w	%1111111111000000,%0000100011000000
		dc.w	InstBSET_AE-s
		dc.b	'BSET    '
		dc.w	%1111000111000000,%0000000111000000
		dc.w	InstBSET_Dn-s
		dc.b	'BSET    '
		dc.w	%1111111111000000,%0000100000000000
		dc.w	InstBTST_AE-s
		dc.b	'BTST    '
		dc.w	%1111000111000000,%0000000100000000
		dc.w	InstBTST_Dn-s
		dc.b	'BTST    '
		dc.w	%1111111100000000,%0000110000000000
		dc.w	InstCMPI-s
		dc.b	'CMPI    '
		dc.w	%1111111100000000,%0000101000000000
		dc.w	InstEORI-s
		dc.b	'EORI    '
		dc.w	%1111111100000000,%0000000000000000
		dc.w	InstORI-s
		dc.b	'ORI     '
		dc.w	%1111111100000000,%0000010000000000
		dc.w	InstSUBI-s
		dc.b	'SUBI    '
	;EORI_To_CCR
	;EORI_To_SR
	;ORI_To_CCR
	;ORI_To_SR
		dc.b	'LEO!'
		even



Menu
	.Loop:	move.w	d0,d1
		and.w	(a1)+,d1
		cmp.w	(a1)+,d1
		beq.s	.Find
		lea	14-4(a1),a1
		cmpi.l	#'LEO!',(a1)
		bne.s	.Loop
		bra	NotFound
	.Find:	move.w	(a1)+,d1
		jmp	0(a6,d1.w)


InstORI
InstSUBI
InstEORI
InstCMPI
InstANDI
InstADDI	movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		cmpi.w	#1,MaTaille(a6)
		beq.s	.PointB
		cmpi.w	#2,MaTaille(a6)
		beq.s	.PointW
		move.l	(a0)+,d7
		bsr	Sort32Imm
		bra.s	.Suite
.PointB		move.w	(a0)+,d7
		bsr	Sort8Imm
		bra.s	.Suite
.PointW		move.w	(a0)+,d7
		bsr	Sort16Imm
	.Suite:	move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstBCLR_AE
InstBSET_AE
InstBTST_AE
InstBCHG_AE	movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	#1,MaTaille(a6)
		move.w	(a0)+,d7
		bsr	Sort8Imm
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstBCLR_Dn
InstBSET_Dn
InstBTST_Dn
InstBCHG_Dn	movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	#4,MaTaille(a6)
		moveq	#9,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstMOVEP	movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleEXT
		btst	#7,d0
		beq	.M_To_R
		moveq	#9,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		move.w	(a0)+,d7
		bsr	Sort16
		moveq	#0,d6
		bra	Mode_AN
.M_To_R:	move.w	(a0)+,d7
		bsr	Sort16
		moveq	#0,d6
		bsr	Mode_AN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN



InstANDI_To_CCR
InstANDI_To_SR

		bra	NotFound

;***************************************************************

LesMOVEs	move.w	d0,d1
		lsr.w	#6,d1
		andi.w	#%111,d1
		cmpi.w	#%1,d1
		beq	InstMOVEA
		lea	.TextMove(pc),a3
		bsr	SortSansEspace
		moveq	#12,d6
		bsr	TailleMOVE
		moveq	#0,d6
		move.w	#%111111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#6,d6
		move.w	#%101111111000,d5
		bra	RModeAdressage
.TextMove	dc.b	'MOVE '
		even

InstMOVEA	lea	.TextMOVEA(pc),a3
		bsr	SortSansEspace
		moveq	#12,d6
		bsr	TailleMOVE
		moveq	#0,d6
		move.w	#%111111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeAN
.TextMOVEA	dc.b	'MOVEA '
		even

;*****************************************************************
;								*
;	******    **  ******  ******				*
;	**  **  ****  **  **  **  **				*
;	**  **    **  **  **  **  **				*
;	**  **    **  **  **  **  **				*
;	******    **  ******  ******				*

AutresInstructions
		lea	.Table(pc),a1
		bra	Menu
	.Table:	dc.w	%1111111111111111,$4E71
		dc.w	InstDirect-s
		dc.b	'NOP     '
		dc.w	%1111111111111111,$4AFC
		dc.w	InstDirect-s
		dc.b	'ILLEGAL '
		dc.w	%1111111111111111,%0100111001110000
		dc.w	InstDirect-s
		dc.b	'RESET   '
		dc.w	%1111111111111111,$4E73
		dc.w	InstDirect-s
		dc.b	'RTE     '
		dc.w	%1111111111111111,%0100111001110111
		dc.w	InstDirect-s
		dc.b	'RTR     '
		dc.w	%1111111111111111,$4E75
		dc.w	InstDirect-s
		dc.b	'RTS     '
		dc.w	%1111111111111111,%0100111001110010
		dc.w	InstSTOP-s
		dc.b	'STOP    '
		dc.w	%1111111111111111,%0100111001110110
		dc.w	InstDirect-s
		dc.b	'TRAPV   '
		dc.w	%1111111111111000,%0100111001010000
		dc.w	InstLINK-s
		dc.b	'LINK    '
		dc.w	%1111111111111000,%0100111001011000
		dc.w	InstUNLK-s
		dc.b	'UNLK    '
		dc.w	%1111111111111000,%0100100001000000
		dc.w	InstSWAP-s
		dc.b	'SWAP    '
		dc.w	%1111111111110000,%0100111001100000
		dc.w	InstMOVE_USP-s
		dc.b	'MOVE.L  '
		dc.w	%1111111111110000,%0100111001000000
		dc.w	InstTRAP-s
		dc.b	'TRAP    '
		dc.w	%1111111110111000,%0100100010000000
		dc.w	InstEXT-s
		dc.b	'EXT     '
		dc.w	%1111111111000000,%0100000011000000
		dc.w	InstMOVE_From_SR-s
		dc.b	'MOVE.W  '
		dc.w	%1111111111000000,%0100011011000000
		dc.w	InstMOVE_To_SR-s
		dc.b	'MOVE.W  '
		dc.w	%1111111111000000,%0100010011000000
		dc.w	InstMOVE_To_CCR-s
		dc.b	'MOVE.W  '
		dc.w	%1111111111000000,%0100111010000000
		dc.w	InstJSR-s
		dc.b	'JSR     '
		dc.w	%1111000111000000,%0100000110000000
		dc.w	InstCHK-s
		dc.b	'CHK.W   '
		dc.w	%1111111111000000,%0100111011000000
		dc.w	InstJUMP-s
		dc.b	'JMP     '
		dc.w	%1111111111000000,%0100100000000000
		dc.w	InstNBCD-s
		dc.b	'NBCD.B  '
		dc.w	%1111111111000000,%0100100001000000
		dc.w	InstPEA-s
		dc.b	'PEA     '
		dc.w	%1111111111000000,%0100101011000000
		dc.w	InstTAS-s
		dc.b	'TAS.B   '
		dc.w	%1111000111000000,%0100000111000000
		dc.w	InstLEA-s
		dc.b	'LEA     '
		dc.w	%1111111100000000,%0100001000000000
		dc.w	InstCLR-s
		dc.b	'CLR     '
		dc.w	%1111111100000000,%0100010000000000
		dc.w	InstNEG-s
		dc.b	'NEG     '
		dc.w	%1111111100000000,%0100000000000000
		dc.w	InstNEGX-s
		dc.b	'NEGX    '
		dc.w	%1111111100000000,%0100011000000000
		dc.w	InstNOT-s
		dc.b	'NOT     '
		dc.w	%1111111100000000,%0100101000000000
		dc.w	InstTST-s
		dc.b	'TST     '
	; MOVEMs
		dc.w	%1111101110000000,%0100100010000000
		dc.w	InstMOVEM-s
		dc.b	'MOVEM   '
		dc.b	'LEO!'

InstMOVEM	move.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleEXT
		move.w	(a0)+,MasqueMOVEM(a6)
		btst.l	#10,d0
		beq	MOVEM_Reg_Mem

MOVEM_Mem_Reg	moveq	#0,d6
		move.w	#%001101111110,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		move.w	MasqueMOVEM(a6),d7
		bra	ListeRegistre

MOVEM_Reg_Mem	move.w	MasqueMOVEM(a6),d7
		move.w	d0,d1
		lsr.w	#3,d1
		andi.w	#%111,d1	; Mode
		cmpi.w	#%100,d1	; Mode -(An) ??
		bne.s	.ok
		bsr	ReverseD7
	.ok:	bsr	ListeRegistre
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%001011111000,d5
		bra	ModeAdressage

ReverseD7	move.w	d7,d6
		moveq	#0,d7
		moveq	#15,d1
	.Loop1:	lsr.w	#1,d6
		addx.w	d7,d7
		dbf	d1,.Loop1
		rts

ListeRegistre	lea	.Registres(pc),a2
		moveq	#0,d1		; Position
		moveq	#0,d2		; Nb regs.
		moveq	#17-1,d3	; Nb loop
	.Loop:	lsr.w	#1,d7
		bcc.s	.NoReg
		tst.w	d2
		bne.s	.yes
		move.w	d1,d4
	.yes:	addq.w	#1,d2		; Un reg de plus
		bra.s	.Dbf
	.NoReg:	tst.w	d2		; Pas de registres ??
		beq.s	.Dbf
		move.b	0(a2,d4.w),(a5)+
		move.b	1(a2,d4.w),(a5)+
		cmpi.w	#1,d2
		bne.s	.Plus
		move.b	#'/',(a5)+
		bra.s	.ret
	.Plus:	move.b	#'-',(a5)+
		subq.w	#1,d2
		add.w	d2,d2
		add.w	d4,d2
		move.b	0(a2,d2.w),(a5)+
		move.b	1(a2,d2.w),(a5)+
		move.b	#'/',(a5)+
	.ret:	moveq	#0,d2
	.Dbf:	addq.w	#2,d1		; Position + 2
		dbf	d3,.Loop
		subq.l	#1,a5
		rts

.Registres	dc.b	'D0D1D2D3D4D5D6D7A0A1A2A3A4A5A6A7'
		even

InstDirect	move.l	a1,a3
		bra	SortSansEspace

InstMOVE_USP	move.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		btst	#3,d0
		beq.s	.A_USP
		move.b	#'U',(a5)+
		move.b	#'S',(a5)+
		move.b	#'P',(a5)+
		move.b	#',',(a5)+
		moveq	#0,d6
		bra	ModeAN
	.A_USP:	moveq	#0,d6
		bsr	ModeAN
		move.b	#',',(a5)+
		move.b	#'U',(a5)+
		move.b	#'S',(a5)+
		move.b	#'P',(a5)+
		rts

InstMOVE_From_SR
		move.w	#2,MaTaille(a6)
		movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.b	#'S',(a5)+
		move.b	#'R',(a5)+
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstMOVE_To_SR	move.w	#2,MaTaille(a6)
		movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#0,d6
		move.w	#%101111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		move.b	#'S',(a5)+
		move.b	#'R',(a5)+
		rts

InstMOVE_To_CCR	move.w	#2,MaTaille(a6)
		movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#0,d6
		move.w	#%101111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		move.b	#'C',(a5)+
		move.b	#'C',(a5)+
		move.b	#'R',(a5)+
		rts


InstCHK		move.w	#2,MaTaille(a6)
		movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#0,d6
		move.w	#%001001111110,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeAN

InstCLR		movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage


InstEXT		movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleEXT
		moveq	#0,d6
		bra	ModeDN

InstJSR
InstPEA
InstJUMP
		movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	#4,MaTaille(a6)
		moveq	#0,d6
		move.w	#%001001111110,d5
		bra	ModeAdressage


InstNBCD	movea.l	a1,a3
		bsr	SortSansEspace
		move.w	#1,MaTaille(a6)
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstNEGX
InstNOT
InstTST
InstNEG
		movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage


InstLEA		move.w	#4,MaTaille(a6)
		movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#0,d6
		move.w	#%001001111110,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeAN

InstLINK	move.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#0,d6
		bsr	ModeAN
		move.b	#',',(a5)+
		move.w	(a0)+,d7
		bra	Sort16Imm

InstUNLK	move.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#0,d6
		bra	ModeAN

InstSTOP	move.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	(a0)+,d7
		bra	Sort16Imm


InstSWAP	move.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#0,d6			; Bit 0 pour le registre.
		bra	ModeDN

InstTAS		move.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	#1,MaTaille(a6)
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstTRAP	move.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		moveq	#%1111,d7
		and.w	d0,d7
		bra	Sort8Imm

;*****************************************************************
;
;	******    **      **    ******
;	**  **  ****    ****    **  **
;	**  **    **      **    **  **
;	**  **    **      **    **  **
;	******  ******  ******  ******

Bcc_BSR		lea	.Table(pc),a1
		bra	Menu

	.Table:
		dc.w	%1111111100000000,%0110000000000000
		dc.w	InstBRA-s
		dc.b	'BRA     '
		dc.w	%1111111100000000,%0110000100000000
		dc.w	InstBSR-s
		dc.b	'BSR     '
		dc.w	%1111000000000000,%0110000000000000
		dc.w	InstBCC-s
		dc.b	'BCC     '
		dc.b	'LEO!'

InstBSR
InstBRA		movea.l	a1,a3
		bsr	SortSansEspace
		tst.b	d0
		beq.s	.Long
		move.b	#'.',(a5)+
		move.b	#'S',(a5)+
		bsr	Tab
		move.b	d0,d7
		ext.w	d7
		ext.l	d7
		add.l	a0,d7
		bra	Sort32
	.Long:	bsr	Tab
		move.w	(a0)+,d7
		ext.l	d7
		add.l	a0,d7
		subq.l	#2,d7
		bra	Sort32

InstBCC		move.b	#'B',(a5)+
		tst.b	d0
		beq.s	.Long
	.Short:	move.b	d0,d7
		ext.w	d7
		ext.l	d7
		add.l	a0,d7
		bra.s	.Ok
	.Long:	move.w	(a0)+,d7
		ext.l	d7
		add.l	a0,d7
		subq.l	#2,d7
	.Ok:	moveq	#8,d6
		bsr.s	Condition
		tst.b	d0
		beq.s	.non
		move.b	#'.',(a5)+
		move.b	#'S',(a5)+
	.non:	bsr	Tab
		bra	Sort32

Condition	move.w	d0,d1
		lsr.w	d6,d1
		andi.w	#%1111,d1
		add.w	d1,d1
		lea	.Table(pc,d1.w),a1
		move.b	(a1)+,(a5)+
		cmpi.b	#' ',(a1)
		beq.s	.ok
		move.b	(a1)+,(a5)+
	.ok:	rts
.Table		dc.b	'T ','F ','HI','LS'
		dc.b	'CC','CS','NE','EQ'
		dc.b	'VC','VS','PL','MI'
		dc.b	'GE','LT','GT','LE'
		even


;*****************************************************************
;
;	******    **    ******    **
;	**  **  ****    **  **  ****
;	**  **    **    **  **    **
;	**  **    **    **  **    **
;	******  ******  ******  ******

Quick_Scc_DBcc	lea	.Table(pc),a1
		bra	Menu

	.Table:	dc.w	%1111000011111000,%0101000011001000
		dc.w	InstDBcc-s
		dc.b	'Leonard!'
		dc.w	%1111000011000000,%0101000011000000
		dc.w	InstScc-s
		dc.b	'Leonard!'
		dc.w	%1111000100000000,%0101000000000000
		dc.w	InstADDQ-s
		dc.b	'ADDQ    '
		dc.w	%1111000100000000,%0101000100000000
		dc.w	InstSUBQ-s
		dc.b	'SUBQ    '
		dc.b	'LEO!'

InstDBcc	move.b	#'D',(a5)+
		move.b	#'B',(a5)+
		moveq	#8,d6
		bsr	Condition
		bsr	Tab
		moveq	#0,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		move.w	(a0)+,d7
		ext.l	d7
		add.l	a0,d7
		subq.l	#2,d7
		bra	Sort32

InstScc		move.b	#'S',(a5)+
		moveq	#8,d6
		bsr	Condition
		bsr	Tab
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstADDQ
InstSUBQ	movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		move.w	d0,d7
		lsr.w	#8,d7
		lsr.w	#1,d7
		andi.w	#%111,d7
		bne.s	.yes
		moveq	#8,d7
	.yes:	bsr	Sort4Imm
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%111111111000,d5
		bra	ModeAdressage


;*****************************************************************
;
;	******    **      **      **
;	**  **  ****    ****    ****
;	**  **    **      **      **
;	**  **    **      **      **
;	******  ******  ******  ******

InstMoveq	lea	.TextMOVEQ(pc),a3
		bsr	SortSansEspace
		bsr	Tab
		btst	#8,d0
		bne	Erreur
		move.b	d0,d7
		bsr	Sort8Imms
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN

.TextMOVEQ	dc.b	'MOVEQ '
		even


;*****************************************************************
;
;	  **    ******  ******  ******
;	****    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	******  ******  ******  ******

OR_DIV_SBCD	lea	.Table(pc),a1
		bra	Menu

	.Table:	dc.w	%1111000111110000,%1000000100000000
		dc.w	InstSBCD-s
		dc.b	'SBCD.B  '
		dc.w	%1111000111000000,%1000000011000000
		dc.w	InstDIVU-s
		dc.b	'DIVU    '
		dc.w	%1111000111000000,%1000000111000000
		dc.w	InstDIVS-s
		dc.b	'DIVS    '
		dc.w	%1111000000000000,%1000000000000000
		dc.w	InstOR-s
		dc.b	'OR      '
		dc.b	'LEO!'

InstSBCD	movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		btst	#3,d0
		beq.s	.SBCD_DD
		moveq	#0,d6
		bsr	Mode_MoinsAN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	Mode_MoinsAN
.SBCD_DD	moveq	#0,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN

InstDIVS
InstDIVU	movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	#2,MaTaille(a6)
		moveq	#0,d6
		move.w	#%101111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN

InstOR		movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		btst.l	#8,d0
		beq.s	.A_To_D
		moveq	#9,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%001111111000,d5
		bra	ModeAdressage
.A_To_D:	moveq	#0,d6
		move.w	#%101111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN

;*****************************************************************
;
;	  **    ******  ******  ******
;	****    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	******  ******  ******  ******

SUB_SUBX	lea	.Table(pc),a1
		bra	Menu

	.Table:	dc.w	%1111000011000000,%1001000011000000
		dc.w	InstSUBA-s
		dc.b	'SUBA    '
		dc.w	%1111000100110000,%1001000100000000
		dc.w	InstSUBX-s
		dc.b	'SUBX    '
		dc.w	%1111000000000000,%1001000000000000
		dc.w	InstSUB-s
		dc.b	'SUB     '
		dc.b	'LEO!'

InstSUBA	movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#8,d6
		bsr	TailleEXT
		moveq	#0,d6
		move.w	#%111111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeAN

InstSUBX	movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		btst	#3,d0
		beq.s	.SUBX_DD
		moveq	#0,d6
		bsr	Mode_MoinsAN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	Mode_MoinsAN
.SUBX_DD	moveq	#0,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN

InstSUB		movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		btst.l	#8,d0
		beq.s	.A_To_D
		moveq	#9,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%111111111110,d5
		bra	ModeAdressage
.A_To_D		moveq	#0,d6
		move.w	#%111111111110,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN

;**********************************************************
;
;	  **    ******  ******  ******
;	****    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	******  ******  ******  ******

ADD_ADDX	lea	.Table(pc),a1
		bra	Menu

	.Table:	dc.w	%1111000011000000,%1101000011000000
		dc.w	InstSUBA-s
		dc.b	'ADDA    '
		dc.w	%1111000100110000,%1101000100000000
		dc.w	InstSUBX-s
		dc.b	'ADDX    '
		dc.w	%1111000000000000,%1101000000000000
		dc.w	InstSUB-s
		dc.b	'ADD     '
		dc.b	'LEO!'

;**********************************************************
;
;	  **    ******  ******  ******
;	****    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	******  ******  ******  ******

Rotations	lea	.Table(pc),a1
		bra	Menu
	.Table:	dc.w	%1111111011000000,%1110001011000000
		dc.w	InstLS_Mem-s
		dc.b	'LS      '
		dc.w	%1111111011000000,%1110000011000000
		dc.w	InstAS_Mem-s
		dc.b	'AS      '
		dc.w	%1111111011000000,%1110011011000000
		dc.w	InstRO_Mem-s
		dc.b	'RO      '
		dc.w	%1111111011000000,%1110010011000000
		dc.w	InstROX_Mem-s
		dc.b	'ROX     '
		dc.w	%1111000000011000,%1110000000001000
		dc.w	InstLS_Reg-s
		dc.b	'LS      '
		dc.w	%1111000000011000,%1110000000000000
		dc.w	InstAS_Reg-s
		dc.b	'AS      '
		dc.w	%1111000000011000,%1110000000011000
		dc.w	InstRO_Reg-s
		dc.b	'RO      '
		dc.w	%1111000000011000,%1110000000010000
		dc.w	InstROX_Reg-s
		dc.b	'ROX     '
		dc.b	'LEO!'

InstAS_Reg
InstRO_Reg
InstROX_Reg
InstLS_Reg	movea.l	a1,a3
		bsr	SortSansEspace
		move.b	#'L',(a5)+
		btst	#8,d0
		bne.s	.ok
		move.b	#'R',-1(a5)
	.ok:	moveq	#6,d6
		bsr	TailleCLR
		btst	#5,d0
		beq	.Imm
	.Reg:	moveq	#9,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#0,d6
		bra	ModeDN
	.Imm:	move.w	d0,d7
		lsr.w	#8,d7
		lsr.w	#1,d7
		andi.w	#%111,d7
		bne.s	.ok2
		moveq	#8,d7
	.ok2:	bsr	Sort4Imm
		move.b	#',',(a5)+
		moveq	#0,d6
		bra	ModeDN

InstAS_Mem
InstRO_Mem
InstROX_Mem
InstLS_Mem	movea.l	a1,a3
		bsr	SortSansEspace
		move.b	#'L',(a5)+
		btst.l	#8,d0
		bne.s	.ok
		move.b	#'R',-1(a5)
	.ok:	move.b	#'.',(a5)+
		move.b	#'W',(a5)+
		bsr	Tab
		move.w	#2,MaTaille(a6)
		move.b	#'#',(a5)+
		move.b	#'1',(a5)+
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%001111111000,d5
		bra	ModeAdressage

;**********************************************************
;
;	  **    ******  ******  ******
;	****    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	******  ******  ******  ******

CMP_EOR		lea	.Table(pc),a1
		bra	Menu
	.Table:	dc.w	%1111000011000000,%1011000011000000
		dc.w	InstCMPA-s
		dc.b	'CMPA    '
		dc.w	%1111000100000000,%1011000000000000
		dc.w	InstCMP-s
		dc.b	'CMP     '
		dc.w	%1111000100000000,%1011000100000000
		dc.w	InstEOR-s
		dc.b	'EOR     '
		dc.b	'LEO!'

InstEOR		movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		moveq	#9,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#0,d6
		move.w	#%101111111000,d5
		bra	ModeAdressage

InstCMPA	movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#8,d6
		bsr	TailleEXT
		moveq	#0,d6
		move.w	#%111111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeAN

InstCMP		movea.l	a1,a3
		bsr	SortSansEspace
		moveq	#6,d6
		bsr	TailleCLR
		moveq	#0,d6
		move.w	#%111111111111,d5
		bsr	ModeAdressage
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN


;**********************************************************
;
;	  **    ******  ******  ******
;	****    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	  **    **  **  **  **  **  **
;	******  ******  ******  ******

AND_MUL_ABCD_EXG
		lea	.Table(pc),a1
		bra	Menu
	.Table:
		dc.w	%1111000111110000,%1100000100000000
		dc.w	InstSBCD-s
		dc.b	'ABCD    '
		dc.w	%1111000111000000,%1100000011000000
		dc.w	InstDIVU-s
		dc.b	'MULU    '
		dc.w	%1111000111000000,%1100000111000000
		dc.w	InstDIVS-s
		dc.b	'MULS    '
		dc.w	%1111000100110000,%1100000100000000
		dc.w	InstEXG-s
		dc.b	'EXG     '
		dc.w	%1111000000000000,%1100000000000000
		dc.w	InstOR-s
		dc.b	'AND     '
		dc.b	'LEO!'

InstEXG		movea.l	a1,a3
		bsr	SortSansEspace
		bsr	Tab
		move.w	d0,d1
		lsr.w	#3,d1
		andi.w	#%11111,d1
		cmpi.w	#%01000,d1
		beq.s	.Dn_Dn
		cmpi.w	#%01001,d1
		beq.s	.An_An
		cmpi.w	#%10001,d1
		bne	Erreur
	.An_Dn:	moveq	#0,d6
		bsr	ModeAN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN
	.An_An:	moveq	#0,d6
		bsr	ModeAN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeAN
	.Dn_Dn:	moveq	#0,d6
		bsr	ModeDN
		move.b	#',',(a5)+
		moveq	#9,d6
		bra	ModeDN

;*******************************************************************
;*******************************************************************

ModeDN		move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%111,d7
		move.b	#'D',(a5)+
		addi.b	#'0',d7
		move.b	d7,(a5)+
		rts

ModeAN		move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%111,d7
		move.b	#'A',(a5)+
		addi.b	#'0',d7
		move.b	d7,(a5)+
		rts

Mode_AN		move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%111,d7
		addi.b	#'0',d7
		move.b	#'(',(a5)+
		move.b	#'A',(a5)+
		move.b	d7,(a5)+
		move.b	#')',(a5)+
		rts

Mode_ANPlus	bsr	Mode_AN
		move.b	#'+',(a5)+
		rts

Mode_MoinsAN	move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%111,d7
		addi.b	#'0',d7
		move.b	#'-',(a5)+
		move.b	#'(',(a5)+
		move.b	#'A',(a5)+
		move.b	d7,(a5)+
		move.b	#')',(a5)+
		rts

ModeD_AN	move.w	(a0)+,d7
		bsr	Sort16
		bra	Mode_AN

ModeD_AN_Xi	lea	.Text(pc),a3
		move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%111,d7
		addi.b	#'0',d7
		move.b	d7,2(a3)		; Modifie "An"
		move.w	(a0)+,d1
		move.b	d1,d7
		bsr	Sort8s
		rol.w	#7,d1
		andi.w	#%1111100,d1
		move.l	LesRegs(pc,d1),4(a3)
		bra	SortSansEspace
	.Text:	dc.b	'(An,Rn.z) '
		even
LesRegs		dc.b	'D0.WD0.LD1.WD1.LD2.WD2.LD3.WD3.L'
		dc.b	'D4.WD4.LD5.WD5.LD6.WD6.LD7.WD7.L'
		dc.b	'A0.WA0.LA1.WA1.LA2.WA2.LA3.WA3.L'
		dc.b	'A4.WA4.LA5.WA5.LA6.WA6.LA7.WA7.L'
		even

ModeD_PC_Xi	lea	.Text(pc),a3
		move.w	(a0)+,d1
		move.b	d1,d7
		ext.w	d7
		ext.l	d7
		add.l	a0,d7
		subq.l	#2,d7
		bsr	Sort32
		rol.w	#7,d1
		andi.w	#%1111100,d1
		lea	LesRegs(pc),a1
		move.l	0(a1,d1.w),4(a3)
		bra	SortSansEspace
	.Text:	dc.b	'(PC,Rn.z) '
		even
		even


ModeABS_W	move.w	(a0)+,d7
		bpl.s	.ok
		ext.l	d7
		bsr	Sort32
		bra.s	.ok2
	.ok:	bsr	Sort16
	.ok2:	move.b	#'.',(a5)+
		move.b	#'W',(a5)+
		rts

ModeABS_L	move.l	(a0)+,d7
		bra	Sort32

ModeD_PC	move.l	a0,d1
		move.w	(a0)+,d7
		ext.l	d7
		add.l	d1,d7
		bsr	Sort32
		move.b	#'(',(a5)+
		move.b	#'P',(a5)+
		move.b	#'C',(a5)+
		move.b	#')',(a5)+
		rts



ModeImm		move.b	#'#',(a5)+
		move.w	MaTaille(a6),d7
		cmpi.w	#1,d7
		beq.s	.PointB
		cmpi.w	#2,d7
		beq.s	.PointW
		move.l	(a0)+,d7
		bra	Sort32

.PointW		move.w	(a0)+,d7
		bra	Sort16

.PointB		move.w	(a0)+,d7
		bra	Sort8




; Affichage du mode d'adressage. En entre: D6: numro du bit du mode
; d'adressage et D5=Masque des modes accepts. (bit 11 pour DN et bit
; 0 pour Imm.)

RModeAdressage	; Mode "Registre_Mode"
		move.w	d0,d1
		lsr.w	d6,d1
		move.w	d1,d2
		andi.w	#%111,d1	; Mode
		lsr.w	#3,d2
		andi.w	#%111,d2	; Registre
		addq.w	#3,d6		; Numro du bit du registre
		bra.s	RegOk
ModeAdressage	; Mode "Mode_Registre"
		move.w	d0,d1
		lsr.w	d6,d1
		move.w	d1,d2
		andi.w	#%111000,d1	; Mode
		lsr.w	#3,d1
		andi.w	#%000111,d2	; Registre
	RegOk:	cmpi.w	#%111,d1	; Mode "111" ??
		bne.s	.ok
		moveq	#%1000,d1
		or.w	d2,d1		; D1 contient le mode (0  15)
	.ok:	lsl.w	#2,d1		; MULU #4,d1
		lea	.TableMod(pc,d1.w),a1
		and.w	(a1)+,d5	; Mode autoris ??
		beq	Erreur		; non on se casse
		move.w	(a1)+,d1
		jmp	0(a6,d1.w)

.TableMod	dc.w	1<<11
		dc.w	ModeDN-s
		dc.w	1<<10
		dc.w	ModeAN-s
		dc.w	1<<9
		dc.w	Mode_AN-s
		dc.w	1<<8
		dc.w	Mode_ANPlus-s
		dc.w	1<<7
		dc.w	Mode_MoinsAN-s
		dc.w	1<<6
		dc.w	ModeD_AN-s
		dc.w	1<<5
		dc.w	ModeD_AN_Xi-s
		dc.w	-1,Erreur-s

		dc.w	1<<4
		dc.w	ModeABS_W-s
		dc.w	1<<3
		dc.w	ModeABS_L-s
		dc.w	1<<2
		dc.w	ModeD_PC-s
		dc.w	1<<1
		dc.w	ModeD_PC_Xi-s
		dc.w	1<<0
		dc.w	ModeImm-s
		dc.w	-1,Erreur-s,-1,Erreur-s
		dc.w	-1,Erreur-s,-1,Erreur-s
		even

Erreur		move.b	#'?',(a5)+
		move.b	#'?',(a5)+
		rts



SortSansEspace	move.b	(a3)+,(a5)+
		cmpi.b	#' ',(a3)
		bne.s	SortSansEspace
		rts

;	*********************************************************
;	*							*
;	*	Taille des instructions (.B,W ou L)		*
;	*							*
;	*********************************************************

TailleEXT	move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%1,d7
		move.b	#'.',(a5)+
		move.b	.TextEXT(pc,d7.w),(a5)+
		add.w	d7,d7
		move.w	.Taille(pc,d7.w),MaTaille(a6)
		bra	Tab
.TextEXT:	dc.b	'WL'
.Taille		dc.w	2,4
		even

TailleCLR	move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%11,d7
		move.b	#'.',(a5)+
		cmpi.b	#%11,d7
		bne.s	.ok
		move.b	#'?',(a5)+
		move.b	#'?',(a5)+
		bra	Tab
	.ok:	move.b	.TextEXT(pc,d7.w),(a5)+
		add.w	d7,d7
		move.w	.Taille(pc,d7.w),MaTaille(a6)
		bra	Tab
.TextEXT:	dc.b	'BWL'
		even
.Taille		dc.w	1,2,4
		even

TailleMOVE	move.w	d0,d7
		lsr.w	d6,d7
		andi.w	#%11,d7
		move.b	#'.',(a5)+
		cmpi.b	#%00,d7
		bne.s	.ok
		move.b	#'?',(a5)+
		move.b	#'?',(a5)+
		bra	Tab
	.ok:	move.b	.TextEXT(pc,d7.w),(a5)+
		add.w	d7,d7
		move.w	.Taille(pc,d7.w),MaTaille(a6)
		bra	Tab

.TextEXT:	dc.b	' BLW'
		even
.Taille		dc.w	2,1,4,2
		even

;**************************************************************

GetNumber	lea	Clavier(pc),a5
	.Wait:	tst.b	KeyA(a5)
		bne.s	.Wait

	; Dans un premier temps on efface un peu de place.
		bsr	Vsync
		move.l	Ecran(pc),a1
		lea	40+160*92(a1),a1
		move.l	BufferGraphique(pc),a2
		moveq	#15,d0
	.Loopy:	moveq	#19,d1
	.Loopx:	move.l	(a1),(a2)+
		clr.l	(a1)+
		dbf	d1,.Loopx
		lea	80(a1),a1
		dbf	d0,.Loopy

	; Un petit cadre pour faire plus beau...
		move.l	Ecran(pc),a1
		lea	40+160*92(a1),a1
		lea	15*160(a1),a2
		moveq	#-1,d1
		moveq	#19,d0
	.lop0:	move.l	d1,(a1)+
		move.l	d1,(a2)+
		dbf	d0,.lop0

		move.l	Ecran(pc),a1
		lea	40+160*92(a1),a1
		moveq	#15,d0
	.lop1:	ori.l	#$80008000,(a1)
		ori.l	#$00010001,19*4(a1)
		lea	160(a1),a1
		dbf	d0,.lop1

		moveq	#0,d7		; Position dans la chaine.
		lea	.Chaine(pc),a1
		moveq	#7,d5
	.l0:	move.b	#' ',(a1)+
		dbf	d5,.l0
		lea	.Chaine(pc),a1
		lea	.Corres(pc),a2
		moveq	#0,d5		; Chaine
		moveq	#0,d6

	.MMl:	move.w	#22,Xp(a6)
		move.w	#12,Yp(a6)
		lea	.Chaine0(pc),a0
		bsr	Print

		lea	Clavier(pc),a5
	.Waitk:	tst.b	0(a5,d6.w)
		bne.s	.Waitk

	.Mloop:	lea	.Entree(pc),a0
		lea	Clavier(pc),a5
		moveq	#0,d0
	.Loop:	move.b	(a0)+,d0
		beq.s	.Mloop
		tst.b	0(a5,d0.w)
		bne.s	.KeyPressed
		addq.w	#1,a0
		bra.s	.Loop

.KeyPressed	move.b	d0,d6			; Touche  attendre
		move.b	(a0)+,d0		; Correspondance touche
		cmpi.b	#$12,d0
		beq	.Escape
		cmpi.b	#$11,d0
		beq.s	.BackSpace
		cmpi.b	#$10,d0
		beq.s	.FinDeRoutine

.Chiffre:	ext.w	d0
		lsl.l	#4,d5
		or.b	d0,d5
		move.b	0(a2,d0.w),d0
		move.b	d0,0(a1,d7.w)
		addq.w	#1,d7
		cmpi.w	#8,d7
		beq.s	.FinDeRoutine
		bra	.MMl

.BackSpace	tst.w	d7		; Pas de caractre.
		beq	.MMl		; alors on remonte.
		subq.w	#1,d7
		move.b	#' ',0(a1,d7.w)
		lsr.l	#4,d5
		bra	.MMl

.FinDeRoutine	move.l	d5,d7
		moveq	#0,d0
		move.l	#TrueTOP-80,d1
		bsr	Clipping
		lea	RAM_Pointer(pc),a0
		move.l	d7,(a0)
.Escape
	; Enfin on restitue.
		bsr	Vsync
		move.l	Ecran(pc),a1
		lea	40+160*92(a1),a1
		move.l	BufferGraphique(pc),a2
		moveq	#15,d0
	.Lopy1:	moveq	#19,d1
	.Lopx1:	move.l	(a2)+,(a1)+
		dbf	d1,.Lopx1
		lea	80(a1),a1
		dbf	d0,.Lopy1

		lea	Clavier(pc),a5
	.Waik2:	tst.b	0(a5,d6.w)
		bne.s	.Waik2
		rts



.Entree		dc.w	$7000,$6d01,$6e02,$6f03,$6a04,$6b05,$6c06
		dc.w	$6707,$6808,$6909,$100a,$300b,$2e0c,$200d
		dc.w	$120e,$210f
		dc.w	$1c10,$7210	; Return ou entre.
		dc.w	$0e11		; BackSpace
		dc.w	$0112		; Escape.
		dc.w	0
.Chaine0:	dc.b	'Aller a l''Adresse:$'
.Chaine		dc.b	'        ',-1
.Corres		dc.b	'0123456789ABCDEF'
		even



Tab		;moveq	#1-1,d7
		move.b	#9,(a5)+
		rts

Sort32First	move.b	#'$',(a5)+
		movem.l	d5-d6/a0,-(sp)
		moveq	#0,d4
		lea	Convert(pc),a0
		moveq	#8-1,d5
	.Loop:	rol.l	#4,d7
		moveq	#%1111,d6
		and.w	d7,d6
	.ok:	move.b	0(a0,d6.w),(a5)+
	.non:	dbf	d5,.Loop
		movem.l	(sp)+,d5-d6/a0
		rts

	; Affichage de D7 en long.
Sort32Imm	move.b	#'#',(a5)+
Sort32		move.b	#'$',(a5)+
		movem.l	d4-d6/a0,-(sp)
		moveq	#0,d4
		lea	Convert(pc),a0
		moveq	#8-1,d5
	.Loop:	rol.l	#4,d7
		moveq	#%1111,d6
		and.w	d7,d6
		bne.s	.ok
		tst.w	d5			; Dernier caractre ??
		beq.s	.ok			; Oui alors affiche.
		tst.w	d4
		beq.s	.non
	.ok:	move.b	0(a0,d6.w),(a5)+
		moveq	#-1,d4
	.non:	dbf	d5,.Loop
		movem.l	(sp)+,d4-d6/a0
		rts

	; Affichage de D7 en word sign.
Sort16Imm	move.b	#'#',(a5)+
Sort16		tst.w	d7
		bpl.s	.ok
		neg.w	d7
		move.b	#'-',(a5)+
	.ok:	move.b	#'$',(a5)+
		movem.l	d4-d6/a0,-(sp)
		lea	Convert(pc),a0
		moveq	#4-1,d5
		swap	d7
		moveq	#0,d4
	.Loop:	rol.l	#4,d7
		moveq	#%1111,d6
		and.w	d7,d6
		bne.s	.ok2
		tst.w	d5			; Dernier caractre ??
		beq.s	.ok2			; Oui alors affiche.
		tst.w	d4
		beq.s	.non
	.ok2:	move.b	0(a0,d6.w),(a5)+
		moveq	#-1,d4
	.non:	dbf	d5,.Loop
		movem.l	(sp)+,d4-d6/a0
		rts


	; Affichage de D7 en Byte.
Sort8Imms	move.b	#'#',(a5)+
Sort8s		tst.b	d7
		bpl.s	.ok
		neg.b	d7
		move.b	#'-',(a5)+
	.ok:	move.b	#'$',(a5)+
		movem.l	d5-d6/a0,-(sp)
		lea	Convert(pc),a0
		moveq	#2-1,d5
		ror.l	#8,d7
	.Loop:	rol.l	#4,d7
		moveq	#%1111,d6
		and.w	d7,d6
		move.b	0(a0,d6.w),(a5)+
		dbf	d5,.Loop
		movem.l	(sp)+,d5-d6/a0
		rts


	; Affichage de D7 en Byte.
Sort8Imm	move.b	#'#',(a5)+
Sort8		cmpi.b	#9,d7
		bgt.s	.Nanou
		cmpi.b	#-9,d7
		bge.s	.Nano
	.Nanou:	move.b	#'$',(a5)+
	.Nano:	movem.l	d5-d6/a0,-(sp)
		lea	Convert(pc),a0
		moveq	#2-1,d5
		ror.l	#8,d7
	.Loop:	rol.l	#4,d7
		moveq	#%1111,d6
		and.w	d7,d6
		move.b	0(a0,d6.w),(a5)+
		dbf	d5,.Loop
		movem.l	(sp)+,d5-d6/a0
		rts

Sort4Imm	move.b	#'#',(a5)+
Sort4		move.b	#'$',(a5)+
		movem.l	d5-d6/a0,-(sp)
		lea	Convert(pc),a0
		moveq	#%1111,d6
		and.w	d7,d6
		move.b	0(a0,d6.w),(a5)+
		movem.l	(sp)+,d5-d6/a0
		rts

Convert		dc.b	'0123456789ABCDEF'
		even

;	*********************************************************
;	*							*
;	*	Routine de PRINT				*
;	*	Toujours sur Xp(a6),Yp(a6)			*
;	*							*
;	*********************************************************
Print		movem.l	d0-a5,-(sp)
		move.w	Xp(a6),d0
		move.w	Yp(a6),d1
	.recom:
;		lea	TOP-32000,a1
		move.l	Ecran(pc),a1
		move.w	d1,d2
		mulu.w	#160*8,d2
		add.l	d2,a1
		move.w	d0,d2
		ror.l	#1,d2		; Bit de parit de cot
		add.w	d2,d2
		rol.l	#1,d2
		add.w	d2,a1		; Abscisse X

	.LoopP:	moveq	#0,d2
		move.b	(a0)+,d2
		ble	.finp		; Fin si <= 0
		cmpi.b	#$0a,d2		; Retour chariot ??
		bne.s	.non1
		moveq	#1,d0
		addq.w	#1,d1		; Yp+1
		bra.s	.recom
	.non1:	cmpi.b	#$09,d2		; TAB ??
		bne.s	.non2
		addq.w	#8,d0
		andi.w	#-8,d0
		bra.s	.recom
	.non2:	lea	Font88(pc),a2

;		cmpi.b	#'q',d2
;		bne.s	.oup1
;		move.b	#'.',d2
;		bra.s	.oup2
;	.oup1:	blo.s	.oup2
;		subq.w	#1,d2
;	.oup2:

		sub.b	#32,d2
		lsl.w	#3,d2
		add.w	d2,a2
		move.b	(a2)+,(a1)
i		set	160
		rept	7
		move.b	(a2)+,i(a1)
i		set	i+160
		endr
		addq.w	#1,d0			; Xp+1
		addq.w	#1,a1
		btst	#0,d0
		bne.s	.yes
		addq.w	#2,a1
	.yes:	bra	.LoopP
	.finp:	move.w	d0,Xp(a6)
		move.w	d1,Yp(a6)
		movem.l	(sp)+,d0-a5
		rts


Vsync		move.w	#$2300,sr
		move.w	d0,-(sp)
		move.w	$468.w,d0
	.Wait:	cmp.w	$468.w,d0
		beq.s	.Wait
		move.w	(sp)+,d0
		rts

	; Mise  jour des registres hardware.
	; (Palette, ecran, MFP, clavier.)
My_ITs		lea	Vbl(pc),a0
		move.l	a0,$70.w
		lea	IT_Clavier(pc),a0
		move.l	a0,$118.w
		lea	Contexte(pc),a0
		lea	$fffffa01.w,a1
		moveq	#15,d0
	.Loop1:	move.b	(a0)+,(a1)
		addq.w	#2,a1
		dbf	d0,.Loop1
		clr.l	$fffffa06.w
		clr.l	$fffffa12.w
		bclr	#3,$fffffa17.w
	; Initialisation du clavier.
		clr.b	$fffffa1b.w
		move.b	#%00000001,$fffffa07.w
		move.b	#%00000001,$fffffa13.w
		move.b	#%01000000,$fffffa09.w		; IT clavier.
		move.b	#%01000000,$fffffa15.w
		move.b	#$03,$fffffc00.w
		move.b	#$96,$fffffc00.w
	.la:	btst	#1,$fffffc00.w
		beq.s	.la
		move.b	#$12,$fffffc02.w
		move.w	#$2300,sr
		bsr.s	MedRes
		rts

MedRes		moveq	#1,d0
		and.b	$ffff8260.w,d0
		bne.s	.already
		sf	$ffff820a.w
		move.b	#1,$ffff8260.w
		stop	#$2300
		stop	#$2300
		stop	#$2300
		move.b	#2,$ffff820a.w
.already:	move.l	Ecran(pc),a0
		move.l	a0,d0
		move.b	d0,$ffff820d.w
		lsr.w	#8,d0
		move.b	d0,$ffff8203.w
		swap	d0
		move.b	d0,$ffff8201.w
	IFEQ	PIC
		move.w	#32000/4-1,d0
	.Cls:	clr.l	(a0)+
		dbf	d0,.Cls
	ELSEIF
		lea	Picture(pc),a0
		bsr	DisplayIff
	ENDC
		lea	MyPalette(pc),a0
		movea.w	#$8240,a1
		move.l	(a0)+,(a1)+
		move.l	(a0)+,(a1)+
		rts
	IFNE	PIC
DisplayIff	cmpi.l	#'FORM',(a0)+
		bne	IffError
		lea	8(a0),a0
		cmpi.l	#'ILBM',-4(a0)
		bne	IffError
		move.l	#'BMHD',d0
		bsr	Search
		lea	8(a0),a0
		cmp.w	#640,(a0)+
		bne	IffError
		move.w	(a0)+,d7	; Hauteur
		move.w	#200,d7
		cmp.b	#1,4(a0)	; Nb plans
		bne	IffError
		move.l	#'BODY',d0
		bsr	Search
		lea	8(a0),a0
		subq.w	#1,d7
		move.l	Ecran(pc),a5
	.la:	bsr	Depak1Ligne
		dbf	d7,.la
		rts

Depak1Ligne	movem.l	a1-a3,-(sp)
		lea	MiniBuff(pc),a1
		lea	80(a1),a3
	.read:	cmpa.l	a1,a3
		bls	.Finlig
		moveq	#0,d0
		move.b	(a0)+,d0
		bpl.s	.Ok
		neg.b	d0
		move.b	(a0)+,d1
	.Loop1:	move.b	d1,(a1)+
		dbf	d0,.Loop1
		bra.s	.read
	.Ok:	move.b	(a0)+,(a1)+
		dbf	d0,.Ok
		bra.s	.read
.Finlig		movem.l	(sp)+,a1-a3
		lea	MiniBuff(pc),a1
		moveq	#80/2-1,d0
	.Loop:	clr.w	(a5)+
		move.w	(a1)+,(a5)+
		dbf	d0,.Loop
		rts
MiniBuff	dcb.b	160,0

IffError	moveq	#-1,d0
		rts
Search		cmp.l	(a0),d0
		beq.s	.Ok
		lea	2(a0),a0
		bra.s	Search
	.Ok:	rts

	ENDC


LowRes		clr.b	$ffff820a.w
		move.b	OldRes(pc),$ffff8260.w
		stop	#$2300
		stop	#$2300
		move.b	OldSync(pc),$ffff820a.w
		lea	OldPal(pc),a0
		movea.w	#$8240,a1
		moveq	#7,d0
	.Loop:	move.l	(a0)+,(a1)+
		dbf	d0,.Loop
		move.l	Ecran(pc),a0
		move.l	#Place,d1
		moveq	#0,d0
	.Loopc:	move.l	d0,(a0)+
		subq.l	#4,d1
		bpl.s	.Loopc
		rts

MyPalette	dc.w	$000
		dc.w	$677
		dc.w	$004
		dc.w	CoulCadre
PalSys		dc.w	$fff,$f00,$0f0,$ff0,$00f,$f0f,$0ff,$555
		dc.w	$333,$f33,$3f3,$ff3,$33f,$f3f,$3ff,$000
PalType		dc.w	0

IT_Clavier	movem.l	d0-d1/a0,-(sp)
		move.b	$fffffc02.w,d0
		move.b	d0,$308.w		; Octet clavier.
		moveq	#0,d1
		btst	#7,d0
		bne.s	.rela
		moveq	#-1,d1
	.rela:	andi.w	#%01111111,d0
		lea	Clavier(pc),a0
		move.b	d1,0(a0,d0.w)
	.non:	movem.l	(sp)+,d0-d1/a0
		rte

Vbl		move.b	$fffffc02.w,$308.w
		pea	(a0)
		lea	VariablesPC(pc),a6
		clr.b	$fffffa1b.w


		lea	Clavier(pc),a0
		tst.b	KeyAlt(a0)
		beq.s	.non1
		tst.b	KeyX(a0)
		bne	Reprise
.non1:		move.l	(sp)+,a0
		addq.l	#1,$466.w
		rte


;	*********************************************************
;	*							*
;	*	Reprise de la dmo en cours.			*
;	*							*
;	*********************************************************
Reprise		move.w	#$2700,sr		; Coupe tout.
		tst.b	$200.w			; Plantage ??
		bne.s	.non
		move.l	$4.w,a0
		jmp	(a0)
.non:		move.b	#0,$ffff820a.w
		clr.l	$fffffa06.w
		clr.l	$fffffa12.w
		move.b	#7,$484.w
		clr.b	$308.w
		move.l	Ecran(pc),a0
		move.l	#Place,d1
		moveq	#0,d0
	.Loopc:	move.l	d0,(a0)+
		subq.l	#4,d1
		bpl.s	.Loopc

; Remet la RAM de $8  $400
		lea	$8.w,a1
		move.b	$200.w,d7
		lea	LowRAM+8(pc),a0
		move.w	#($400-$8)/4-1,d0
	.Loop1:	move.l	(a0)+,(a1)+
		dbf	d0,.Loop1
		move.b	d7,$200.w

; Initialise Clavier.
		move.b	#$03,$fffffc00.w
		move.b	#$96,$fffffc00.w
	.la:	btst	#1,$fffffc00.w
		beq.s	.la
		move.b	#$12,$fffffc02.w
; Initialise l'cran.
		move.b	OldRes(pc),$ffff8260.w
		move.b	OldVdh(pc),$ffff8201.w
		move.b	OldVdm(pc),$ffff8203.w
		move.b	OldVdl(pc),$ffff820d.w
		move.b	OldShift(pc),$ffff8265.w
		lea	OldPal(pc),a0
		movea.w	#$8240,a1
		moveq	#7,d0
	.Loop2:	move.l	(a0)+,(a1)+
		dbf	d0,.Loop2

		lea	Yamaha(pc),a0
		moveq	#11,d0
	.Loop3:	move.b	d0,$ffff8800.w
		move.b	(a0)+,$ffff8802.w
		dbf	d0,.Loop3

; Initialise MFP
		lea	Contexte(pc),a0
		movea.w	#$fa01,a1
		moveq	#15,d0
	.Loop4:	move.b	(a0)+,(a1)
		addq.w	#2,a1
		dbf	d0,.Loop4

; Initialise les registres gnraux.
		move.l	LeUSP(pc),a0
		move.l	a0,usp
		movem.l	(LeSR+6)(pc),d0-d7/a0-a7
		move.b	OldSync(pc),$ffff820a.w
		sf	$200.w
		rte					; Retour du trap #15


;	************************************************************

		ds.l	64
MyStack		even

LowRAM		dcb.b	$400,0
RAM_Pointer	dc.l	0
AD_Video	dc.l	0
Ecran		dc.l	0
LesOctets	dc.l	0
BufferGraphique	dc.l	0
TailleInstruction	dc.w	2
Processor	dc.w	0
;*********************************
Contexte	dcb.b	16,0	*	; Registres MFP.
OldRes		dc.b	1
OldSync		dc.b	2
OldVdh		dc.b	$0f
OldVdm		dc.b	$80
OldVdl		dc.b	0
OldShift	dc.b	0
OldPal		dcb.b	32,0		; Registres de couleur.
Yamaha		dcb.b	12,0	*

;*********************************
Clavier		dcb.b	128,0
;*********************************
Registers			*
LeSR		dc.w	$2300		; SR
LePC		dc.l	0		; PC
D0D7		dcb.l	8,0		; D0-D7
A0A7		dcb.l	8,0		; A0-A7
LeUSP		dc.l	0	*	; USP
;*********************************
	; Variables adressables avec A6
s
VariablesPC	dcb.b	10,0
Xp		equ	0	W
Yp		equ	2	W
MaTaille	equ	4	W
Flag1		equ	6	W
MasqueMOVEM	equ	8	W

Font88		incbin	"a:\griff.fnt"
		even
	IFNE	PIC
Picture		incbin	"b:\ddv3_1.iff"
		even
	ENDC
BB

