

		section	text

tunnel_init:

		lea.l	tunnel_rawtxt,a0		;mirror the texture 4 times
		lea.l	tunnel_txt,a1
		lea.l	tunnel_txt+256*2,a2
		lea.l	tunnel_txt+256*2*255,a3
		lea.l	tunnel_txt+256*2*255+512,a4

		move.w	#128-1,d7
.loop:		move.w	#128-1,d6
.loop2:		move.w	(a0)+,d0
		move.w	d0,(a1)+
		move.w	d0,-(a2)
		move.w	d0,(a3)+
		move.w	d0,-(a4)

		dbra	d6,.loop2
		lea.l	256(a1),a1
		lea.l	768(a2),a2
		lea.l	-768(a3),a3
		lea.l	-256(a4),a4
		dbra	d7,.loop


		lea.l	tunnel_txt,a0			;doublecopy the texture 
		lea.l	tunnel_txt+256*256*2,a1
		move.w	#256*256*2/64-1,d7
.loop3:		rept	16
		move.l	(a0)+,(a1)+
		endr
		dbra	d7,.loop3

		rts
		

tunnel_clear:
		tst.w	.var				;make sure route runs
		bne.w	.no				;only one time
		not.w	.var
		
		move.l	screen_adr1,a0
		move.l	screen_adr2,a1
		move.l	screen_adr3,a2
		move.w	#320*240*2/64-1,d7
.loop:
		rept	16
		clr.l	(a0)+
		clr.l	(a1)+
		clr.l	(a2)+
		endr
		
		dbra	d7,.loop

.no:		rts
.var:		ds.w	1
		
tunnel_vbl:

		rts

tunnel_timer:
		add.l	#512+2,tunnel_pos		;move tunnel
		and.l	#$1ffff,tunnel_pos		;loop smooth

		rts
		

tunnel_main:
		move.l	screen_adr,a0			;screen
		lea.l	640*50+160(a0),a0		;center on screen
		lea.l	tunnel_lookup,a1		;lookup table
		lea.l	tunnel_txt,a2			;texture
		add.l	tunnel_pos,a2			;add texture position
		
		moveq.l	#0,d0
		move.l	#640-256,d1			;screenwidth-plotted pixels width
		
		move.w	#100-1,d7
.loop:		move.w	#128/8-1,d6
.loop2:
		rept	8
		move.w	(a1)+,d0
		move.w	(a2,d0.l*2),(a0)+
		endr

		dbra	d6,.loop2
		add.l	d1,a0
		dbra	d7,.loop

		rts




		section	data

tunnel_lookup:	incbin	'incbin\tunnel.dat'

tunnel_rawtxt:	incbin	'incbin\tunnel.16b'




		section	bss


tunnel_txt:	ds.w	256*256*2
tunnel_pos:	ds.l	1


		section	text