// ExportDlgs.cpp : implementation file
//

#include "stdafx.h"
#include "Rmt.h"
#include "ExportDlgs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExpSAPDlg dialog


CExpSAPDlg::CExpSAPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExpSAPDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExpSAPDlg)
	m_author = _T("");
	m_date = _T("");
	m_name = _T("");
	//}}AFX_DATA_INIT
}


void CExpSAPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExpSAPDlg)
	DDX_Text(pDX, IDC_AUTHOR, m_author);
	DDX_Text(pDX, IDC_DATE, m_date);
	DDX_Text(pDX, IDC_NAME, m_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExpSAPDlg, CDialog)
	//{{AFX_MSG_MAP(CExpSAPDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExpSAPDlg message handlers
/////////////////////////////////////////////////////////////////////////////
// CExpRMTDlg dialog


CExpRMTDlg::CExpRMTDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExpRMTDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExpRMTDlg)
	//}}AFX_DATA_INIT
}


void CExpRMTDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExpRMTDlg)
	DDX_Control(pDX, IDC_ADDR, m_c_addr);
	DDX_Control(pDX, IDC_INFO, m_c_info);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExpRMTDlg, CDialog)
	//{{AFX_MSG_MAP(CExpRMTDlg)
	ON_EN_CHANGE(IDC_ADDR, OnChangeAddr)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExpRMTDlg message handlers

BOOL CExpRMTDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CString s;
	s.Format("%04X",m_adr);
	m_c_addr.SetWindowText(s);
	ChangeParams();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CExpRMTDlg::ChangeParams()
{
	CString s;
	char *ch;
	m_c_addr.GetWindowText(s);
	int adr = strtoul(s,&ch,16);
	if (adr>0x10000-m_len) adr = 0x10000-m_len;
	m_adr = adr;
	s.Format("=>  $%04X - $%04X , length %04X (%u bytes)",m_adr,m_adr+m_len-1,m_len,m_len);
	m_c_info.SetWindowText(s);
}

void CExpRMTDlg::OnChangeAddr() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	ChangeParams();
}
/////////////////////////////////////////////////////////////////////////////
// CExpMSXDlg dialog


CExpMSXDlg::CExpMSXDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExpMSXDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExpMSXDlg)
	m_meter = FALSE;
	//}}AFX_DATA_INIT
}


void CExpMSXDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExpMSXDlg)
	DDX_Control(pDX, IDC_PREV, m_prev);
	DDX_Control(pDX, IDC_EDIT, m_edit);
	DDX_Check(pDX, IDC_RASTERLINE, m_meter);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExpMSXDlg, CDialog)
	//{{AFX_MSG_MAP(CExpMSXDlg)
	ON_EN_CHANGE(IDC_EDIT, OnChangeTxtedit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExpMSXDlg message handlers

BOOL CExpMSXDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_font.CreatePointFont(80,"Fixedsys");
	m_prev.SetFont(&m_font);

	// TODO: Add extra initialization here
	m_edit.SetWindowText(m_txt);
	ChangeParams();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CExpMSXDlg::ChangeParams()
{
	//
	CString s,d;
	m_edit.GetWindowText(s);
	int i,from=0,line=0;
	while(from<s.GetLength() && line<4)
	{
		i = s.Find("\n",from);
		if (i>=0)
		{
			int len = i-from;
			if (len>40) len=40;
			d+=s.Mid(from,len)+"\x0d\x0a";
			from = i+1;
			line++;
		}
		else
		{
			d+=s.Mid(from,40);
			break;
		}
	}
	m_prev.SetWindowText(d);
	m_txt = d;
}

void CExpMSXDlg::OnChangeTxtedit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	ChangeParams();	
}
