// 2PokeysDlg.cpp : implementation file
//

#include "stdafx.h"
#include "XPokey.h"
#include "Pokey.h"
#include "Pokeysnd.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

int stereo_enabled=1;

static LPDIRECTSOUND          g_lpds;
static LPDIRECTSOUNDBUFFER    g_lpdsbPrimary;


//#include <fstream.h>
//ofstream g_log;


CXPokey::CXPokey()
{
//	InitSound();
	m_rendersound=0;
	m_SoundBuffer=NULL;
}

CXPokey::~CXPokey()
{
	// TODO: Add your specialized code here and/or call the base class
	DeInitSound();
}

BOOL CXPokey::DeInitSound()
{
	//g_log.close();

	m_rendersound = 0;
	if (m_SoundBuffer )
	{
		m_SoundBuffer->Stop();
		m_SoundBuffer->Release();
	}
	m_SoundBuffer = NULL;

	if(g_lpdsbPrimary) g_lpdsbPrimary->Release();
	g_lpdsbPrimary=NULL;
	if(g_lpds) g_lpds->Release();
	g_lpds = NULL;
	return 1;
}

BOOL CXPokey::ReInitSound()
{
	DeInitSound();
	return InitSound();
}

BOOL CXPokey::RenderSound1_100()
{
	if (!m_rendersound) return 0;
	if (!m_SoundBuffer) return 0;


	m_SoundBuffer->GetCurrentPosition(&m_PlayCursor,&m_WriteCursor);

	//|||||||||||||||||||||||||||||||||||||||||
	//           ^|-------delta------->^
	//      m_WriteCursor           m_LoadPos

	int delta = (m_LoadPos - m_WriteCursor) & (BUFFER_SIZE-1);

	m_LoadSize = CHUNK_SIZE;
	if ( delta > LATENCY_SIZE )
	{
		if (delta > (BUFFER_SIZE/2))
		{
			//uteklo nam to (jsme vic nez pul bufferu pozde
			//takze se na to vyprdnem a posunem se tam co bychom meli spravne byt
			m_LoadPos = (m_WriteCursor+LATENCY_SIZE) & (BUFFER_SIZE-1);
		}
		else 
		{
			//utekli jsme tomu moc dopredu
			//takze trosku pribrzdime (budeme renderovat mensi kousky nez CHUNK_SIZE)
			m_LoadSize = CHUNK_SIZE - ( ((delta-LATENCY_SIZE) /16) & (BUFFER_SIZE-1-1) );	//-1-1 <=JEN SUDA CISLA!!!
			
			//hlidani
			if (m_LoadSize <= 0 ) return 0; //jsme tak moc vepredu, ze vubec nebudem renderovat
			//MessageBeep(-1);
		}
	}
	else // delta <=LATENCY_SIZE
	{
		//jsme bliz nez pozadovana latence, to je sice super, ale radej
		//trosicku zrychlime, aby nas nedohnal m_WriteCursor (budeme renderovat vetsi kousky nez CHUNK_SIZE)
		m_LoadSize = CHUNK_SIZE + ( ((LATENCY_SIZE-delta) /16) & (BUFFER_SIZE-1-1) );	//-1-1 <=JEN SUDA CISLA!!!		

		//hlidani
		if (m_LoadSize >= BUFFER_SIZE/2 ) return 0; //to by byl uz vetsi kus nez velikost pulky bufferu
	}

	
	//g_log << m_LoadSize << endl;

	int r;

	r = m_SoundBuffer->Lock(m_LoadPos, m_LoadSize, &Data1, &dwSize1, &Data2, &dwSize2,0 ); 

	//if (dwSize1 != m_LoadSize) MessageBeep(-1);

	if (r==DS_OK)
	{
		//vyrendrujeme do bufferu najednou cele m_LoadSize
		Pokey_process((unsigned char*)&m_PlayBuffer,(unsigned short) m_LoadSize);
		m_LoadPos = (m_LoadPos + m_LoadSize) & (BUFFER_SIZE-1);

		//prvni kousek preneseme z bufferu na Data1
		memcpy(Data1,m_PlayBuffer,dwSize1);

		if (Data2)
		{
			//pokud je to rozdeleno, tak ted ten druhy zbyvajici kousek
			memcpy(Data2,m_PlayBuffer+dwSize1,dwSize2);
		}

		m_SoundBuffer->Unlock(Data1, dwSize1, Data2, dwSize2);
		return 1;
	}

	return 0;
}

BOOL CXPokey::InitSound()
{
	//g_log.open("log.log");	//,ios::binary);

    WAVEFORMATEX        wfm;

	POKEY_Initialise(0,0);
	Pokey_sound_init(FREQ_17_EXACT, OUTPUTFREQ, 2);//22050,(stereo_enabled)?2:1);

	
	if (DirectSoundCreate( NULL, &g_lpds, NULL ) != DS_OK)
	{
		MessageBox(0,"Error: DirectSoundCreate","DirectSound Error!",MB_OK|MB_ICONSTOP);
		return FALSE;		
	}
	
	// Set cooperative level.
	//if(g_lpds->SetCooperativeLevel( AfxGetApp()->GetMainWnd()->m_hWnd, DSSCL_WRITEPRIMARY ) !=DS_OK)
	//if(g_lpds->SetCooperativeLevel( AfxGetApp()->GetMainWnd()->m_hWnd, DSSCL_EXCLUSIVE) !=DS_OK)
	if(g_lpds->SetCooperativeLevel( AfxGetApp()->GetMainWnd()->m_hWnd, DSSCL_PRIORITY) !=DS_OK)
	{
		MessageBox(0,"Error: SetCooperativeLevel","DirectSound Error!",MB_OK|MB_ICONSTOP);
		return FALSE;
	}

  // Set primary buffer format.
    ZeroMemory( &wfm, sizeof( WAVEFORMATEX ) ); 
    wfm.wFormatTag      = WAVE_FORMAT_PCM; 
    wfm.nChannels       = CHANNELS;//(stereo_enabled)?2:1; 
    wfm.nSamplesPerSec  = OUTPUTFREQ;	//22050; 
    wfm.wBitsPerSample  = BITRESOLUTION;		//8; 
    wfm.nBlockAlign     = wfm.wBitsPerSample / 8 * wfm.nChannels;
    wfm.nAvgBytesPerSec = wfm.nSamplesPerSec * wfm.nBlockAlign;
	wfm.cbSize			= 0;
	
	
    // Create primary buffer.
    ZeroMemory( &dsbdesc, sizeof( DSBUFFERDESC ) );
    dsbdesc.dwSize  = sizeof( DSBUFFERDESC );
	dsbdesc.dwFlags = DSBCAPS_PRIMARYBUFFER;
//	dsbdesc.dwBufferBytes       = BUFFER_SIZE;
    //dsbdesc.lpwfxFormat         = &wfm;


	if (g_lpds->CreateSoundBuffer(&dsbdesc, &g_lpdsbPrimary, NULL) != DS_OK )
	{
		MessageBox(0,"Error: CreatePrimarySoundBuffer","DirectSound Error!",MB_OK|MB_ICONSTOP);
		return FALSE;
	}


	if (g_lpdsbPrimary->SetFormat( &wfm ) != DS_OK )
	{
		MessageBox(0,"Error: SetFormat","DirectSound Error!",MB_OK|MB_ICONSTOP);
		return FALSE;
	}


    ZeroMemory( &dsbdesc, sizeof( DSBUFFERDESC ) );
    dsbdesc.dwSize  = sizeof( DSBUFFERDESC );
	dsbdesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2| DSBCAPS_LOCSOFTWARE | DSBCAPS_GLOBALFOCUS | DSBCAPS_STICKYFOCUS;
	dsbdesc.dwBufferBytes       = BUFFER_SIZE;
    dsbdesc.lpwfxFormat         = &wfm;

	if (g_lpds->CreateSoundBuffer(&dsbdesc, &m_SoundBuffer, NULL) != DS_OK )
	{
		MessageBox(0,"Error: CreateSoundBuffer","DirectSound Error!",MB_OK|MB_ICONSTOP);
		return FALSE;
	}

	DSBCAPS bc;
	bc.dwSize = sizeof(bc);
	m_SoundBuffer->GetCaps(&bc);//IDirectSoundBuffer_GetCaps(pDSB, &bc);
	//sbufsize = bc.dwBufferBytes;



	int r = m_SoundBuffer->Lock(0, BUFFER_SIZE, &Data1, &dwSize1, &Data2, &dwSize2,DSBLOCK_FROMWRITECURSOR); 
	if (r==DS_OK)
	{
		memset(Data1,0,dwSize1);
		if (Data2) memset(Data2,0,dwSize2);
		m_SoundBuffer->Unlock(Data1, dwSize1, Data2, dwSize2);
	}

	m_SoundBuffer->Play(0, 0, DSBPLAY_LOOPING);

	m_SoundBuffer->GetCurrentPosition(&m_PlayCursor,&m_WriteCursorStart);

	m_LoadPos = (m_WriteCursorStart+LATENCY_SIZE) & (BUFFER_SIZE-1);  //uvodni latence (v setinach sekundy)


	m_rendersound = 1;
	return 1;
}


CXPokey::MemToPokey(int tracks4_8)
{
	for(int i=0; i<=8; i++)	//0-7 + 8audctl
	{
		POKEY_PutByte(i,g_atarimem[0xd200+i]);
		if (tracks4_8 == 8) 
			POKEY_PutByte(i+16,g_atarimem[0xd210+i]);		//stereo
		else
			POKEY_PutByte(i+16,g_atarimem[0xd200+i]);		//mono - do obou pokeyu to samo
	}

	return 1;
}
