/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: DLI (char mode)              */
/***************************************/

	icl "sic-logo.h"

* ---	MAIN PROGRAM
ant	dta $44,a(scr)
	dta $04,$04,$84,$04,$04,$04,$84,$04,$70,$70,$70,$70,$70,$02,$40,$02
	dta $40,$02,$40,$02,$40,$02,$70,$70,$02,$70,$70,$70,$02
	dta $41,a(ant)

* ---	DLI PROGRAM

	?old_dli = *

dli1
	lda vcount
	cmp #$02
	bne dli1
	:3 sta wsync
	DLINEW dli2

dli_start

dli2
	sta regA
	lda >fnt+$400*$01
	sta wsync		;line=32
	sta chbase
	DLINEW dli3 1 0 0

dli3
	sta regA
	stx regX
	sty regY
	lda >fnt+$400*$02
	sta wsync		;line=64
	sta chbase
	sta wsync		;line=65
	sta wsync		;line=66
	sta wsync		;line=67
	sta wsync		;line=68
	sta wsync		;line=69
	sta wsync		;line=70
c5	lda #$00
c6	ldx #$04
c7	ldy #$06
	sta wsync		;line=71
	sta colbak
	stx color0
	sty color1
c8	lda #$08
	sta color2
c9	lda #$0E
	sta color3
	lda >fnt+$400*$00
	sta wsync		;line=72
	sta chbase
	sta wsync		;line=73
	sta wsync		;line=74
	sta wsync		;line=75
	lda >fnt2
	sta chbase

	lda #0
	sta color2
	lda #15
	sta color1
	
	lda regA
	ldx regX
	ldy regY
	rti

;---

CHANGES = 1
;---

.proc	NMI

	bit nmist
	bpl VBL

	jmp (dliv)
dliv	equ $1f04

VBL
	sta regA
	stx regX
	sty regY

	sta nmist		;reset NMI flag

	mwa #ant dlptr		;ANTIC address program

	mva #%00111110 dmactl	;set new screen's width

	inc cloc		;little timer

;--- first line of screen initialization

	lda >fnt+$400*$00
	sta chbase
c0	lda #$02
	sta colbak
c1	lda #$0E
	sta color0
c2	lda #$38
	sta color1
c3	lda #$7A
	sta color2
c4	lda #$9C
	sta color3
	lda #$04
	sta gtictl

	mwa #dli_start dliv	;set the first address of DLI interrupt

;this area is for yours routines

quit
	lda regA
	ldx regX
	ldy regY
	rti

.endp

;---
	ift CHANGES
	icl 'sic-logo.fad'
	eif

;---

	opt l-


.MACRO	DLINEW
	mva <:1 NMI.dliv
	ift [>?old_dli]<>[>:1]
	mva >:1 NMI.dliv+1
	eif

	ift :2
	lda regA
	eif

	ift :3
	ldx regX
	eif

	ift :4
	ldy regY
	eif

	rti

	.def ?old_dli = *
.ENDM

