;------------------------------------------------------------------------------------------------------------------
;	Candle'O'Sin
;-------------------------------------------------------------------------------------------------------------------

;--------------------------------------------------------
; some system/memory address space definitions
; antic


; os
POKMSK		equ	$10
CRITIC		equ	$42
COLCRS		equ	$55
SAVMSC		equ	$58


; page 0 user data
; page 0 TeBe's stuff
fcnt		equ	$80	;.ds 2
fadr		equ	$82	;.ds 2
fhlp		equ	$84	;.ds 2
cloc		equ	$86	;.ds 1
regA		equ	$87	;.ds 1
regX		equ	$88	;.ds 1
regY		equ	$89	;.ds 1
Screen_Offset	equ	$8a	; word
Page_Offset	equ	$8c	; word


inflate_zp	equ	$90
inflate_data	equ	$4d00
inflate		equ	$5000

gamelow		equ	$4d00
gamemid		equ	$4d05
gamehigh	equ	$4d0a
Page		equ	$4d10
Games		equ	$4d11
KeyPress	equ	$4d12
; OS Vectors
VSERIN		equ	$20A

	opt	f+
	opt	h-
;--------------------------------------------------------
;Theta Music Composer
	tmc_player	equ	$2000
	tmc_init	equ tmc_player
	tmc_play	equ tmc_player+3
	tmc_sound	equ tmc_player+6
	tmc_stop	equ tmc_player+9
	tmc_music	equ	$2800
;--------------------------------------------------------
 	org	$a000
; Inflate
	ins	'inflate.raw'
;--------------------------------------------------------
; main
	org	$a200
init	rts
main	
	mva #$38 pactl
	mva #$00 porta
	mva #$38 pbctl
	mva #$ff portb
	mva #$3c pactl
	mva #$3c pbctl
	mva #$ff portb
	mva #$01 $3f8	; BASICF (BASIC OFF)
.local

; move loader
	ldx #0

Move
	lda $a000,x
	sta inflate,x
	lda $a000+256,x
	sta inflate+256,x
	inx
	bne Move

.endl
	jsr	Wait_For_Sync
	lda	#0
	sta	dmactl
	sta	nmien
	lda	#%00100001
	sta	$d500
	mwa	#$8000 Inflate_zp
	mwa	#$800 Inflate_zp+2
	jsr	inflate
	lda	#0
	sta	$d500
	lda	#$40
	lda	nmien
	lda	#%00100010
	sta	dmactl
	jsr	$800
	jsr	Wait_For_Sync
	lda	#0
	sta	nmien
	sta	dmactl
	mwa	#Fonts Inflate_zp
	mwa	#$1000 Inflate_zp+2
	jsr	inflate

	mwa	#XEX_Loader Inflate_zp
	mwa	#$800 Inflate_zp+2
	jsr	inflate

	mwa	#Music Inflate_zp
	mwa	#$2800 Inflate_zp+2
	jsr	inflate
	
	mwa	#Music_player Inflate_zp
	mwa	#tmc_player Inflate_zp+2
	jsr	inflate


	mwa	#G2F_Fonts Inflate_zp
	mwa	#fnt Inflate_zp+2
	jsr	inflate

	mwa	#G2F_Screen Inflate_zp
	mwa	#scr Inflate_zp+2
	jsr	inflate
	
.local

; move loader
	ldx #0

Move
	lda Menu,x
	sta scr+$168,x
	inx
	bne Move
	ldx #0
move2
	lda Menu+256,x
	sta scr+$268,x
	inx
	dey
	bne move2
.endl

	ldx	>tmc_music
	ldy	<tmc_music
	jsr	tmc_init


	lda	#0
	sta	Page
	jsr	Get_Names

	jsr save_color		;then save all colors and set value 0 for all colors
	mwa #dli_start $1f04
	lda:cmp:req vcount	;wait 1 frame

	sei			;stop IRQ interrupts
	mva #$00 nmien		;stop NMI interrupts
	sta dmactl
	mva #$fe portb		;switch off ROM to get 16k more ram

	mwa #NMI $fffa		;new NMI handler

	mva #$c0 nmien		;switch on NMI+DLI again


	jsr fade_in		;fade in colors

main_loop
	jsr	tmc_play
	lda	#44
;	jsr	Wait_For_Line
	jsr	tmc_sound
	jsr	tmc_sound
	jsr	tmc_sound
	jsr	Wait_For_Sync
	lda	KeyPress
	bne	Main_loop_s0
	lda skctl		;wait to press any key; here you can put any own routine
	and #$04
	bne	main_loop
	jmp	Main_loop_c0
Main_loop_s0
	lda	skctl
	and	#$04
	beq	Main_loop
	lda	#0
	sta	KeyPress
	jmp	Main_loop
Main_loop_c0
	lda	KBCODE
	cmp	#$21
	bne	Main_loop_s1
	jsr	Next_Page
	jsr	Get_Names
	lda	#1
	sta	KeyPress
	jmp	Main_loop
Main_loop_s1
	jsr	tmc_stop

;	jsr fade_out		;fade out colors
	mva #$00 pmcntl		;PMG disabled
	tax
	sta:rne hposp0,x+

	mva #$ff portb		;ROM switch on
	mva #$40 nmien		;only NMI interrupts, DLI disabled
	cli			;IRQ enabled
	lda	KBCODE
	cmp	#$1f
	beq	game1
	cmp	#$1e
	beq	game2
	cmp	#$1a
	beq	game3
	cmp	#$18
	beq	game4
	cmp	#$1d
	beq	game5
game1
	lda	gamelow
	ldx	gamemid
	ldy	gamehigh ;	artefakt przodkow
	jmp	$800
game2
	lda	gamelow+1
	ldx	gamemid+1
	ldy	gamehigh+1	;	barahir
	beq	game1
	jmp	$800
game3
	lda	gamelow+2
	ldx	gamemid+2
	ldy	gamehigh+2	;	barahir
	beq	game2
	jmp	$800
game4
	lda	gamelow+3
	ldx	gamemid+3
	ldy	gamehigh+3	;	barahir
	beq	game3
	jmp	$800
game5
	lda	gamelow+4
	ldx	gamemid+4
	ldy	gamehigh+4	;	barahir
	beq	game4
	jmp	$800

	jmp ($000a)		;jump to DOS


;--------------------------------------------------------
Wait_For_Sync
	lda	VCOUNT
	rne		 		;repeat last instruction if not equal
	lda	VCOUNT
	req				;repeat last instruction if equal
	rts

;--------------------------------------------------------
; Wait For Line
; a - line to wait for
Wait_For_Line
	cmp	VCOUNT
	rne		 		;repeat last instruction if not equal
	lda	VCOUNT
	req				;repeat last instruction if equal
	rts
;--------------------------------------------------------
; next page
;
Next_Page
	lda	#%00100000
	sta	$d500
	lda	$8000
	sta	Games
	lda	Page
	add	#5
	cmp	Games
	scc
	lda	#0
	sta	Page
	rts
;--------------------------------------------------------
; get names
; Page = current page (5 titles per page)
; Page_Offset - zp word
; Screen_Offset - zp word
Get_Names
	lda	#%00100000
	sta	$d500
	sta	Page_Offset+1
	lda	Page
	sta	Page_Offset+0

	ldx	#4
Get_Names_l0
	asl	Page_Offset	; *2
	rol	Page_Offset+1
	dex
	bpl	Get_Names_l0
	adw	Page_Offset #$8001
	mwa	#scr+$168+11 Screen_Offset
	ldx	#0
Get_Names_l1
	ldy	#0
Get_Names_l2
	lda	(Page_Offset),y
	bmi	Get_Names_s0
	sta	(Screen_Offset),y
	iny
	cpy	#28
	bcc	Get_Names_l2
Get_Names_s0
	ldy	#29
	lda	(Page_Offset),y
	sta	Gamehigh,x
	iny
	lda	(Page_Offset),y
	sta	Gamelow,x
	iny
	lda	(Page_Offset),y
	sta	Gamemid,x
	inx
	adw	Page_Offset #$20
	adw	Screen_Offset #40
	cpx	#5
	bcc	Get_Names_l1
	rts
;--------------------------------------------------------
; Tebe's stuff
	icl	'sic-logo.asm'
fnt	equ	$5400
fnt2	equ	$1000
scr	equ	$6000
;--------------------------------------------------------
; Data
Music
	ins	'vyciel.def'
Music_player
	ins	'tmc-player.def'
G2F_Fonts
	ins	'sic-logof.def'
G2F_Screen
	ins	'sic-logos.def'
XEX_Loader
	ins	'loader.def'
Fonts
	ins	'fonts.def'
Menu
;-----------------------------------------------------------
;		  0	    1         2         3
;		  0123456789012345678901234567890123456789
	dta	d'         1 -                            '
	dta	d'         2 -                            '
	dta	d'         3 -                            '
	dta	d'         4 -                            '
	dta	d'         5 -                            '
	dta	d'      press space for next page         '
	dta	d'Sic Cart,(c)2011 Sin/Agenda/LaResistance'
	org	$bffa
	dta	a(main)
	dta	0
	dta	4
	dta	a(init)
Bank2

	end
	;run	main