;-------------------------------------------------------------
; Wait For DRQ
;-------------------------------------------------------------
Wait_For_DRQ:
	ldy	#10
Wait_For_DRQ_L0:
	ldx	#0
Wait_For_DRQ_L1:
	lda	IDE_BASE+7
	cmp	#$58
	beq	Wait_For_DRQ_OK
	and	#$01
	bne	Wait_For_DRQ_Error
	.if .def Wait_For_Sync
	jsr	Wait_For_Sync
	.else
	lda	$d40b
	rne		 		;repeat last instruction if not equal
	lda	$d40b
	req				;repeat last instruction if equal
	.endif
	dex
	bne	Wait_For_DRQ_L1
	dey
	bne	Wait_For_DRQ_L0
Wait_For_DRQ_Error:
	sec
	rts
Wait_For_DRQ_OK:
	clc
	rts
;-------------------------------------------------------------
; Read Sector
; LBA_Sector - 32 bit sector number
;-------------------------------------------------------------
LBA_Sector:	.byte	0,0,0,0
Read_Sector:
	lda	#0x01
	sta	IDE_BASE+2
	lda	LBA_Sector
	sta	IDE_BASE+3
	lda	LBA_Sector+1
	sta	IDE_BASE+4
	lda	LBA_Sector+2
	sta	IDE_BASE+5
	lda	LBA_Sector+3
	and	#0x0F
	ora	#0xE0
	sta	IDE_BASE+6
	lda	#0x20
	sta	IDE_BASE+7
	jsr	Wait_For_DRQ
	bcs	Read_Sector_Error
	ldx	#0
Read_Sector_L0:
	lda	IDE_BASE+0
	ldy	IDE_BASE+0
	sta	Sector_Buffer,x
	inx
	tya
	sta	Sector_Buffer,x
	inx
	bne	Read_Sector_L0
Read_Sector_L1:
	lda	IDE_BASE+0
	ldy	IDE_BASE+0
	sta	Sector_Buffer+0x100,x
	inx
	tya
	sta	Sector_Buffer+0x100,x
	inx
	bne	Read_Sector_L1
	clc
	rts
Read_Sector_Error:
	sec
	rts
;-------------------------------------------------------------
; Set 8bit PIO
;-------------------------------------------------------------
Set_8bit_PIO:
	ora	#0xE0		; LBA mode on
	sta	IDE_BASE+6
	lda	#$01
	sta	IDE_BASE+1
	lda	#$ef
	sta	IDE_BASE+7
	ldx	#0
	jmp	Get_Status
;-------------------------------------------------------------
; Set 8bit PIO
;-------------------------------------------------------------
Set_Power_Managment:
	ora	#0xE0		; LBA mode on
	sta	IDE_BASE+6
	lda	#$05
	sta	IDE_BASE+1
	lda	#0xFE
	sta	IDE_BASE+2
	lda	#$ef
	sta	IDE_BASE+7
	ldx	#0
	jmp	Get_Status
;-------------------------------------------------------------
; Set 8bit PIO
;-------------------------------------------------------------
Set_Power_Mode1:
	ora	#0xE0		; LBA mode on
	sta	IDE_BASE+6
	lda	#0x0A
	sta	IDE_BASE+1
	lda	#0xFE
	sta	IDE_BASE+2
	lda	#0xEF
	sta	IDE_BASE+7
	ldx	#0
	jmp	Get_Status
;-------------------------------------------------------------
; Set PIO mode
; a - master/slave (0x00/0x10)
; x - pio mode
;-------------------------------------------------------------
Set_PIO_mode:
	ora	#0xe0
	sta	IDE_BASE+6
	txa
	ora	#0x08
	sta	IDE_BASE+2
	lda	#0x03
	sta	IDE_BASE+1
	lda	#0xEF
	sta	IDE_BASE+7
	ldx	#0
	jmp	Get_Status
;-------------------------------------------------------------
Get_Status:
	lda	IDE_BASE+7
	and	#$81
	beq	Get_Status_OK
	inx
	bne	Get_Status
	sec
	rts
Get_Status_OK:
	clc
	rts