;bit mask
OR0     equ     1
OR1     equ     2
OR2     equ     4
OR3     equ     8

SR      equ     RTC_Base	; Ultimate RTC
SW      equ     RTC_Base
CE      equ     OR0
SCK     equ     OR1
MOSI    equ     OR2
MISO    equ     OR3
;------------------------------------------------------------------------
; SPI transfer (A=address&mode, X=data length)        

spi     sta     SPI_Adr         ; first byte is address & mode 
        inx                     ; total length is address + data
        stx     SPI_Len
        
        lda     #0              ; reset SPI
        sta     SW
        tay
        lda     #CE             ; CE on, start transfer
        sta     SW
        
tstring lda     SPI_Adr,y       ; get a byte to write
        ldx     #8
        sta     Temp1
        
tbyte   lda     #CE
        asl     Temp1           ; put output bit to C
        scc
        ora     #MOSI           ; set line if bit is set
        
        pha                     ; save output setting
        
        ora     #SCK            ; set clock cycle
        sta     SW              ; go
        
        clc
        lda     SR              ; get input
        and     #MISO           ; is input ?
        seq
        sec
        rol     Temp2           ; fetch bit
        
        pla
        sta     SW              ; restore (finish clock cycle)
        
        dex
        bne     tbyte           ; next bit
        
        lda     Temp2
        sta     SPI_Adr,y       ; save response
        iny
        cpy     SPI_Len         ; all bytes transferred ?
        bne     tstring         ; next byte
        
        lda     #0              ; turn off, stop transfer
        sta     SW
        rts
;------------------------------------------------------------------------
