;------------------------------------------------------------------------------------------------------------------
;	1200XL logo replacement for VBXE FX core v 1.20 and above
;	This is very simple example for VBXE written by Candl'O'Sin with help of AtariArea users
;	I'm not an 6502 coder, so if this is inefficent for you, please provide better one
;
;	additionally, following libraries were used:
;	inflate by Fox/TQA
;	rmtplay by Raster/C.P.U.
;	music was written by Born/La Resistance
;	hi-res fonts painted by Marc Rosocha and comes from the Thalion game "Wings of death" (originaly). 
;	This one from the "The Vodka Demo" (Atari).
;	please visit http://cgi.algonet.se/htbin/cgiwrap?user=guld1&script=fonts.pl
;	Candle'O'Sin
;-------------------------------------------------------------------------------------------------------------------

;--------------------------------------------------------
; some system/memory address space definitions
; antic
dmactl	equ	$D400
VCOUNT	equ	$D40B
NMIEN	equ	$D40E
NMIST	equ	$D40E
; gtia
COLBAK	equ	$D01A
CONSOL	equ	$D01F
; pokey
SKSTAT	equ	$D20F


; os
POKMSK		equ	$10
CRITIC		equ	$42
COLCRS		equ	$55
SAVMSC		equ	$58


; page 0 user data
Screen		equ	$80
TextAdr		equ	$82
Temp		equ	$84
BufPtr		equ	$85
OVLPalette	equ	$8a
DSTPalette	equ	$8c

inflate_zp	equ	$90
inflate_data	equ	$8000
inflate		equ	$6000

; OS Vectors
VSERIN		equ	$20A


;.def	__VBXE_AUTO__
.def	VBXE_WINDOW	=	0x3000
.def	REVISION	=	0x22

;--------------------------------------------------------
; main

;--------------------------------------------------------
;Raster Music Tracker
STEREOMODE		equ	1
RMT_Module		equ	0x4000
;	opt	f+
;	icl	'rmtplayr.a65'
;	opt	f-
RASTERMUSICTRACKER	equ	0x5000
;--------------------------------------------------------

	org 	inflate

	icl	'inflate.asx'
	

	icl	'vbxe.lib'

main
	mwa	#Player_ inflate_zp
	mwa	#0x4d82 inflate_zp+2
	jsr	inflate

	mwa	#Music Inflate_zp
	mwa	#RMT_Module Inflate_zp+2
	jsr	inflate

	jsr	VBXE_Detect	; VBXE core 1.07 and above detection, in this example not used
				; however it shows the way of doing so

	sei
	lda	NMIST
	sta	NMI_Status
	lda	#0
	sta	NMIEN
	sta	dmactl

	lda	#0x38			; set the base address of MEMA window to 0x3000 (and not collide with SpartaDosX), size to 4k and accesible only by CPU
	vbsta	VBXE_MA_CTL
	lda	#0x80			; copy some data into VBXE address space (XDL, Blitter control blocks (BCB))
	vbsta	VBXE_MA_BSEL
	ldx	#XDL_Lenght
	ldy	#0
Main_l1	lda	XDL,y
	sta	VBXE_WINDOW+0x800,y
	iny
	dex
	bne	Main_l1

	ldx	#BLT_Lenght
	ldy	#0
Main_l2	lda	BLT_CLR,y
	sta	VBXE_WINDOW+0x900,y
	iny
	dex
	bne	Main_l2
	
	lda	#0			; setup VBXE for displaying picture data
	vbsta	VBXE_XDL_ADR0
	vbsta	VBXE_XDL_ADR2
	lda	#0x08
	vbsta	VBXE_XDL_ADR1
	lda	#%00000001		; XDL enabled, and solid color index 0, otherwise you would see
	vbsta	VBXE_VIDEO_CONTROL	; standard screen under overlayed picture data


	lda	#0x81
	vbsta	VBXE_MA_BSEL
	ldx	#255
	ldy	#0
Main_l3	tya
	sta	VBXE_WINDOW,y
	sta	VBXE_WINDOW+0x100,y
	iny
	dex
	bne	Main_l3
	
	lda	#BLT_CLR-BLT_CLR
	jsr	Start_Blitter

	lda	#BLT_PAT-BLT_CLR
	jsr	Start_Blitter
	
	ldx	#0
	stx	Counter
	ldx	#7
	stx	Counter+2
	lda	#0xA0
	sta	Counter+1
Main_l4
	ldx	Counter+1
	stx	VBXE_MA_BSEL
	inx
	stx	Counter+1
	ldx	Counter
	lda	Data_off_lo,x
	sta	inflate_zp
	lda	Data_off_hi,x
	inx
	stx	Counter
	sta	inflate_zp+1
	mwa	#VBXE_WINDOW inflate_zp+2
	jsr	inflate
	ldy	Counter+2
	dey
	sty	Counter+2
	bne	Main_l4
	
	lda	#0xB0
	sta	VBXE_MA_BSEL
	mwa	#Fonts inflate_zp
	mwa	#VBXE_WINDOW inflate_zp+2
	jsr	inflate
	
	lda	#0x00
	sta	VBXE_MA_BSEL
	
	mwa	#pal Inflate_zp
	mwa	#Palette Inflate_zp+2
	jsr	inflate

	mwa	#pal2 Inflate_zp
	mwa	#(Palette+0x300) Inflate_zp+2
	jsr	inflate

	lda	#BLT_AND-BLT_CLR
	jsr	Start_Blitter

	lda	#BLT_CLR2-BLT_CLR
	jsr	Start_Blitter
	
	
	mwa	#Palette Pal_ptr
	lda	#0
	sta	Pal_ofst
	ldx	#1
	ldy	#255
	jsr	VBXE_SetPalette		; set the palette to all black

	ldx	#<RMT_Module
	ldy	#>RMT_Module
	lda	#0
	jsr	RASTERMUSICTRACKER
	
Main_Loop		; main loop, where all the action is
	lda	#0x00
	sta	VBXE_MA_BSEL
	lda	#8*16+10
;	sta	COLBAK
	jsr	RASTERMUSICTRACKER+3
	lda	#4*16+14
;	sta	COLBAK
	mwa	#Palette Pal_ptr
	lda	#0
	sta	Pal_ofst
	lda	Counter
	ldx	#1
	ldy	#255
	jsr	VBXE_SetPalette		; set the palette to all black
	lda	#0
	sta	COLBAK
	lda	#91
Main_Loop_s1
	cmp	VCOUNT
	jne	Main_Loop_s1
	lda	#8*16+10
;	sta	COLBAK
	jsr	RASTERMUSICTRACKER+3
	lda	#0x80
	sta	VBXE_MA_BSEL
	lda	#0
;	sta	COLBAK
	jsr	Wait_For_Sync
	ldy	Counter
	iny
	sty	Counter
	tya
	and	#0x7f
	cmp	#0x7f			; a=0x7f - put string
	bcs	Main_Loop_write
	cmp	#0x07			; a<=0x07 - make a fade up
	bcs	Main_Loop_skip
	lda	Counter+2
	sta	Pal_ofst
	mwa	#(Palette+0x300) Pal_ptr
	lda	#0
	ldx	#2
	ldy	#16
	jsr	VBXE_SetPalette
	lda	Counter+2
	sub	#16
	sta	Counter+2
Main_Loop_skip
	lda	Counter
	and	#0x7f
	cmp	#0x77			; a>=0x77 - make fade down
	bcs	Main_Loop_fade_down
	jmp	Main_Loop_s2
Main_Loop_write
	ldy	#0x60
	sty	Counter+2
	lda	Counter+1
	add	#1
	and	#0x3
	sta	Counter+1
	tax
	lda	Scroll_Table_lo,x
	sta	String_ptr
	lda	Scroll_Table_hi,x
	sta	String_ptr+1
	jsr	Write_String
	jmp	Main_Loop
Main_Loop_fade_down
	lda	Counter+2
	add	#16
	sta	Counter+2
	sta	Pal_ofst
	mwa	#(Palette+0x300) Pal_ptr
	lda	#0
	ldx	#2
	ldy	#16
	jsr	VBXE_SetPalette
Main_Loop_s2
	jmp	Main_Loop

;--------------------------------------------------------
Wait_For_Sync
	lda	VCOUNT
	rne		 		;repeat last instruction if not equal
	lda	VCOUNT
	req				;repeat last instruction if equal
	rts

;---------------------------------------------------------------
Start_Blitter
	sta	VBXE_BL_ADR0		; setup the blitter for memory fill operation
	lda	#0
	sta	VBXE_BL_ADR2		; see the description of BCB at the end of this
	lda	#0x09			; source
	sta	VBXE_BL_ADR1
Start_Blitter_l1
	lda	VBXE_BLITTER_BUSY
	bne	Start_Blitter_l1	; wait for blitter to finish
	lda	#1
	sta	VBXE_BLITTER_START	; start the blit
	rts
;---------------------------------------------------------------
Write_String
	lda	#0x80
	sta	VBXE_MA_BSEL
	ldx	#0
	lda	#12
	sta	VBXE_WINDOW+0x900+BLT_FNT-BLT_CLR+6
Write_String_l1
	lda	Scroll_,x
String_ptr	equ	*-2
	beq	Write_String_end
	jsr	Draw_Font
	lda	VBXE_WINDOW+0x900+BLT_FNT-BLT_CLR+6
	add	#8
	sta	VBXE_WINDOW+0x900+BLT_FNT-BLT_CLR+6
	inx
	cpx	#32
	bne	Write_String_l1
Write_String_end
	rts
;---------------------------------------------------------------
Draw_Font
	sub	#64
	stx	Temp_X
	tax
	and	#0x01
	clc
	ror	@
	ror	@
	sta	VBXE_WINDOW+0x900+BLT_FNT-BLT_CLR
	txa
	lsr	@
	sta	VBXE_WINDOW+0x900+BLT_FNT-BLT_CLR+1
	lda	#BLT_FNT-BLT_CLR
	jsr	Start_Blitter
	ldx	Temp_X
	rts
;---------------------------------------------------------------
; Data
XDL
	dta %00110100,%00000000,0x44	  					; 68 (0x44) empty lines
	dta %01110010,%00001000,0x68,0x00,0x00,0x02,0x00,0x01,%00010000,0xff	; graphics mode,SD resolution, 104 lines, start at 0x20000, 256 bytes/line, palette 1
	dta %00110100,%00000000,0x08	  					; 8 (0x08) empty lines
	dta %01110010,%00011000,0x10,0x00,0x00,0x04,0x00,0x01,%00100000,0xff	; graphics mode,HR resolution, 16 lines, start at 0x40000, 256 bytes/line, palette 2
	dta %00000000,%10000000							; end of XDL, wait for VSYNC
XDL_Lenght	equ *-XDL
BLT_CLR
	dta 0x00,0x00,0x00	; source address
	dta 0xFF,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x00,0x02	; destination address
	dta 0xFF,0x01		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x01		; width
	dta 0xFF		; height
	dta 0x00		; and mask (and mask equal to 0, memory will be filled with xor mask)
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; pattern feature
	dta 0x00		; control
BLT_PAT
	dta 0x00,0x10,0x00	; source address
	dta 0x01,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x00,0x01	; destination address
	dta 0x00,0x01		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x00		; width
	dta 0x67		; height
	dta 0xFF		; and mask 
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; pattern feature
	dta 0x00		; control
BLT_AND
	dta 0x00,0x00,0x01	; source address
	dta 0x01,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x00,0x02	; destination address
	dta 0x00,0x01		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x00		; width
	dta 0x67		; height
	dta 0xFF		; and mask 
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; pattern feature
	dta 0x04		; control (AND)
BLT_FNT
	dta 0x00,0x00,0x03	; source address
	dta 0x08,0x00		; source step y
	dta 0x01		; source step x
BLT_FNT_DST
	dta 0x42,0x00,0x04	; destination address
	dta 0x00,0x01		; destination step y
	dta 0x01		; destination step x
	dta 0x07,0x00		; width
	dta 0x0f		; height
	dta 0xFF		; and mask 
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; pattern feature
	dta 0x00		; control (COPY HR)
BLT_CLR2
	dta 0x00,0x00,0x00	; source address
	dta 0xFF,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x00,0x04	; destination address
	dta 0x00,0x01		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x00		; width
	dta 0xFF		; height
	dta 0x00		; and mask (and mask equal to 0, memory will be filled with xor mask)
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; pattern feature
	dta 0x00		; control
BLT_Lenght	equ	*-BLT_CLR

NMI_Status
	.byte	0
Counter
	.byte	0,0,0
Temp_X	.byte	0
Temp_Y	.byte	0

Data_off_lo
	.byte	<Logo1,<Logo2,<Logo3,<Logo4,<Logo5,<Logo6,<Logo7,<Fonts
Data_off_hi
	.byte	>Logo1,>Logo2,>Logo3,>Logo4,>Logo5,>Logo6,>Logo7,>Fonts

Scroll_Table_lo
	.byte	<Scroll_1,<Scroll_2,<Scroll_3,<Scroll_4
Scroll_Table_hi
	.byte	>Scroll_1,>Scroll_2,>Scroll_3,>Scroll_4
Scroll_
;		  000000000011111111112222222222
;		  012345678901234567890123456789
Scroll_1
	dta	c"@@@@CODE@@BY@CANDLE@OF@SIN@@@@",0
Scroll_2
	dta	c"MUSIC@BY@BORN@OF@LA@RESISTANCE",0
Scroll_3
	dta	c"@@@@@PRESS@SPACE@TO@REBOOT@@@@",0
Scroll_4
	dta	c"@@@@@@@PRESS@B@FOR@BASIC@@@@@@",0
Palette
Logo1	ins	'resource\1200xl001.def'
Logo2	ins	'resource\1200xl002.def'
Logo3	ins	'resource\1200xl003.def'
Logo4	ins	'resource\1200xl004.def'
Logo5	ins	'resource\1200xl005.def'
Logo6	ins	'resource\1200xl006.def'
Logo7	ins	'resource\1200xl007.def'
Fonts	ins	'resource\fonts.df7'
Music	ins	'resource\music.df7'
Player_	ins	'resource\player.df7'
pal	ins	'resource\pal.df7'
pal2	ins	'resource\fontpal.df7'
	
	run	main
