;-------------------------------------------------------------------------------------------------------------------
;	SlideShow for VBXE FX core v 1.09 and above
;	This is very simple SlideShow for VBXE written by Candl'O'Sin with help of AtariArea users, and Biki/Union
;	I'm not an 6502 coder, so if this is inefficent for you, please provide better one
;	
;	Candle'O'Sin
;-------------------------------------------------------------------------------------------------------------------

;	ps. For some reason this example won't run under SDX (it cannot find the files...)

;--------------------------------------------------------
; some system/memory address space definitions
; antic
VCOUNT	equ	$D40B
NMIEN	equ	$D40E
; gtia
COLBAK	equ	$D01A
CONSOL	equ	$D01F

; os
POKMSK		equ	$10
CRITIC		equ	$42
COLCRS		equ	$55
SAVMSC		equ	$58


; page 0 user data
Screen		equ	$80
TextAdr		equ	$82
Temp		equ	$84
BufPtr		equ	$85
OVLPalette	equ	$8a
DSTPalette	equ	$8c
; OS Vectors
VSERIN		equ	$20A


.def	__VBXE_AUTO__
.def	VBXE_WINDOW	=	0x3000

;--------------------------------------------------------
; main
	org $2000

	icl	'fileio.lib'
	icl	'vbxe.lib'

main
	jsr	VBXE_Detect	; VBXE core 1.07 and above detection, in this example not used
				; however it shows the way of doing so


	lda	#0x38			; set the base address of MEMA window to 0x3000 (and not collide with SpartaDosX), size to 4k and accesible only by CPU
	vbsta	VBXE_MA_CTL
	lda	#0x80			; copy some data into VBXE address space (XDL, Blitter control blocks (BCB))
	vbsta	VBXE_MA_BSEL
	ldx	#XDL_Lenght
	ldy	#0
Main_l1	lda	XDL,y
	sta	VBXE_WINDOW+0x800,y
	iny
	dex
	bne	Main_l1

	ldx	#BLT_Lenght
	ldy	#0
Main_l2	lda	BLT_CLR,y
	sta	VBXE_WINDOW+0x900,y
	iny
	dex
	bne	Main_l2
	
	lda	#0			; setup VBXE for displaying picture data
	vbsta	VBXE_XDL_ADR0
	vbsta	VBXE_XDL_ADR2
	lda	#0x08
	vbsta	VBXE_XDL_ADR1
	lda	#%00000101		; XDL enabled, and solid color index 0, otherwise you would see
	vbsta	VBXE_VIDEO_CONTROL	; standard screen under overlayed picture data

	
	lda	#0x00
	sta	Pal_ptr
	sta	DSTPalette
	lda	#0x30
	sta	Pal_ptr+1
	lda	#0x33
	sta	DSTPalette+1
	lda	#0x80
	vbsta	VBXE_MA_BSEL
	jsr	Clear_Palette
	lda	#0
	ldx	#1
	jsr	VBXE_SetPalette

	lda	#0x80
	vbsta	VBXE_MA_BSEL
	mwa	#VBXE_WINDOW Pal_ptr
	lda	#0
	ldx	#1
	jsr	VBXE_SetPalette		; set the palette to all black

	ldy	#0
	sty	File_To_Load
	sty	Active_Buffer
	lda	#0x80
	vbsta	VBXE_MA_BSEL
Main_Loop				; main loop, where all the action is
	ldx	File_To_Load
	lda	Graphics_Files_low,x
	sta	FileNamePtr
	lda	Graphics_Files_high,x
	sta	FileNamePtr+1		; update pointer to file name
	inx
	txa
	and	#15
	sta	File_To_Load		; load the file 
	ldx	Active_Buffer
	lda	Video_Page,x		; select on of two video pages
	sta	bankindex		; and set the bankindex (see the LoadData procedure) apropriatly
	jsr	LoadData

	jsr	Flip_Page		; flip the page, and loop
	jmp	Main_Loop
	jmp	(0x000a)

;--------------------------------------------------------
;Flip_Page - fades current picture out, changes display start address,
; copies new palette and fade picture in, so everything looks smooth
Flip_Page
	lda	#21*3
	jsr	Copy_Palette
	lda	#0
	sta	frame
Flip_Page_l1
	jsr	Wait_For_Sync
	lda	#0x80
	vbsta	VBXE_MA_BSEL
	lda	#0x00
	sta	Pal_ptr
	sta	DSTPalette
	lda	#0x30
	sta	Pal_ptr+1
	lda	#0x33
	sta	DSTPalette+1
	jsr	Fade_Out
	lda	#0x33
	sta	Pal_ptr+1
	lda	#0
	ldx	#1
	jsr	VBXE_SetPalette
	inc	frame
	bne	Flip_Page_l1
	jsr	Clear_Palette
	ldx	Active_Buffer
	lda	Video_Palette,x
	jsr	Copy_Palette
	jsr	Wait_For_Sync
	ldx	Active_Buffer
	lda	Video_Buffer_high,x
	sta	VBXE_WINDOW+0x0805
	lda	Video_Buffer_mid,x
	sta	VBXE_WINDOW+0x0804
	lda	Video_Buffer_low,x
	sta	VBXE_WINDOW+0x0803
	inx
	txa
	and	#1
	sta	Active_Buffer
	inc	frame
Flip_Page_l2
	jsr	Wait_For_Sync
	lda	#0x80
	sta	VBXE_MA_BSEL
	lda	#0x00
	sta	Pal_ptr
	sta	DSTPalette
	lda	#0x30
	sta	Pal_ptr+1
	lda	#0x33
	sta	DSTPalette+1
	jsr	Fade_In
	lda	#0x33
	sta	Pal_ptr+1
	lda	#0
	ldx	#1
	jsr	VBXE_SetPalette
	inc	frame
	bne	Flip_Page_l2
	lda	#0x30
	sta	Pal_ptr+1
	lda	#0
	ldx	#1
	jsr	VBXE_SetPalette
	rts
;--------------------------------------------------------
Wait_For_Sync
	lda	0x14
Wait_For_Sync_l1
	cmp	0x14
	beq	Wait_For_Sync_l1
	rts
;--------------------------------------------------------
; Clear_Palette - clears both palettes
Clear_Palette
	lda	#0
	vbsta	VBXE_BL_ADR0		; setup the blitter for memory fill operation
	vbsta	VBXE_BL_ADR2		; see the description of BCB at the end of this
	lda	#9			; source
	vbsta	VBXE_BL_ADR1
	lda	#1
	vbsta	VBXE_BLITTER_START	; start the blit
	lda	#0
Clear_Palette_l1
	vblda	VBXE_BLITTER_BUSY
	cmp	#0
	bne	Clear_Palette_l1	; wait for blitter to finish
	rts
;--------------------------------------------------------
; Copy_Palette - copies palette, accu = offset to BCB for given palette
Copy_Palette
	vbsta	VBXE_BL_ADR0		; set the blitter start address for
	lda	#0			; 0x8AA where AA is value stored in accumulator
	vbsta	VBXE_BL_ADR2
	lda	#9
	vbsta	VBXE_BL_ADR1
	lda	#1
	vbsta	VBXE_BLITTER_START	; start the blit
	lda	#0
Copy_Palette_l1
	vblda	VBXE_BLITTER_BUSY
	cmp	#0
	bne	Copy_Palette_l1		; wait for blitter to finish
	rts
;--------------------------------------------------------
;Fade_In - fade the palette in one step
; this procedure simply increases each component of each color in palete, untill it matches orginal one
Fade_In
	lda	Pal_ptr			; overlay palette address
	sta	Fade_In_pal1		; setup self modyfying code
	lda	DSTPalette		; destination palette address
	sta	Fade_In_pal2
	sta	Fade_In_pal3
	sta	Fade_In_pal4
	lda	Pal_ptr+1
	sta	Fade_In_pal1+1
	lda	DSTPalette+1
	sta	Fade_In_pal2+1
	sta	Fade_In_pal3+1
	sta	Fade_In_pal4+1

	ldy	#3
Fade_In_l1
	ldx	#0
Fade_In_l2
	lda	0x55AA,x		; orginal palette
Fade_In_pal1	equ *-2
	inc	0xAA55,x
Fade_In_pal2	equ *-2
	cmp	0xAA55,x
Fade_In_pal3	equ *-2
	bcs	Fade_In_Skip
	sta	0xAA55,x
Fade_In_pal4	equ *-2
Fade_In_Skip
	dex
	bne	Fade_In_l2
	inc	Fade_In_pal1+1
	inc	Fade_In_pal2+1
	inc	Fade_In_pal3+1
	inc	Fade_In_pal4+1
	dey
	bne	Fade_In_l1
	rts
;--------------------------------------------------------
;Fade_Out - fade the palette out one step
; this procedure simply decreases each component of each color in palete, untill it matches zero
Fade_Out
	lda	DSTPalette		; destination palette address
	sta	Fade_Out_pal1		; setup self modyfying code
	sta	Fade_Out_pal2
	sta	Fade_Out_pal3
	lda	DSTPalette+1
	sta	Fade_Out_pal1+1
	sta	Fade_Out_pal2+1
	sta	Fade_Out_pal3+1
	lda	#255
	ldy	#3
Fade_Out_l1
	ldx	#0
Fade_Out_l2
	dec	0xAA55,x		; destination, self modyfying code
Fade_Out_pal1	equ *-2
	cmp	0xAA55,x
Fade_Out_pal2	equ *-2
	bne	Fade_Out_Skip
	lda	#0
	sta	0xAA55,x
Fade_Out_pal3	equ *-2
	lda	#255
Fade_Out_Skip
	dex
	bne	Fade_Out_l2
	inc	Fade_Out_pal1+1
	inc	Fade_Out_pal2+1
	inc	Fade_Out_pal3+1
	dey
	bne	Fade_Out_l1
	rts

;--------------------------------------------------------
; data declaration
VBXE_Present
	dta "VBXE found at ",0xff
VBXE_NPresent
	dta "VBXE NOT found!",155,0xff
HexChr
	dta "0123456789ABCDEF"
Buffer
	dta 0
	dta 0,0
Graphics
	dta c'D:DATA>A01.DAP',0
filenamelength	equ *-Graphics
	dta c'D:DATA>A02.DAP',0
	dta c'D:DATA>A03.DAP',0
	dta c'D:DATA>A04.DAP',0
	dta c'D:DATA>A05.DAP',0
	dta c'D:DATA>A06.DAP',0
	dta c'D:DATA>A07.DAP',0
	dta c'D:DATA>A08.DAP',0
	dta c'D:DATA>A09.DAP',0
	dta c'D:DATA>A10.DAP',0
	dta c'D:DATA>A11.DAP',0
	dta c'D:DATA>A12.DAP',0
	dta c'D:DATA>A13.DAP',0
	dta c'D:DATA>A14.DAP',0
	dta c'D:DATA>A15.DAP',0
	dta c'D:DATA>A16.DAP',0

XDL
	dta %01110010,%00000000,0xef,0x00,0x40,0x00,0x40,0x01	; graphics mode,SD resolution, 240 lines, start at 0x04000, 320 bytes/line
	dta %00000000,%10000000					; end of XDL, wait for VSYNC
XDL_Lenght	equ *-XDL
BLT_CLR
	dta 0x00,0x00,0x00	; source address
	dta 0xFF,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x00,0x00	; destination address
	dta 0xFF,0x00		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x00		; width
	dta 0x05		; height
	dta 0x00		; and mask (and mask equal to 0, memory will be filled with xor mask)
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; patter feature
	dta 0x00		; control

BLT_PAL1
	dta 0x00,0x6c,0x01	; source address
	dta 0xFF,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x00,0x00	; destination address
	dta 0xFF,0x00		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x00		; width
	dta 0x02		; height
	dta 0xFF		; and mask
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; patter feature
	dta 0x00		; control

BLT_PAL2
	dta 0x00,0xAC,0x02	; source address
	dta 0xFF,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x00,0x00	; destination address
	dta 0xFF,0x00		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x00		; width
	dta 0x02		; height
	dta 0xFF		; and mask
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; patter feature
	dta 0x00		; control

BLT_PALCP
	dta 0x00,0x00,0x00	; source address
	dta 0xFF,0x00		; source step y
	dta 0x01		; source step x
	dta 0x00,0x03,0x00	; destination address
	dta 0xFF,0x00		; destination step y
	dta 0x01		; destination step x
	dta 0xFF,0x00		; width
	dta 0x02		; height
	dta 0xFF		; and mask
	dta 0x00		; xor mask
	dta 0x00		; collision and mask
	dta 0x00		; zoom
	dta 0x00		; patter feature
	dta 0x00		; control
BLT_Lenght	equ	*-BLT_CLR

frame	dta 0

Graphics_files_low
	dta l(Graphics)
	dta l(Graphics+filenamelength*1)
	dta l(Graphics+filenamelength*2)
	dta l(Graphics+filenamelength*3)
	dta l(Graphics+filenamelength*4)
	dta l(Graphics+filenamelength*5)
	dta l(Graphics+filenamelength*6)
	dta l(Graphics+filenamelength*7)
	dta l(Graphics+filenamelength*8)
	dta l(Graphics+filenamelength*9)
	dta l(Graphics+filenamelength*10)
	dta l(Graphics+filenamelength*11)
	dta l(Graphics+filenamelength*12)
	dta l(Graphics+filenamelength*13)
	dta l(Graphics+filenamelength*14)
	dta l(Graphics+filenamelength*15)
Graphics_files_high
	dta h(Graphics)
	dta h(Graphics+filenamelength*1)
	dta h(Graphics+filenamelength*2)
	dta h(Graphics+filenamelength*3)
	dta h(Graphics+filenamelength*4)
	dta h(Graphics+filenamelength*5)
	dta h(Graphics+filenamelength*6)
	dta h(Graphics+filenamelength*7)
	dta h(Graphics+filenamelength*8)
	dta h(Graphics+filenamelength*9)
	dta h(Graphics+filenamelength*10)
	dta h(Graphics+filenamelength*11)
	dta h(Graphics+filenamelength*12)
	dta h(Graphics+filenamelength*13)
	dta h(Graphics+filenamelength*14)
	dta h(Graphics+filenamelength*15)

Video_Buffer_low
	dta 0x00,0x00
Video_Buffer_mid
	dta 0x80,0x40
Video_Buffer_high
	dta 0x01,0x00
Video_Page
	dta 0x18,0x04
Video_Palette
	dta 21*2,21*1
File_To_load
	dta 0
Active_Buffer
	dta 0
; ---
	run main
