;demonstracja uycia mapy atrybutw

        opt     l-
        icl     'atarihw.ah'
        icl     'atarios.ah'
        opt     l+


        org     $8000

init    cld
        DetectCore
        seq
        jmp     (DOSVEC)
        ResetCore
        rts
        icl     'vbxefx.asm'
        ini     init

        org     $8000

start
        .local

        .zpvar ptr1 .word
        .zpvar ptr2 .word


        ;kopiuj XDL i map koloru do pamici VBXE
        ;adres (w VBXE) 0x00000, w ATARI 0x4000

        fxs     #0 FX_MEMC
        fxs     #MBCE FX_MEMB
        ldx     #xdl_end-xdl_address
        jeq     l4
l3      lda     xdl_load_address-1,x
        sta     xdl_address-1,x
        dex
        jne     l3
l4      mwa     #colormap ptr1
        ldx     #cmap_end-colormap
        jeq     l5
l6      txa
        pha
        lda     xdl_load_address+xdl_end-xdl_address-1,x
        sub     #"0"
        asl
        asl
        tax
        ldy     #0
        lda     cmap_data,x
        sta     (ptr1),y
        iny
        inx
        lda     cmap_data,x
        sta     (ptr1),y
        iny
        inx
        lda     cmap_data,x
        sta     (ptr1),y
        iny
        inx
        lda     cmap_data,x
        sta     (ptr1),y
        iny
        inx
        adw     ptr1 #4
        pla
        tax
        dex
        jne     l6
l5

        ;wcz wywietlanie
        lda     #0
        fxsa    FX_XDL_ADR0
        fxsa    FX_XDL_ADR1
        fxsa    FX_XDL_ADR2
        fxs     #VC_XDL_ENABLED FX_VIDEO_CONTROL
        fxs     #0 FX_MEMB
        rts

        .endl

cmap_data
        .byte   0, 0x0a, 0x94, 0
        .byte   0, 0x0a, 0xf4, 0
        .byte   0, 0x0a, 0x84, 0
        .byte   0x80, 0x0a, 0xc4, 0
        .byte   0, 0x0a, 0x34, 0
        .byte   0, 0x0a, 0x74, 4






;*** XDL ***

;XDL zaaduje si do normalnej pamici ATARI
;nastpnie zostanie skopiowane przy inicjalizacji programu do pamici VBXE
;dodatkowe zaoenie dla uproszczenia:
;wszystkie dane (XDL, ekran, fonty) dostpne
;s z banku nr 0 MEMAC-B
xdl_load_address equ *

        ;aduj poza MEMAC ale asembluj pod adres
        org     $4000,*

;ten adres wskaemy jako pocztek XDL w rejestrach XDL_ADR0,1,2
xdl_pointer equ *-$4000

;ten adres jest pocztkiem XDL widzianego przez okno MEMAC_B
xdl_address equ *

        ;XDLC
        ;24 puste linie od gry ekranu ...
        .word   XDLC_RPTL
        .byte   3*8-1

        ;XDLC
        ;wczam map koloru pokrywajc 192 linie
        ;jednoczenie jest to koniec XDL (XDLC_END)
        .word   XDLC_END + XDLC_RPTL + XDLC_MAPON + XDLC_MAPADR + XDLC_MAPPAR

        ;XDLC_RPTL
        ;razem 192 linie z map koloru
        .byte   191

        ;XDLC_MAPADR
        ;adres mapy koloru bezporednio za XDL w pamici VBXE
        .long   colormap - $4000
        ;krok adresu mapy
        .word   20*4

        ;XDLC_MAPPAR
        .byte   0 ;hscroll mapy
        .byte   0 ;vscroll mapy
        .byte   15 ;szeroko pola 16 punktw
        .byte   15 ;wysoko pola 16 punktw

        ;koniec XDL
xdl_end equ *

        ;dane mapy koloru
        ;zostan te przekopiowane do pamici VBXE
colormap  equ *
        .byte   "44441111000022225555"
        .byte   "44411110000002222555"
        .byte   "44111100000000222255"
        .byte   "41111000000000022225"
        .byte   "11110000000000002222"
        .byte   "11100000000000000222"
        .byte   "11000000000000000022"
        .byte   "10000000033000000002"
        .byte   "00000000333300000000"
        .byte   "00000003333330000000"
        .byte   "00000033333333000000"
        .byte   "00000333333333300000"
cmap_end equ *
;---------------------------------------------------------------------

        run     start

        end
