#!/bin/sh

#Locate CC65
export CC65_HOME=/usr/share/cc65

echo "Compiling mainline code: main.c to clm1.s ..."
cc65 -O2 -t atari5200  -o build/clm1.s main.c 

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

echo "Assembling main source: clm1.asm to clm1.o ..."
ca65 -t atari5200 -o build/clm1.o build/clm1.s

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

echo "Assembling the supplementary routines: rmt_sup.asm to clm_sup.o ..."
ca65 -t atari5200 -o build/clm_sup.o rmt_sup.asm

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

echo "Assembling data..."
ca65 -t atari5200 -o build/data.o data.s
#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi


echo "Linking to culomin5200.bin"
ld65 -C linker.cfg --mapfile map.txt -o culomin5200.bin build/clm_sup.o build/clm1.o build/data.o atari5200.lib

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

